/* @(#)x25_pk.h 6.29 92/09/16 */

/* ICNCFIX by -WFP- for ANSI C compliance. bug 1103185 */

#ifndef _NETX25_X25_PK_H
#define _NETX25_X25_PK_H

#include <sys/types.h>
#include <sys/mbuf.h>

/* end of part of fix */

#define EFASTDATA	82	  /* Fast select data available */
#define MAXLCN		4095	  /* Maximum number of lcns supported */
#define MAXHOSTADR	15	  /* Maximum host address length */
#define MAXMASK		16	  /* Maximum mask length for protocol id */
#define MAXDATA		(MLEN-10) /* maximum user data in a CONN_DB */
#define MAX_USER_DATA	124	  /* Maximum user data read/written at a time */
#define ANY_LINK	0x80	  /* Wild card for link */
#define	ANY_SUBADDRESS	0x40	  /* Wild card for subaddress */
#define	EXACT_MATCH	0x80	  /* Protocol must match exactly */
#define	ADR_LEN_MASK	0x3f	  /* Mask for address length field */
#define SUBADR_ONLY	0x80	  /* Subaddress only in calling address */
#define MAX_DNIC_SIZE	MAXHOSTADR/* For generality */

/* Address and user data specified by user in bind request
 */
typedef struct conn_db_s {
	u_char	hostlen;
	u_char	host[(MAXHOSTADR+1)/2];
	u_char  datalen;
	u_char	data[MAXDATA];
} CONN_DB;


/* Facility options specified by user, retained for backward compatibility
 * with SunLink X.25 6.0.  Note this facility can be used to specify only
 * normal CUG facility and normal RPOA facility.
 */
typedef struct facility_dB_S {
	u_char    reverse_charge;
                        /* 0 = don't request/allow reverse charging
                         * 1 = reverse charge request/allowed
                         */
        u_short   recvpktsize;
                        /* 0= default recv packet size.
                         * 16, 32, 64, 128,
                         * 256, 512, 1024
                         * ( octets in decimal )
                         */
        u_short   sendpktsize;
                        /* same as for recvpktsize, but for send packet size
			 */
        u_char    recvwndsize;
                        /* 0= default recv window size.
                         * 7, 127 ( in decimal )
                         */
        u_char    sendwndsize;
                        /* same as for recvwndsize, but for send window size
			 */
        u_char    recvthruput;
                        /* 0= default recv throughput.
                         * 3= 75    8= 2400
                         * 4= 150   9= 4800
                         * 5= 300  10= 9600
                         * 6= 600  11= 19200
                         * 7= 1200 12= 48000
                         * ( bps in decimal )
                         */
        u_char    sendthruput;
                        /* same as above, but for send throughput
			 */
        u_char    cug_req;
                        /* 0 = no closed user group
                         * 1 = use closed user group in cug_index
			 */
        u_char    cug_index;
                        /* valid when cug_req= 1.
                         * 0x00 ~ 0x99 ( closed user group in BCD)
                         */
	u_char    fast_select_type;
			/*
			 * Fast select options
			 */

        u_char    rpoa_req;
                        /* 0= no RPOA transit request
                         * 1= use RPOA transit request in rpoa
                         */
        u_short   rpoa;
                        /* valid when rpoa_req= 1
                         * 0x0000 ~ 0x9999 (RPOA transit group in BCD)
			 */
	u_char	stdservice;
			/* basic service when stdservice = 0
			 * std service when != 0
			 */
	u_char	osiservice;
			/* dynamic SVC's for OSI above when !0
			 */
	u_char	precedence_req;
			/* no precedence when = 0
			 * else precedence level
			 */
	u_char	precedence;
			/* valid when precedence_req = 1
			 */
} FACILITY_DB;


/* The current way is to specify facilities individually.  The following
 * data structures are used.
 */

/* packet sizes allowed are 0 (default), 16, 32, 64, 128, 256, 512, 1024,
 * 2048, 4096
 */
typedef struct packet_size_s {
	u_short	sendpktsize;	
	u_short	recvpktsize;
} PACKET_SIZE;

/* window sizes allowed are 0 (default), 1-7 (normal), 1-127 (extended)
 */
typedef struct window_size_s {
	u_char	sendwndsize;
	u_char	recvwndsize;
} WINDOW_SIZE;

/* throughput values allowed are
 *	0 (default),	3 (75) ,	4 (150),	5 (300),
 *	6 (600),	7 (1200),	8 (2400),	9 (4800),
 *	10 (9600),	11 (19200),	12 (48000)
 */
typedef struct throughput_s {
	u_char	sendthruput:4;
	u_char	recvthruput:4;
} THROUGHPUT;


typedef struct cug_s {
	u_char	cug_req;
#define	CUG_NONE	0	/* no CUG */
#define	CUG_REQ		1	/* CUG */
#define	CUG_REQ_ACS	2	/* CUG with outgoing access */
#define	CUG_BI		3	/* bilateral CUG */
	u_short	cug_index;
} CUG;


typedef struct rpoa_s {
	u_char	nrpoa;			/* number of RPOAs requested */
#define MAX_RPOA	3
	u_short	rpoa_index[MAX_RPOA];	/* rpoas; nrpoa = 1 => normal format */
} RPOA;

/* Zero value for a field means the field is not specified; if a field
 * has zero value, that and the following fields are not sent.
 */
typedef struct ete_tr_delay_s {
	u_short req_delay;
	u_short desired_delay;
	u_short max_delay;
} ETE_TR_DELAY;


typedef struct nui_s {
	u_char	nui_len;		/* NUI length */
#define MAX_NUI	64

/* ICNCFIX by -WFP- for ANSI C compliance. bug 1103185 */

	/*
	u_char	nui_data[MAX_NUI]
	*/
	
	u_char	nui_data[MAX_NUI];	/* NUI */

/* end of part of fix */

} NUI;


typedef struct charge_info_s {
	u_char		charge_len;
#define MAX_CHARGE_INFO	64
	u_char		charge_data[MAX_CHARGE_INFO];
} CHARGE_INFO;


typedef struct call_redir_s {
	u_char	cr_reason;
	u_char	cr_hostlen;
	u_char	cr_host[(MAXHOSTADR+1)/2];
} CALL_REDIR;


typedef struct aef_s {
	u_char			aef_type;
#define AEF_NONE		0
#define AEF_NSAP		1
#define AEF_PARTIAL_NSAP	2
#define AEF_NON_OSI		3
	u_char			aef_len;
#define MAX_AEF			40
	u_char			aef[(MAX_AEF+1)/2];
} AEF;


typedef struct precedence_s {
	u_char	precedence_req;	/* no precedence when = 0
				 * else precedence level
				 */
	u_char	precedence;	/* valid when precedence_req = 1
				 */
} PRECEDENCE;


typedef struct private_fact_s {
	u_char		p_len;		/* total length of facilities
					 */
#define MAX_PRIVATE	64
	u_char		p_fact[MAX_PRIVATE];
					/* facilities exactly as they
					 * are present in Call Request or
					 * Call Accept packets
					 */
} PRIVATE_FACT;


typedef struct facility_s {
    u_int	type;
#define	T_FACILITIES		0x00000001
#define	T_REVERSE_CHARGE	0x00000002
#define	T_FAST_SELECT_TYPE	0x00000003
#define	T_PACKET_SIZE		0x00000004
#define	T_WINDOW_SIZE		0x00000005
#define	T_THROUGHPUT		0x00000006
#define T_CUG			0x00000007
#define T_RPOA			0x00000008
#define T_TR_DELAY		0x00000009
#define	T_MIN_THRU_CLASS	0x0000000a
#define	T_ETE_TR_DELAY		0x0000000b
#define	T_NUI			0x0000000c
#define	T_CHARGE_REQ		0x0000000d
#define	T_CHARGE_MU		0x0000000e
#define	T_CHARGE_SEG		0x0000000f
#define	T_CHARGE_DUR		0x00000010
#define T_LINE_ADDR_MOD		0x00000011
#define T_CALL_REDIR		0x00000012
#define T_EXPEDITED		0x00000013
#define T_CALLED_AEF		0x00000014
#define T_CALLING_AEF		0x00000015
#define T_STDSERVICE		0x00000016
#define T_OSISERVICE		0x00000017
#define T_PRECEDENCE		0x00000018
#define T_PRIVATE		0x00000019

    union {
	u_int		facilities;	/* quick way to check if a facility
					 * is present
					 */
#define	F_REVERSE_CHARGE	0x00000001
#define	F_FAST_SELECT_TYPE	0x00000002
#define	F_PACKET_SIZE		0x00000004
#define	F_WINDOW_SIZE		0x00000008
#define	F_THROUGHPUT		0x00000010
#define F_MIN_THRU_CLASS	0x00000020
#define F_CUG			0x00000040
#define F_RPOA			0x00000080
#define F_TR_DELAY		0x00000100
#define F_ETE_TR_DELAY		0x00000200
#define F_NUI			0x00000400
#define F_CHARGE_REQ		0x00000800
#define F_CHARGE_MU		0x00001000
#define F_CHARGE_SEG		0x00002000
#define F_CHARGE_DUR		0x00004000
#define F_LINE_ADDR_MOD		0x00008000
#define F_CALL_REDIR		0x00010000
#define F_EXPEDITED		0x00020000
#define F_CALLED_AEF		0x00040000
#define F_CALLING_AEF		0x00080000
#define F_STDSERVICE		0x00100000
#define F_OSISERVICE		0x00200000
#define	F_PRECEDENCE		0x00400000
#define F_PRIVATE		0x00800000

/* ICNCFIX by -TH- for bug1076801.  There is no actual fix here, but just in
   case someone wants to extend the fields used, these have already been 
   extended in x25_fact.c as follows:

#define F_PACKET_SIZE_SET       0x01000000
#define F_WINDOW_SIZE_SET       0x02000000
#define F_THROUGHPUT_SET        0x04000000

This may not leave a lot of space for additional fields!!

End of fix (comment) */

	u_char		reverse_charge;
					/* permit/request reverse charge */

	u_char		fast_select_type;
#define FAST_OFF	0		/* don't use fast select */
#define FAST_CLR_ONLY	1		/* restricted response */
#define FAST_ACPT_CLR	2		/* unrestricted response */

	PACKET_SIZE	packet_size;	/* packet sizes */

	WINDOW_SIZE	window_size;	/* window sizes */

	THROUGHPUT	throughput;	/* used for throughput negotiation */

	THROUGHPUT	min_thru_class;	/* minimum throughput class */

	CUG		cug;		/* closed user group */

	RPOA		rpoa;		/* RPOA specification */

	u_short		tr_delay;	/* network transit delay */

	ETE_TR_DELAY	ete_tr_delay;	/* end-to-end transit delay */

	NUI		nui;		/* network user identification */

	u_char		charge_req;	/* request charging info */

	CHARGE_INFO	charge_mu;	/* charging info, monetary unit */

	CHARGE_INFO	charge_seg;	/* charging info, segment */

	CHARGE_INFO	charge_dur;	/* charging info, call duration */

	u_char		line_addr_mod;	/* called line addr modified */

	CALL_REDIR	call_redir;	/* call redirection notification */

	u_char		expedited;	/* expedited data negotiation */

	AEF		called_aef;	/* called aef */

	AEF		calling_aef;	/* calling aef */

	u_char		osiservice;	/* set when VC carries CLNP data */

	u_char		stdservice;	/* set for DDN services */

	PRECEDENCE	prec;		/* precedence for standard services */

/* ICNCFIX by -WFP- for bug 1069433 */

	/*
	PRIVATE_FACT    private;
	*/

	PRIVATE_FACT	privat;		/* non-X.25 local/remote facilities */

#ifndef __cplusplus
#ifndef private
#define private privat /* for backward C compatibility */
#endif
#endif

/* end of part of fix */

    } facility;

} FACILITY;

/* Some convenient definitions.
 */
#define f_facilities		facility.facilities
#define f_reverse_charge	facility.reverse_charge
#define f_fast_select_type	facility.fast_select_type
#define f_packet_size		facility.packet_size
#define f_recvpktsize		facility.packet_size.recvpktsize
#define f_sendpktsize		facility.packet_size.sendpktsize
#define f_window_size		facility.window_size
#define f_recvwndsize		facility.window_size.recvwndsize
#define f_sendwndsize		facility.window_size.sendwndsize
#define f_throughput		facility.throughput
#define f_recvthruput		facility.throughput.recvthruput
#define f_sendthruput		facility.throughput.sendthruput
#define f_min_thru_class	facility.min_thru_class
#define f_min_recvthruput	facility.min_thru_class.recvthruput
#define f_min_sendthruput	facility.min_thru_class.sendthruput
#define f_cug			facility.cug
#define f_cug_req		facility.cug.cug_req
#define f_cug_index		facility.cug.cug_index
#define f_rpoa			facility.rpoa
#define f_nrpoa			facility.rpoa.nrpoa
#define f_rpoa_index		facility.rpoa.rpoa_index
#define f_tr_delay		facility.tr_delay
#define f_ete_tr_delay		facility.ete_tr_delay
#define f_req_delay		facility.ete_tr_delay.req_delay
#define f_desired_delay		facility.ete_tr_delay.desired_delay
#define f_max_delay		facility.ete_tr_delay.max_delay
#define f_nui			facility.nui
#define f_charge_req		facility.charge_req
#define f_charge_mu		facility.charge_mu
#define f_charge_seg		facility.charge_seg
#define f_charge_dur		facility.charge_dur
#define f_line_addr_mod		facility.line_addr_mod
#define f_call_redir		facility.call_redir
#define f_cr_reason		facility.call_redir.cr_reason
#define f_cr_hostlen		facility.call_redir.cr_hostlen
#define f_cr_host		facility.call_redir.cr_host
#define f_expedited		facility.expedited
#define f_called_aef		facility.called_aef
#define f_cd_aef_type		facility.called_aef.aef_type
#define f_cd_aef_len		facility.called_aef.aef_len
#define f_cd_aef		facility.called_aef.aef
#define f_calling_aef		facility.calling_aef
#define f_cg_aef_type		facility.calling_aef.aef_type
#define f_cg_aef_len		facility.calling_aef.aef_len
#define f_cg_aef		facility.calling_aef.aef
#define f_osiservice		facility.osiservice
#define f_stdservice		facility.stdservice
#define f_prec			facility.prec
#define f_precedence_req	facility.prec.precedence_req
#define f_precedence		facility.prec.precedence

/* ICNCFIX by -WFP- for bug 1069433 */

/*
#define f_private		facility.private
*/

#define f_private		facility.privat

/* end of part of fix */

/* LLC MAC address/LSEL
 */
typedef struct {
	u_char	lsel;
	u_char	maclen;
#define MACADDR_LEN	6
	u_char	macaddr[MACADDR_LEN];
} X25_MACADDR;


#define Q_BIT		3
#define D_BIT		2
#define M_BIT		0

/* Control block for reading/writing user data */

typedef struct user_data_db_s {
	u_char		datalen;
	u_char 		data[MAX_USER_DATA];/* if 126, total size is 128(i.e. 0
				   	     * in ioctl(X25_WR_USER_DATA) ) */
} USER_DATA_DB;

/* Comtrol block for setting mask */

typedef struct mask_data_bd_s {
	u_char		masklen;
	u_char 		mask[MAXMASK];
} MASK_DATA_DB;

/* Level 2 statistics */

/* X25_L12_STAT_DB is kept around for backward compatibility.
 */
typedef struct x25_l12_stat_db_s {
	u_short	state;
	u_short                 hs_sentsabms;   /* sabms sent  */
        struct ss_dstats        hs_data;        /* data stats  */
        struct ss_estats        hs_errors;      /* error stats */
} X25_L12_STAT_DB;

/* X25_LINK_STAT_DB can be used to query stats for a specific HDLC
 * link.  This won't work for LLC type links.
 */
typedef struct x25_link_stat_db_s {
	int	linkid;
	u_short	state;
	u_short                 hs_sentsabms;   /* sabms sent  */
        struct ss_dstats        hs_data;        /* data stats  */
        struct ss_estats        hs_errors;      /* error stats */
} X25_LINK_STAT_DB;

/* The following is used to cycle through all the interfaces - static
 * HDLC links as well as dynamic LLC2 links.
 */
typedef struct x25_next_link_stat_s {
	u_char		opt;		/* search option */
#define	GET_FIRST	0		/* get first one */
#define	GET_NEXT	1		/* get next one */
	u_char		specific;	/* applies to specified interface */
	u_char		link_type;	/* HDLC_TYPE, LLC_TYPE */
	int		linkid;		/* interface id */
        X25_MACADDR	mac;		/* remote mac for LLC_TYPE link */

	u_short		state;		/* 0: initial state
					 * 1: SABM outstanding
					 * 2: FRMR outstanding
					 * 3: DISC outstanding
					 * 4: information transfer state
					 */
	u_short                 hs_sentsabms;   /* sabms sent  */
        struct ss_dstats        hs_data;        /* data stats  */
        struct ss_estats        hs_errors;      /* error stats */
} X25_NEXT_LINK_STAT;

/* Level 3 status */

/* X25_L3_STAT_DB is kept around for backward compatibility..
 */
typedef struct x25_l3_stat_db_s {
        u_short  lcn;		/* logical channel to return */
	u_char	state;		/* level 3 lcn state */
	u_char	sub_state;	/* level 3 lcn sub_state */
        u_char  intcnt;		/* number of received interrupt datum */
        u_char  resetcnt;	/* times of virtual circuit reset */
        int     sendpkts;	/* number of output packets */
        int     recvpkts;	/* number of input  packets */
} X25_L3_STAT_DB;

/* X25_PKT_STAT_DB is used to query statistics for a specific call
 * over HDLC links.  This won't work for VCs over LLC links.
 */
typedef struct x25_pkt_stat_db_s {
	int	linkid;
        u_short lcn;		/* logical channel to return */
	u_char	state;		/* level 3 lcn state */
	u_char	sub_state;	/* level 3 lcn sub_state */
        u_char  intcnt;		/* number of received interrupt datum */
        u_char  resetcnt;	/* times of virtual circuit reset */
        int     sendpkts;	/* number of output packets */
        int     recvpkts;	/* number of input  packets */
	short	pgrp;		/* process group, if any */
	short	flags;		/* various flags for future */
} X25_PKT_STAT_DB;

/* X25_NEXT_VC_STAT is used to cycle through all the virtual circuits,
 * over HDLC as well as LLC type links.
 */
typedef struct x25_next_vc_stat_s {
	u_char		opt;		/* search option */
	u_char		specific;	/* applies to specified linkid */
	u_char		link_type;	/* HDLC_TYPE, LLC_TYPE */
	int		linkid;		/* link id */
        u_short		lcn;		/* logical channel to return */
	u_char		state;		/* level 3 lcn state */
#define ST_OFF			0
#define ST_LISTEN		1
#define ST_READY		2
#define ST_SENT_CALL		3
#define ST_RECV_CALL		4
#define ST_CALL_COLLISION	5
#define ST_RECV_CLR		6
#define ST_SENT_CLR		7
#define ST_DATA_TRANSFER	8
#define ST_SENT_RES		9
	u_char		sub_state;	/* level 3 lcn sub_state */
#define RECV_RNR	0
#define RECV_INT	1
#define SENT_INT	2
#define SENT_RNR	3
        u_char		intcnt;		/* number of received interrupts */
        u_char		resetcnt;	/* times of virtual circuit reset */
        int		sendpkts;	/* number of output packets */
        int		recvpkts;	/* number of input  packets */
	short		pgrp;		/* process group, if any */
	short		flags;		/* various flags for future */
#define	INCOMING_CALL	0x01
#define	IS_A_PVC	0x02
	struct sockaddr	sa;		/* Remote X.121/IP address */
	AEF		aef;		/* Remote AEF, if any */
	X25_MACADDR	mac;		/* Remote mac for LLC links */
} X25_NEXT_VC_STAT;

/* Structures for address representation */

typedef struct conn_data_s {
	u_char	datalen;
	u_char	data[16];
} CONN_DATA;

/* CONN_ADR structure applies to the old style ioctls.
 * New ioctls use LINK_ADR structure.
 */
typedef struct conn_adr_s {
	u_char	hostlen;	/* length of BCDs */
	u_char	host[(MAXHOSTADR+1)/2];
} CONN_ADR;

typedef struct link_adr_s {
	int	linkid;		/* id of link */
	u_char	hostlen;	/* length of BCDs */
	u_char	host[(MAXHOSTADR+1)/2];
} LINK_ADR;

typedef struct conn_lcncb_s {
	u_char	masklen;
	u_char 	mask[MAXMASK];
} CONN_LCNCB;

typedef struct reset_conn_s {
	int	linkid;
	int 	lcn;
} RESET_CONN;

/* Level 2 parameters - this is an exact copy of the data structure in
 *			netdlc/hdlc_ioctl.h, and this must be remembered
 *			if the data structurs are to be changed.
 */
typedef struct hdlc_param_s {
        u_short hp_t1;          /* T1 - P-bit timer (msec) */
        u_short hp_t2;          /* T2 - max delay before ACK (msec) */
        u_short hp_t3;          /* T3 - max idle link time (msec) */
        u_short hp_t4;          /* T4 - LLC2 busy timer (msec) */
        u_short hp_t5;          /* T5 - LLC2 reject timer (msec) */
        u_short hp_t6;          /* T6 - Ack timer (msec) */
        u_short hp_tick;        /* resolution of timer (msec/tick) */
        u_short hp_n1;          /* N1 - max frame size - bytes */
        u_char  hp_n2;          /* N2 - max retries (used with T1, T4) */
        u_char  hp_xcntl;       /* extended control - mod 128 */
        u_char  hp_k;           /* K - window size */
        u_char  hp_addr;        /* address */
} HDLC_PARAM;

/* Level 3 parameters */

typedef struct l3_param_s {

	CONN_ADR host;
		/* see above CONN_ADR definition
		*/

        u_char  packet_sequence;
                /* modulo sequence of level 3. suggested= 8
                 * 8, 128 ( in decimal )
                 */

        u_char  default_wndsize;
                /* default window size for every virtual circuit
                 * suggested= 2
                 * 1 ~ 7   if packet_sequence= 8
                 * 1 ~ 127 if packet_sequence= 128
                 * ( in decimal )
                 */

        u_char    default_thruput;
                /* default throughput for every virtual circuit.
                 * suggested= 10 ( 9600 bps )
                 * 3= 75    8= 2400
                 * 4= 150   9= 4800
                 * 5= 300  10= 9600
                 * 6= 600  11= 19200
                 * 7= 1200 12= 48000
                 * ( bps in decimal )
                 */

	u_short   default_pktsize;
                /* default packet size
                 * suggested value= 128
                 * 16, 32, 64, 128, 256, 512, 1024, 2048, or 4096
                 */

                /* groups 0 and 1 are reserved for permanent virtual
                 * circuits. Total number of active virtual circuits
                 * is no more than 64.
                 */
        u_short  lic; /* lowest  one-way incoming lcn. suggested= 512 */
        u_short  hic; /* highest one-way incoming lcn. suggested= 512 */
        u_short  ltc; /* lowest  two-way lcn. suggested= 512 */
        u_short  htc; /* highest two-way lcn. suggested= 575 */
        u_short  loc; /* lowest  one-way outgoing lcn. suggested= 575 */
        u_short  hoc; /* highest one-way outgoing lcn. suggested= 575 */
                /* 4095 >= hoc >= loc
                 *      >= htc >= ltc
                 *      >= hic >= lic >= 1
                 * ( in decimal )
                 */
	u_char  t0; /* timeout limit after sending RESTART request
                     * packet. suggested= 180 ( seconds )
                     */
        u_char  t1; /* timeout limit after sending CALL request
                     * packet. suggested= 200 ( seconds )
                     */
        u_char  t2; /* timeout limit after sending RESET request
                     * packet. suggested= 180 ( seconds )
                     */
        u_char  t3; /* timeout limit after sending CLEAR request
                     * packet. suggested= 180 ( seconds )
                     */
                /* 1 ~ 255 ( seconds in decimal ) for above four fields */

        u_char  t0_retries;
        u_char  t1_retries;
        u_char  t2_retries;
        u_char  t3_retries;
                /* number of retries before reporting error status
                 * to X.25 MGMT socket.
                 * 1 ~ 255 ( attemps in decimal ) for above four fields
                 */
	u_short	sendspace;
	u_short	recvspace;

	u_char	D_bit;

	u_char	dst_opt;	/* called address options for local calls */
				/*   used only if automatic routing is on */
#define	DST_ALL		0	/* use whole address */
#define	DST_DTEADR	1	/* dte address only for local calls */

	u_char	src_opt;	/* calling address options */
				/*   always used */
#define	SRC_ALL		0	/* use the whole address */
#define	SRC_DTEADR	1	/* use dte address */
#define	SRC_SUBADR	2	/* use subaddress only */

	u_char	prefix_opt;	/* use of prefix digit */
#define	PREFIX_NO	0	/* don't use dnic_prefix */
#define PREFIX_YES	1	/* prepend dnic_prefix for all calls */

	u_char	dnic_prefix;	/* dnic_prefix digit: value 0 - 9 */

	u_char	dnic_len;	/* length of DNIC */
	u_char	dte_addr_len;	/* length of DTE addr */

	u_char	flow_negotiate;	/* If 1, negotiate flow control */

	u_char	thru_negotiate;	/* If 1, negotiate throughput */

	u_char	mode;		/* link mode - DTE, DCE, or DTNAMIC */
#define	DTE_MODE	0	/* link acts as DTE */
#define DCE_MODE	1	/* link acts as DCE */

} L3_PARAM;


/* Control block for initializing x25 */

typedef struct x25_sysgen_db_s {
	int		linkid;	  /* id of link to initialize */
	int		on;	  /* 1 = on, 0 = off */
	int		dontwait; /* if 1, don't wait for link to come up */
	int		version;  /* currently 1980 or 1984 version */
#define V_1980		0
#define V_1984		1
	u_char		link_type;/* type of link, hdlc or llc */
#define	HDLC_TYPE	0
#define LLC_TYPE	1
	u_char		lsel;	  /* lsel if linktype is llc */
	L3_PARAM	l3;	  /* level 3 parameters */
	HDLC_PARAM	hdlc;	  /* level 2 parameters */
} X25_SYSGEN_DB;

/* ICNCFIX by -TH- for ISO8882 conformace.  Add structures to serve the
   ioctl for setting the T26 timer.   PATCH_1 */
typedef	struct x25_t26_s {
	int		linkid;
	u_char		t26;
} X25_T26;
/* End of fix */

/* ICNCFIX by -TH- for ISO8882 conformance.  Add structure to allow the setting
   of ISO8208  */
typedef struct x25_iso8208_s {
	int 		linkid;
	u_char		iso8208;
} X25_ISO8208;
/* End of fix */

/* ICNCFIX by -TH- to allow configuring of packet layer restart on link reset */
typedef struct x25_restart_on_reset_s {
	int		linkid;
	u_char		restart;
} X25_RESTART_ON_RESET;
/* End of fix */

/* PVC statistics */

typedef struct pvc_db_s {
	u_short	lcn;		/* lcn of PVC */
	u_short  sendpktsize;	/* Maximum packet size*/
	u_short  recvpktsize;	/* Maximum packet size*/
	u_char  sendwndsize;	/* Output flow control window*/
	u_char  recvwndsize;	/* Input flow control window*/
} X25_PVC_DB;

/* ICNCFIX by -WFP- for a selectable non-blocking X25_SETUP_PVC ioctl.
 * RFE 1109612.
 */

/* below is the mask used to set the most significant bit of the lcn field in
 * the X25_PVC_DB structure.
 * this is done for backward compatibility, and is possible because there is
 * a limit on the number of LCNs (strictly less than 0x1000).
 */

#define NON_BLOCKING_SETUP_PVC  0x8000

/* end of part of fix */

/* Control block to set/read socket high-water marks */

typedef struct so_hiwat_db_s {
	short	sendhiwat;
	short	recvhiwat;
} SO_HIWAT_DB;

/* Control block to read/set diag code */

typedef struct x25_cause_diag_s {
	u_char	flags; 
#		define RECV_DIAG 	0
#		define DIAG_TYPE	1
#		define WAIT_CONFIRMATION 2
		/* bit 0 (RECV_DIAG)= 
		 *	0: no cause and diagnostic codes
		 *	1: receive cause and diagnostic codes.
		 * bit 1 (DIAG_TYPE)= 
		 *	0: reset cause and diagnostic codes in data array
		 *	1: clear cause and diagnostic codes in data array
		 * bit 2 (WAIT_CONFIRMATION)= 
		 *	0: no wait after X25_WR_DIAG_CODE ioctl
		 *	1: wait returned cause and diagnostic codes after 
		 *	   X25_WR_DIAG_CODE ioctl.
		 */
	u_char	datalen; /* byte count of data array */
	u_char	data[64];
} X25_CAUSE_DIAG;

/* Routing entry */

typedef struct x25_route_s {
	caddr_t		index;		/* used for reading next route */
	u_char		r_type;
#define	R_NONE		0
#define	R_X121_HOST	1
#define	R_X121_PREFIX	2
#define	R_AEF_HOST	3
#define	R_AEF_PREFIX	4
#define	R_AEF_SOURCE	5
	CONN_ADR	x121;
	u_char		pid_len;
#define	MAX_PID_LEN	4
	u_char		pid[MAX_PID_LEN];
	AEF		aef;
	int		linkid;
	X25_MACADDR	mac;
	int		use_count;
	char		reserved[16];
} X25_ROUTE;

/* ICNCFIX by -WFP- to support the 6.x X25_RD_LCN_INFO ioctl. bug 1098574 */

/* This is the old style.  Replaced by LCN_INFO.
 */
typedef struct lcn_db_s {
	short	active_lcns;
	short	largest_pvc;
	short	largest_incoming_svc;
	short	smallest_outgoing_svc;
} LCN_DB;

typedef struct lcn_info_s {
	int	linkid;
	short	active_lcns;
	short	largest_pvc;
	short	largest_incoming_svc;
	short	smallest_outgoing_svc;
} LCN_INFO;

/* end of part of fix */

/* ICNCFIX by -WFP- so that a DCE receiving packets on a PVC over which nothing
 * is attached, does not ignore them. Bug 1109613.
 */

/* see table 6 of the ISO 8208 International Standard.
 */
#define RESET_NETWORK_CONGESTION	0x07
#define RESET_NETWORK_OPERATIONAL	0x0F
#define RESET_NETWORK_OUT_OF_ORDER	0x1D

/* end of part of fix */

/* ICNCFIX by -WFP- for ANSI C compliance. bug 1103185 */

#endif /* _NETX25_X25_PK_H */

/* end of part of fix */

