/* @(#)llct.h 1.4 91/01/11 */


/* Message formats.
 */

typedef struct llct_msg {
	u_char		req;
} LLCT_MSG;

typedef struct llct_msg_bind {
	u_char		req;
	u_char		lsel;
	u_char		type;
	u_char		use_intr;
} LLCT_MSG_BIND;

typedef struct llct_msg_listen {
	u_char		req;
} LLCT_MSG_LISTEN;

typedef struct llct_msg_ctl {
	u_char		req;
	u_char		cmd;
	u_char		pf;
	u_char		d_lsel;
	u_char		d_macaddr[6];
	u_char		data[1];
} LLC_MSG_CTL;

typedef struct llct_msg_connect {
	u_char		req;
	u_char		d_lsel;
	u_char		d_macaddr[6];
} LLCT_MSG_CONNECT;

typedef struct llct_msg_data {
	u_char		req;
	u_char		data[1];
} LLCT_MSG_DATA;

typedef struct llct_msg_close {
	u_char		req;
} LLCT_MSG_DISCONNECT;


/* Requests
 */

#define	LLCT_REQ_BIND		1
#define LLCT_REQ_LISTEN		2
#define LLCT_REQ_TEST		3
#define LLCT_REQ_XID		4
#define LLCT_REQ_CONNECT	5
#define LLCT_REQ_DATA		6
#define LLCT_REQ_DISCONNECT	7
