/* @(#)x25_sys.h 6.29 92/09/16 */

/* ICNCFIX by -WFP- for ANSI C compliance. bug 1103185 */

#ifndef _NETX25_X25_SYS_H
#define _NETX25_X25_SYS_H

#include <sys/mbuf.h>
#include <sys/types.h>
#include <sys/socketvar.h>
#include <net/if.h>

/* end of part of fix */

#define MT_X25		MT_DATA	/* mbuf type used by x25 */
#define LCNHASHSIZE	32	/* Size of hash table, must be power of 2 */
#define HASHMASK	(LCNHASHSIZE - 1) /* Must be all 1s */
#define MAX_LCN		4095

/* max data field length*/

#define USER_DATA_MAX     128

/* LLC2 related defines */

#define X25_IDLETIMEOUT	30

/* General format indicator types: modulo 8 & modulo 128 seq numbers */

#define GFI_8		1
#define GFI_128		2

/* Structures used for packet assembly */

typedef struct data_pkt8_s {
	u_char		byte1;
	u_char		byte2;
	u_char		byte3;

	/* Bit format is as follows:
	 *
	 * unsigned	q_bit:1;
	 * unsigned	d_bit:1;
	 * unsigned	gfi:2;
	 * unsigned	lcn:12;
	 * unsigned	pr:3;
    	 * unsigned 	m_bit:1;
    	 * unsigned 	ps:3;
    	 * unsigned 	z:1;
	 */
} DATA_PKT8;

typedef struct data_pkt128_s {
 	u_char		byte1;
	u_char		byte2;
	u_char		byte3;
	u_char		byte4;

	/* Bit format is as follows:
	 *
	 * unsigned        q_bit:1;
	 * unsigned        d_bit:1;
	 * unsigned        gfi:2;
	 * unsigned        lcn:12;
	 * unsigned        ps:7;
	 * unsigned        z:1;  
	 * unsigned        pr:7;
	 * unsigned        m_bit:1;
	 */
} DATA_PKT128;


/* definitions of packet type identifiers */

#define RR_PID		0x1
#define RNR_PID		0x5

#define CALL_REQ_PID	0xb 
#define INCOM_CALL_PID	0xb 
#define CALL_ACPT_PID	0xf
#define CALL_CONN_PID	0xf

#define CLR_REQ_PID	0x13
#define CLR_IND_PID	0x13
#define CLR_CONF_PID	0x17

#define RES_REQ_PID	0x1b
#define RES_IND_PID	0x1b
#define RES_CONF_PID	0x1f

#define INT_PID		0x23
#define INT_CONF_PID	0x27

#define DIAG_PID	0xf1

#define RST_REQ_PID	0xfb 
#define RST_IND_PID	0xfb 
#define RST_CONF_PID	0xff

/* ICNCFIX by -TH- for ISO8882 conformance.  This is an unfortunate choice
   of PID as this can be mistaken for an RR if checking is being done.  Since
   this is internal to x25_in.c and is not sent out, it should be simple
   to redefine it.  0x91 should be sufficient.  PATCH_15
#define NULL_PID	0x81 */
#define NULL_PID	0x91
/* End of fix */

/* DTE facilities markers definitions
 */
#define FAC_NON_X25_LOCAL       0x00
#define FAC_NON_X25_REMOTE      0xff
#define FAC_CCITT_DTE           0x0f

/* CCITT specified facility codes and bit masks
 */
#define	FAC_CALLING_AEF		0xcb
#define	FAC_CALLED_AEF		0xc9
#define	FAC_MIN_THRU_CLASS	0x0a
#define FAC_ETE_TR_DELAY	0xca
#define FAC_EXPEDITED		0x0b

#define	AEF_TYPE_MASK		0xc0
#define	FULL_NSAP		0x00
#define	PARTIAL_NSAP		0x40
#define	NON_OSI_AEF		0x80

/* definitions of facility codes and bit masks
 */
#define FAC_STDSERVICE			0x04
#define	BIT_STDSERVICE			0x01
#define FAC_PRECEDENCE			0x08

#define FAC_PKT_SIZE			0x42
#define FAC_WND_SIZE			0x43
#define FAC_THROUGHPUT			0x02
#define FAC_CUG				0x03
#define FAC_CUG_EXT			0x47	/* 1984 */
#define FAC_CUG_ACS			0x09	/* 1984 */
#define FAC_CUG_EXT_ACS			0x48	/* 1984 */
#define FAC_CUG_BI			0x41	/* 1984 */
#define FAC_FAST_SEL_AND_REV_CHRG	0x01
#define	FAC_NUI				0xc6	/* 1984 */
#define FAC_CHARGE_REQ			0x04	/* 1984 */
#define FAC_CHARGE_MU			0xc5	/* 1984 */
#define FAC_CHARGE_SEG			0xc2	/* 1984 */
#define FAC_CHARGE_DUR			0xc1	/* 1984 */
#define	FAC_RPOA			0x44
#define	FAC_RPOA_EXT			0xc4	/* 1984 */
#define FAC_LINE_ADDR_MOD		0x08	/* 1984 */
#define FAC_CALL_REDIR			0xc3	/* 1984 */
#define FAC_TR_DELAY			0x49	/* 1984 */

/* bit definitions of facility parameter for FAC_FAST_SEL_AND_REV_CHRG
 */
#define BIT_REVERSE_CHARGE	0x01
#define	BIT_FAST_SELECT_REQ	0x80
#define	BIT_RESTRICTED		0x40

/* The structure ADR_CB is used by standard/osi services */

typedef struct adr_cb_s {
	struct adr_cb_s	*next;
	u_char		type;
	struct sockaddr	sa;
} ADR_CB;


/* Kernel interface control block and events */

#define	MAX_KNL_SB_CC	4096	/* Maximum buffered kernel data */

typedef enum {
	X25_KNL_BIND,		/* ctloutput */
	X25_KNL_CLR_CONF,	/* input */
	X25_KNL_CLR_IND,	/* input */
	X25_KNL_CALL_ACPT,	/* output */
	X25_KNL_CALL_REQ,	/* output */
	X25_KNL_CALL_RESP,	/* input */
	X25_KNL_CONTROL,	/* ctloutput */
	X25_KNL_DISCONNECT,	/* output */
	X25_KNL_INCOMING_CALL,	/* input */
	X25_KNL_LISTEN,		/* ctloutput */
	X25_KNL_RECV_INT,	/* input */
	X25_KNL_RECV_DATA,	/* input */
	X25_KNL_RSET_IND,	/* input */
	X25_KNL_RSET_REQ,	/* output */
	X25_KNL_SEND_DATA,	/* output */
	X25_KNL_SEND_CLR,	/* output */
	X25_KNL_SEND_INT,	/* output */
	X25_KNL_TST_RCV_BLK,	/* ctloutput */
	X25_KNL_TST_SND_BLK,	/* ctloutput */
	X25_KNL_STOP_LISTEN,
	X25_KNL_BLK_RCV,
	X25_KNL_UNBLK_RCV,
	X25_KNL_GET_MY_ADR,
	X25_KNL_RSTA_IND,
	X25_KNL_BLK_SND,
	X25_KNL_UNBLK_SND,
	X25_KNL_CALL_FAILED,
	X25_KNL_CALL_TIMEOUT,
	X25_KNL_XMIT_TIMEOUT,
	X25_KNL_CLEARING_CONN
} X25_EVENT;

/* Generic kernel message */

typedef struct {
	X25_EVENT	event;
} X25_MSG;

typedef struct {
	struct protosw	*protosw_ptr;
	char		*upper_layer_cb;
	int		flags;
	int		sb_cc;
} KERN_CB;


/* See x25_pk.h for explanations of facilities.  The size of this
 * structure is currently 108 on sparc - it cannot exceed 112 if
 * we want to fit it into one mbuf.
 */
typedef struct fact_db_s {
	u_int		facilities;
	u_char		reverse_charge:1;
	u_char		charge_req:1;
	u_char		expedited:1;
	u_char		stdservice:1;
	u_char		osiservice:1;
	u_char		fast_select_type:3;
	u_char		line_addr_mod;
	THROUGHPUT	throughput;
	THROUGHPUT	min_thru_class;
	u_short		tr_delay;
	WINDOW_SIZE	window_size;
	PRECEDENCE	prec;
	PACKET_SIZE	packet_size;
	CUG		cug;
	RPOA		rpoa;
	ETE_TR_DELAY	ete_tr_delay;
	CALL_REDIR	call_redir;
	AEF		cd_aef;	
	AEF		cg_aef;

	/* the following fields are stored as mbufs, allocated as needed
	 */
	NUI		*nui;
	CHARGE_INFO	*charge_mu;
	CHARGE_INFO	*charge_seg;
	CHARGE_INFO	*charge_dur;

/* ICNCFIX by -WFP- for bug 1069433 */

/*
	PRIVATE_FACT	*private;
*/

	PRIVATE_FACT	*privat;

#ifndef __cplusplus
#ifndef private
#define private privat /* for backward C compatibility */
#endif
#endif

/* end of part of fix */

} FACT_DB;


typedef struct l3stat_s {
	short	linkid;
	short	linkid2;
	u_char	specific;
} LSTAT;

typedef struct vcstat_s {
	LSTAT	lstat;
	u_short	lcn;
} VCSTAT;


typedef struct {
	KERN_CB		kernel_interface;
	CONN_LCNCB	mask;		/* mask for user data */
	CONN_ADR	dest;		/* remote address */
	CONN_ADR	local;		/* bind addr / local address */
	FACT_DB		*facility;	/* stored in mbuf, always allocated */
	X25_MACADDR	dst_mac;	/* remote mac address */
	struct lcncb_s	*nextl;		/* doubly linked list ordered by lcn */
	struct lcncb_s	*prevl;		/*	number in allocation order */
	LSTAT		lstat;		/* used for next link status */
	VCSTAT		vcstat;		/* used for next vc status */
	caddr_t		ap;		/* pointer to address entry, if any */
	u_int		facts;		/* facilities negotiated, to send */
} MANAGEMENT_DB;

/* Out of band message control blocks */

#define MAXOOBCB	40	/* Maximum number of out of band messages */

typedef struct oob_cb_s {
	struct oob_cb_s	*next;
	u_char	type;
	u_char	parm;
} OOB_CB;

/* Level 3 runtime information conrol block - part of LCNCB */

typedef struct {
	u_short		recv_pending;	/* recv */
	u_char		sub_state; 	/* for bit definitions of sub_state
					 * of LCNCB see x25_pk.h.
					 */
	u_char		sendpr;		/* last sent pr */
	u_char		recvpr;		/* last recv pr */
	u_char		sendps; 	/* next send ps */
	u_char		recvps; 	/* next recv ps */
	struct mbuf	*intdata;	/* incoming intr data */
	u_char		intcnt;		/* Interrupt packet transmit count */
	u_char		resetcnt;	/* Reset packet transmit count*/
	int		sendpkts;	/* Data packet transmit count*/
	int		recvpkts;	/* Data packet receive  count*/
} RUN_LCNCB;


/*  X.25 Logical Channel Descriptor - NOTE: this is stored in a small mbuf,
 *	and so the size must be kept below MLEN (currently 112).  The size
 * 	of this structure is currently XXX.
 */
typedef struct lcncb_s {
	struct lcncb_s	*next;	/* chain pointer */

	struct lcncb_s	*hashq;	/* link in hash queue */

	int		linkid;	/* associated interface */

	caddr_t		l3ptr;	/* pointer to link control block */

	struct socket	*so;	/* associated socket, if any */

	struct ifnet	*ifp;	/* associated ifnet, if any */

	u_char      	state;	/* state of this lcncb, see x25_pk.h */

	u_char		acpt_by_user:1;	/* if 1, user will accept call */

	/* Wait for returned cause and diag codes on X25_WR_CAUSE_DIAG ioctl.
	 */
	u_char		wait_confirmation:1;

	/* Set if we are looking at the first packet in a sequence, or a lone
	 * packet.  Used to know whether to chain successive packets on m_next
	 * or m_act.
	 */
	u_char		new_packet:1;

	/* Set when socket has data to send and is being disconnected.
	 */
	u_char		unfinished_send:1;

	/* Set when M bit is requested set by X25_SEND_TYPE ioctl
	 */
	u_char		sendpartial:1;

	/* Set when high water mark has been changed by X25_WR_SBHIWAT ioctl
	 */
	u_char		so_limit_set:1;

	/* Set when X.25 client has requested incoming user data exactly match 
	 * PID.
	 */
	u_char		exact_match:1;

	/* Set dbit in originated calls if this is set.
	 */
	u_char		dbit:1;

	/* Set if this lcncb belongs to an incoming call
	 */
	u_char		incoming_call:1;

	/* Is a PCV.
	 */
	u_char		is_a_pvc:1;

	/* Set when lcncb has been cleaned up and ready to discard.
	 */
	u_char		clean:1;

	/* Set when delayed ack is required.
	 */
	u_char		ack_delay:1;

	/* M-bit sequence in progress.
	 */
	u_char		mbit_on:1;

	/* Q-bit sequence in progress.
	 */
	u_char		qbit_on:1;

	/* Contains the current value for T20, T21, and T23 timers.
	 */
	u_char		retries;

	/* Used with X25_RECORD_SIZE ioctl - counts how many packets have
	 * been recv'd so comparison can be done to record_len field.
	 */
	u_char		record;

	/* Set by X25_HEADER ioctl to indicate that header should be sent up
	 * to client.
	 */
	u_char		header;

	u_char  	unack;		/* number of unacked packets */

	u_short		lcn;		/* lcn # for this lcncb */

	u_short		timeout;	/* timeout semaphore */

	/* incoming/outgoing GFI and 12 bit LCN for this VC
	 */
	u_short		gfi_lcn;

	u_short		record_len;	/* set by X25_RECORD_SIZE ioctl */

	/* User data to send on this lcncb via Call/Clear User data field
	 */
	struct mbuf	*send_u_data;

	/* User data received on this lcncb via Call/Clear User data field,
	 * or set as a result of binding.
	 */
	struct mbuf	*recv_u_data;

	OOB_CB		*ooblist;	/* Queue of upgoing OOB messages */

	/* This is for OSI and STD, it is the list of out of band messages
	 * to x25manager.
	 */
	ADR_CB		*adrlist;

	/* Incoming data packets are queued up here
	 */
	struct mbuf	*dataQ;

	/* Head/tail of enqueued data packets awaiting send
	 */
        struct mbuf	*outhead;
        struct mbuf	*outtail;

	/* Staging area for assembling outgoing user data in the event we have
	 * requested sending with M bit set (`sendpartial' above is set).
	 */
	struct mbuf	*outtemp;

	struct mbuf	*diag;		/* set via X25_CAUSE_DIAG ioctl */

	MANAGEMENT_DB	*mgmt_info;	/* Addressing info for this lcncb */

	int		listen_count;	/* number of calls to accept */

	RUN_LCNCB	r;		/* Runtime information for lcn */
} LCNCB;


/* Level 3 database - has current operating parameter values */

typedef struct l3_db_s {

	struct ifnet	ifp;		/* should be first field */

	struct mbuf	*mbufp;		/* pointer to cluster */

	struct socket	*configso;	/* socket of configurator */

	L3_PARAM	l3_parms;	/* layer 3 parameters */

	HDLC_PARAM	l2_parms;	/* layer 2 parameters */

	u_char		initialized;	/* if zero, not initialized */

	u_char		modulomask;	/* 7 = MODULO 8, 127 = MODULO 128 */

	u_char		state;		/* packet level state */
#define SY_OFF			0	/* packet level not ready */
#define SY_READY		1	/* packet level ready */
#define SY_SENT_RST		2	/* sent RESTART */
#define SY_LLC_CONNWAIT		3	/* LLC connection in progress */
#define SY_LLC_DISCWAIT		4	/* LLC awaiting llc disconnection */
#define SY_LLC_CONNIN		5	/* LLC connection in */

	u_char		rst_collision;	/* RESTART collision occurred */

	u_char		idle;		/* if true, idle timeout is on */

	u_char		retries;	/* level 3 retries */

	u_short		timeout;	/* level 3 timeouts */

	u_short		recv_gfi_lcn;	/* temporary storage */

	u_char		mode;		/* link mode - DTE/DCE/DYNAMIC */

	u_char		lowerbusy;	/* lower layer is busy */

	int		linkid;		/* interface of this link */

	int		version;	/* V_1980 or V_1984 */

	LCNCB		*lcnhashq[LCNHASHSIZE];
					/* Hash queue */

	LCNCB		*sendpendingQ;	/* lcns that either have data to
					 * send, or have a timeout active
					 */

	LCNCB		*listenQ;	/* list of listening lcn cb's */

	int		active_lcns;	/* number of active VCs */

	u_char		link_type;	/* link type  - HDLC/LLC*/

	struct mbuf	*blockedq;	/* packets queued on blocked link */

	/* The following fields are relevant only for LLC2 links. */

	u_char		ssap;		/* source lsel */

	X25_MACADDR	dst_mac;	/* remote MAC address/lsel */

        caddr_t		llcreg;		/* llc client registration cb */

        struct l3_db_s	*l3ref;		/* pointer to reference cb */

        struct l3_db_s	*next;		/* pointer to next connection cb */

	LCNCB		*llc_waitq;	/* list of lcn cb's awaiting connect */

	/* The following fields are used for stats collection */

	int		linkid2;	/* for ordering dynamic links */

	/* The following fields are used for lcn allocation. */

	LCNCB		*lcn_list;	/* lcn allocation list */

	LCNCB		*search;	/* cache for allocating next lcn */

/* ICNCFIX by -TH- for ISO8882 conformance.  The next field should
   really go in the L3_PARAMS structure.  However to maintain backward
   compatibility with X.25 7.0 for the X25_WR_SYSGEN and X25_RD_SYSGEN
   ioctl() calls, they cannot be put there.  As a result they are tagged
   on the end of this structure.  PATCH_1 and PATCH_17 */
	u_char		t26;		/* T26 interrupt timer value */
/* End of fix */

/* ICNCFIX by -TH- for ISO8882 conformance.  This field indicates whether or
   not DTE-DTE mode is in use over LAPB.  PATCH_18 */
	u_char		iso8208;	/* If true then carry out additional
					   ISO8208 checks. */
/* End of fix */
/* ICNCFIX by -TH- to allow configuring of packet layer restart on link reset.*/
	u_char		restart;	/* If true restart packet layer when
					   the link is restarted. */
/* End of fix */
	

} L3_DB;

/* convenient definitions for accessing fields in mgmt_info */

#define	MGTINF(x)	(x->mgmt_info)
#define FACT		(lcnptr->mgmt_info->facility)
#define HASH(id, hashid)	{hashid = (id) & HASHMASK;}
#define KERNEL_IF	(MGTINF(lcnptr)->kernel_interface.protosw_ptr)
#define KERNEL_FLAGS	(MGTINF(lcnptr)->kernel_interface.flags)
#define KERNEL_CB	(&MGTINF(lcnptr)->kernel_interface.upper_layer_cb)
#define KERNEL_SB_CC	(MGTINF(lcnptr)->kernel_interface.sb_cc)
#define DEST		(MGTINF(lcnptr)->dest)
#define LOCAL		(MGTINF(lcnptr)->local)
#define RLCN		(lcnptr->r)
#define CLCN		(lcnptr->mgmt_info->mask)
#define	L3PARMS		(((L3_DB *)lcnptr->l3ptr)->l3_parms)
#define	L2PARMS		(((L3_DB *)lcnptr->l3ptr)->l2_parms)
#define L3PTR		((L3_DB *)lcnptr->l3ptr)
#define LINKASSIGNED	(L3PTR != NULL)
#define VERSION_1980	(LINKASSIGNED && L3PTR->version == V_1980)
#define VERSION_1984	(LINKASSIGNED && L3PTR->version == V_1984)

/* Misc. defines */

#define IS_CONNECT	0
#define IS_BIND		1

/* Call setup, clearing, or registration diagnostic code values */

#define	INVALID_PS		1
#define	INVALID_PR		2

#define PKT_TYPE_INVALID	16
#define R1_STATE_BADPKT		17
#define P1_STATE_BADPKT		20

#define PKT_NOT_ALLOWED		32
#define UNIDENTIFIABLE_PKT	33
#define PKT_ON_UNASS_LCN	36
#define PKT_TOO_SHORT		38
#define PKT_TOO_LONG		39

#define INVALID_GFI		40
#define BAD_REST_OR_REG_PKT	41
#define PKT_FACT_INCOMPATIBLE	42
#define UNAUTH_INT_CONF_PKT	43
#define	UNAUTH_INT_PKT		44
#define INC_CALL_TIMED_OUT	49

#define CLR_IND_TIMED_OUT	50
#define RES_IND_TIMED_OUT	51
#define REST_IND_TIMED_OUT	52

#define CALL_SETUP_PROB		64
#define FAC_CODE_NOT_ALLOWED	65
#define FAC_PARM_NOT_ALLOWED	66
#define INVALID_CALLED_ADDR	67
#define INVALID_CALLING_ADDR	68
#define INVALID_FACT_LENGTH	69

#define INCOMING_CALL_BARRED	70
#define NON_ZERO_FACT_LENGTH	75
#define	FAC_NOT_PROVIDED	76

#define	DTE_RESOURCE_CONSTRAINT	163

/* ICNCFIX by -TH- for conformance.  Additional diagnostic codes for
   ISO8208, for ISO8882 testing.  PATCH_1 */
#define INVALID_CCITT_DTE_FAC	76
#define IMPROPER_CAUSE_CODE	81
#define NONOCTET_ALIGNED_PKT	82 
#define INCONSISTENT_Q_BIT	83 
#define NUI_PROBLEM		84 
#define INTERRUPT_TIMER_EXPIRED	145 
#define DTE_OPERATIONAL		161 
#define DTE_NOT_OPERATIONAL	162 
#define FAST_SELECT_NOT_SUBSC	164

/* End of fix */

/* Default MTU sizes to be used for OSI and IP over X.25.
 */
#define OSINET_PKTSIZE	128	/* this is not used by OSI */
#define IP_PKTSIZE	1004

/* Support for X.25 tracing through SNIT.
 */
#define x25_t_pdu(ifp, l3ptr, m, direction) {		\
	if ((ifp)->if_flags & IFF_PROMISC)		\
		r_x25_t_pdu(ifp, l3ptr, m, direction);	\
}

typedef struct x25_trace_pci {
	int		linkid;
	u_char		link_type;
	X25_MACADDR	mac;
} X25_TRACE_PCI;

/* Miscellaneous
 */
typedef (*func_type)();

/* Unfortunately BCOPY is defined on Sun3's
 */
#undef BCOPY

#define	BZERO(a, b)	bzero((caddr_t)(a), (u_int)(b))
#define	BCMP(a, b, c)	bcmp((caddr_t)(a), (caddr_t)(b), (int)(c))
#define	BCOPY(a, b, c)	bcopy((caddr_t)(a), (caddr_t)(b), (u_int)(c))

#define X25_DBG_PR_LISTENQ	0x00000001
#define	X25_DBG_PR_ADDRQ	0x00000002

/* ICNCFIX by -WFP- for ANSI C compliance. bug 1103185 */

#endif /* _NETX25_X25_SYS_H */

/* end of part of fix */

