/**************************************************************************
 FILE:
	llc_pcb.h

	@(#)llc_pcb.h 1.4 88/02/01 Copyr 1987 Sun Micro
	
 DESCRIPTION:
 **************************************************************************/

/*
 * Common structure pcb for LLC protocol implementations.
 * Here are stored pointers to the local (and foreign if applicable)
 * addresses for this socket instantiation, as well as flags that
 * describe the socket state (e.g. bind() done), a back pointer
 * to the socket structure, and a pointer to the lower per-protocol
 * control block, if appropriate.  Additionally, the llcpcb
 * contains a pointer to the ifnet device of the lower layer llc.
 */
struct llcpcb {
	struct	llcpcb 		*next,*prev; 	/* pointers to other pcb's */
	struct	llcpcb 		*head; 		/* pointer to llcpcb chain */
	u_char	 		flags; 		/* state and option flags */
#define		LLC_FADDR_SET	0x01	
#define		LLC_LADDR_SET	0x02
	u_char			llsel;		/* local address */
	struct sockaddr		faddr;		/* foreign address */
	struct	socket 		*socket; 	/* back pointer to socket */
	struct ifnet		*ifp; 		/* ifp for this client */
	struct llc_client	client;		/* registration with LLC */
	struct mbuf 		*m;		/* for freeing this structure */
};


#define	sotollcpcb(so)		((struct llcpcb *)((so)->so_pcb))

#ifdef KERNEL
struct llcpcb 	*llc_pcblookup();
#endif
