#ifndef lint
static char sccsid[] = "@(#)dnierror.c 7.5 91/02/11 Copyr 1989 Sun Micro";
#endif

/*
 * Copyright (c) 1989 by Sun Microsystems, Inc.
 */
 
/*   Module:	dnierror.c  -  SunLink DNI Display Error Message Utility   
  
******************************************************************************
*  COPYRIGHT (C)  1985, 1986 by TECHNOLOGY CONCEPTS INC.                     *
*                         SUDBURY, MASSACHUSETTS 01776                       *
*                         ---ALL RIGHTS RESERVED---                          *
*                                                                            *
*  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED     *
*  ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION  *
*  OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES THEREOF *
*  MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER PERSON.  NO  *
*  TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.             *
*                                                                            *
*  THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND  *
*  SHOULD NOT BE CONSTRUED AS A COMMITMENT BY TECHNOLOGY CONCEPTS INC.       *
******************************************************************************
*
*  Version 2  --  Revision 0
*
*  Facility:      SunLink DNI Display Error Message Utility
*
*  Product:       SunLink DNI
*
*  Module Abstract: dnierror is an unsupported utility which displays
*                   the status, or error, message corresponding to the status
*                   code in the external variable errno.  
*
*                   dnierror accepts as input a character string which will be
*                   prepended onto the beginning of the status message. 
*
*                   The status codes accepted are those status codes 
*                   defined in the dni.h header file and documented in the
*                   SunLink DNI User's Manual.  If the status code in errno is
*                   not a DNI status code, the operating system dependent
*                   perror utility will be called to display an appropriate 
*                   message.
*
*	The codes have been shifted to avoid errno conflicts  4/5/90
*/

#include <stdio.h>
#include <sys/ioctl.h>
#include <netdni/dni.h>

extern int errno;

/*
 *  CommUnity Status Messages
 */
static char *status_msg[] = {
  /*  170 */ "Specified logical link does not exist",
  /*  171 */ "Network software processing error",
  /*  172 */ "Data was truncated",
  /*  173 */ "Logical link number specified is invalid",
  /*  174 */ "Logical link normally closed or rejected",
  /*  175 */ "Insufficient resources at remote node",
  /*  176 */ "Unrecognized node name",
  /*  177 */ "Remote node is not accepting new links",
  /*  178 */ "Specified remote object does not exist",
  /*  179 */ "Specified task name is invalid",
  /*  180 */ "Insufficient resources at remote node",
  /*  181 */ "Link disconnected by network",
  /*  182 */ "Link aborted by remote program",
  /*  183 */ "Specified node or device name is invalid",
  /*  184 */ "Local node is not accepting new links",
  /*  185 */ "Remote node rejected access information",
  /*  186 */ "Insufficient resources at local node",
  /*  187 */ "Remote node failed to respond",
  /*  188 */ "Remote node is unreachable",
  /*  189 */ "Logical link identifier already in use",
  /*  190 */ "Network software is not initialized",
  /*  191 */ "Controller didn't acknowledge message from driver",
  /*  192 */ "Driver didn't receive expected message from controller",
  /*  193 */ "Controller error on transmit",
  /*  194 */ "Controller error on receive",
  /*  195 */ "Program aborted by interactive user",
  /*  196 */ "Invalid access attempt on read or write",
  /*  197 */ "No data available",
  /*  198 */ "Invalid value in SesRecord status field",
  /*  199 */ "Size of transfer exceeds maximum allowed",
  /* 200 */ "Out of space on controller",
  /* 201 */ "Unidentified controller failure",
  /* 202 */ "Invalid command or ioctl function",
  /* 203 */ "Transmit failed, link is flow controlled",
  /* 204 */ "Invalid error number 104",
  /* 205 */ "Invalid error number 105",
  /* 206 */ "Remote node closed link, data still available to read",
  /* 207 */ "Buffer contains interrupt data",
  /* 208 */ "Buffer contains the begining of message",
  /* 209 */ "Buffer contains the middle of message",
  /* 210 */ "Buffer contains the end of message",
  /* 211 */ "Buffer contains a complete message",
  /* 212 */ "Invalid error number 112 (not used)",
  /* 213 */ "Invalid error number 113 (not used)",
  /* 214 */ "Invalid error number 114 (not used)",
  /* 215 */ "Unknown error received from remote node",
  /* 216 */ "Duplicate node name detected",
  /* 217 */ "Duplicate node number detected",
  /* 218 */ "Node numbers are required for all nodes",
  /* 219 */ "Function not yet supported"
};

/*  
 *  Routine:     dnierror ( STRING ) 
 * 
 *  Abstract:    dnierror is an unsupported status message utility. 
 *               It displays a status message corresponding to the status 
 *               code in the external variable errno, prepending the string
 *               passed to the beginning of the status message.
 *
 *               On each call, this routine determines if the status code 
 *               in the external variable errno is within the valid DNI 
 *               status code range.  If it is, the input string is displayed,
 *               followed by the corresponding DNI status message. 
 *               If the status code in errno is not a DNI status code,
 *               the PERROR utility is called to display an appropriate message.
 *
 *  Inputs:      string - character string to prepend onto error message
 *               errno  - CommUnity status code in the external variable errno 
 * 
 *  Outputs:     displayed message
 */
dnierror(string)
char *string;
{
	register unsigned short status_code;

	if (errno < 0)
		status_code = errno & 0xff;
	else
		status_code = errno;

	if ((status_code > HIGHEST_DNI_ERROR)
		 || (status_code < LOWEST_DNI_ERROR))
		perror (string);
	else
		fprintf(stderr, "%s: %s\n",
			string, status_msg[status_code - LOWEST_DNI_ERROR]);
	return(0);
}
