#ifndef lint
static char sccsid[] = "@(#)inttst.c 7.3 91/02/11 Copyr 1986 Sun Micro";
#endif

/*
 * inttst.c
 *
 * simple demo program to test sending interrupt
 * data using the SunLink DNI session interface
 */

#include	<ctype.h>
#include	<fcntl.h>
#include	<stdio.h>
#include	<sys/ioctl.h>
#include	<netdni/dni.h>

extern int errno;

int fd;
OpenBlock opblk;
Image16 idata;
Image16 rdata;
struct ses_io_type sesopts;
char s[100];
char *sp;

main()
{
	int ret;

	fd = open("/dev/dni", O_RDWR);
	if (fd == -1) {
		dnierror("Open Fail");
		exit(1);
	}

	if (ioctl(fd, SES_GET_LINK, 0)) {
		dnierror("SES_GET_LINK failed");
		exit(1);
	}

	sesopts.io_flags = SES_IO_NBIO + SES_IO_INT_MODE;
	sesopts.io_io_signal = sesopts.io_int_signal = 0;
	ret = ioctl(fd, SES_IO_TYPE, &sesopts);
	if (ret == -1) {
		dnierror("SES_IO_TYPE failed");
		exit(1);
	}

	printf("node? ");
	sp = gets(opblk.op_node_name);
	if (sp == 0) {
		printf("\n");
		exit(1);
	}
	printf("Object Number? ");
	sp = gets(s);
	if (sp == 0) {
		printf("\n");
		exit(1);
	}
	if (*s == '\0')
		opblk.op_object_nbr = 0;
	else
		sscanf(s, "%d\n", &opblk.op_object_nbr);
	printf("Task Name? ");
	sp = gets(opblk.op_task_name);
	if (sp == 0) {
		printf("\n");
		exit(1);
	}
	strcpy(opblk.op_userid, "");
	strcpy(opblk.op_account, "");
	strcpy(opblk.op_password, "");
	opblk.op_opt_data.im_length = 0;

#ifdef DEBUG
	printf("node_name     = %s \n", opblk.op_node_name);
	printf("object number = %d \n", opblk.op_object_nbr);
	printf("task name     = %s \n", opblk.op_task_name);
	printf("user id       = %s \n", opblk.op_userid);
	printf("account       = %s \n", opblk.op_account);
	printf("password      = %s \n", opblk.op_password);
	printf("opt data len  = %d \n", opblk.op_opt_data.im_length);
#endif

	ret = ioctl(fd, SES_LINK_ACCESS, &opblk);
	if (ret != 0) {
		dnierror("SES_LINK_ACCESS failed");
		exit(1);
	}
	printf("OK, link is open.  CR to continue: ");
	getchar();

	/* start it off */
	strcpy(idata.im_data, "hi server");
	idata.im_length = strlen(idata.im_data) + 1;

#ifdef DEBUG
	printf("Transmit %d bytes, data : %s\n",
		idata.im_length, idata.im_data);
#endif

	ret = ioctl(fd, SES_XMT_INT, &idata);
	if (ret == -1) {
		dnierror("SES_XMT_INT failed");
		exit(1);
	}

	/* loop forever, or at least until killed */
	while (1) {
		printf("Enter a string to send: ");
		sp = gets(s);
		if (sp == 0) break;
		if (strlen(s) > 15) s[15] = 0;
		idata.im_length = strlen(s) + 1;
		bcopy(s, idata.im_data, strlen(s) + 1);

#ifdef DEBUG
		printf("Transmit %d bytes, data : %s\n",
			idata.im_length, idata.im_data);
#endif

		ret = ioctl(fd, SES_XMT_INT, &idata);
		if (ret == -1) {
			dnierror("SES_XMT_INT failed");
			if (errno != FLOW_CONTROL)
				exit(1);
		}
	}
}
