#ifndef lint
static char sccsid[] = "@(#)tell.c 7.4 91/02/11 Copyr 1986 Sun Micro";
#endif

/*
 * Module:  TELL.C
 * 
 *****************************************************************************
 *       COPYRIGHT (C) 1985 by Technology Concepts Inc.                      *
 *                             Sudbury, Massachusetts 01776                  *
 *                             -- ALL RIGHTS RESERVED --                     *
 *                                                                           *
 *  This software is furnished under license and may be used and copied      *
 *  only in accordace with the terms of such license and with the inclusion  *
 *  of the above copyright notice. This software or any other copies thereof *
 *  may not be provided or otherwise made available to any other person. No  *
 *  title to and ownership of the software is hereby transferred.            *
 *                                                                           *
 *  The information in this software is subject to change without notice and *
 *  should not be construed as a commitment by Technology Concepts Inc.      *
 *****************************************************************************
 * 
 * Version:     1        Revision: 1
 * 
 * Facility:    Example program 
 *
 * Abstract:    This program demonstrates how to exchange messages with a
 *              another node using SunLink DNI. This operation is called
 *              task-to-task communication and is performed by issuing commands
 *              to the SunLink DNI device driver.
 *
 *              This program demonstrates how to:
 *
 *		1) Establish a logical link to a TELL process
 *                
 *                 A logical link must be established between your node and
 *                 the remote system before messages can be exchanged.
 *                 To establish a logical link, one system must initiate
 *                 the link request. The initiating system, or program, is 
 *                 called the requestor and the other is called the server.
 *                 This program is an example of the requestor. It requests 
 *                 a connection to a server. The server is a program
 *		   called tserver in this directory.
 *
 *
 *                 Once the logical link is established, the TELL server
 *                 sends the ASCII string "ABOUT_TO_ISSUE_READ" to tell the
 *                 requesting program that it can accept a new command.
 *                 This program then asks the user for a command and sends
 *                 it to the TELL server. The program then goes into a loop,
 *                 receiving the responses and displaying then to your
 *                 terminal.
 *
 *              3) Terminate the logical link
 *
 *                 When the user enters "quit" or "exit" then the logical
 *                 link is closed. 
 */

#include	<stdio.h>
#include	<fcntl.h>
#include	<ctype.h>
#include	<sgtty.h>
#include	<sys/param.h>
#include	<sys/ioctl.h>
#include	<netdni/dni.h>

/* Constant definitions */
#define  NUM_BYTES  200		/* Maximum number of bytes to read */

/* External variable definitions */
extern int errno;		/* External variable errno	   */

/* Global data definitions */
OpenBlock opblk;		/* OpenBlock for /dev/ll           */
char read_buf[NUM_BYTES];	/* input buffer for read requests  */
char input_string[100];		/* input buffer for command input  */
char u_name[20];		/* user name buffer for link       */
char u_pass[20];		/* password buffer for link        */
char node[10];			/* node name to connect to         */
int fd;				/* logical link file descriptor    */
int echo_lines = 0;

/*
 *      TELL.C - main routine
 */
main(argc, argv)
{
	int ret;	/* Community status variable    */
	int i;

	parse_command_line(argc, argv);

	/*
	 * To request a logical link, we must first
	 * open the logical link device, "/dev/dni". 
	 */
	fd = open("/dev/dni", O_RDWR);
	if (fd == -1) {
		dnierror("Error on Open");
		exit(1);
	}

	if (ioctl(fd, SES_GET_LINK, 0)) {
		dnierror("Error getting a logical link");
		exit(1);
	}

	/*
	 * Next, we must make the link request to the TELL server. To do
	 * this, we must specify the remote system and the server task we
	 * want to connect to. In addition, we must identify ourself so the
	 * server knows who is making the request. This information is
	 * contained in a data structure called the OpenBlock. We will fill
	 * in an OpenBlock with the necessary data, then issue the
	 * SES_LINK_ACCESS ioctl request to make the link request to the
	 * server. Ioctl() will return a 0 if the link is established to the
	 * server. If it returns a -1, the link is not open. The reason or
	 * error number is contained in the external variable errno.  
	 */
	strcpy(opblk.op_node_name, node);
	opblk.op_object_nbr = 0;
	strcpy(opblk.op_task_name, "TELL");
	strcpy(opblk.op_userid, u_name);
	opblk.op_account[0] = '\0';
	strcpy(opblk.op_password, u_pass);
	opblk.op_opt_data.im_length = 0;

	printf("Connecting to TELL server on system %s, user %s\n",
		node, u_name);

	if (ioctl(fd, SES_LINK_ACCESS, &opblk)) {
		dnierror("Error connecting to TELL");
		exit(1);
	}
	printf("Link established to TELL server for user %s\n", u_name);

	/*
	 * The logical link is established once our connect request is
	 * accepted by the server. We may now proceed to send and receive
	 * data across the link using read() and write(). We must first issue
	 * a read request to wait for the TELL program to send the
	 * ABOUT_TO_ISSUE_READ string to us.
	 */
	while (1) {
		/*
		 * read and display all data from the TELL server 
		 */
		read_loop();

		/*
		 * display fake  prompt and get next command. If quit or exit
		 * then exit the program 
		 */
		while (1) {
			printf("$ ");
			if (gets(input_string) == NULL)
				exit(1);
			if (strlen(input_string))
				break;
		}
		if (!strcmp(input_string, "quit") ||
		    !strcmp(input_string, "exit") ||
		    !strcmp(input_string, "QUIT") ||
		    !strcmp(input_string, "EXIT"))
			break;

		if (echo_lines)
			puts(input_string);

		/*
		 * send the new command to the TELL server 
		 */
		ret = write(fd, input_string, strlen(input_string));
		if (ret == -1) {
			dnierror("Error Writing on the link");
			exit(1);
		}
	}

	/*
	 * Terminate the connection before successfully exiting the program.
	 * This example chooses not to send the optional disconnect data
	 * Therefore, only the close()function is needed. 
	 */
	close(fd);
	return;
}

/*
 *  read_loop - read and display data from the remote system
 */
read_loop()
{
	int ret;

	/* loop until remote system is waiting for next command */
	while (1) {
		/* read data from the remote system */
		ret = read(fd, read_buf, NUM_BYTES);
		if (ret == -1) {
			dnierror("Error reading data from remote system");
			exit(1);
		}
		/* if remote system is waiting for next command, return */
		if (ret > 0)
			if (!strncmp(read_buf, "ABOUT_TO_ISSUE_READ", 19))
				return;

		/* make the data NULL terminated and print it */
		read_buf[ret] = '\0';
		printf("%s\n", read_buf);
	}
}

parse_command_line(argc, argv)
	int argc;
	char *argv[];
{
	int i;
	int got_node = 0, got_user = 0, got_pass = 0;
	struct sgttyb t_set;

	i = 1;
	while (i < argc) {
		if (argv[1][0] != '-') {
			fprintf(stderr, "Illegal option: %s\n", argv[i]);
			++i;
		} else
			switch (argv[i][1]) {
			case 'e':
				echo_lines = 1;
				++i;
				break;

			case 'n':
				strcpy(node, argv[i + 1]);
				i += 2;
				got_node = 1;
				break;

			case 'u':
				strcpy(u_name, argv[i + 1]);
				i += 2;
				got_user = 1;
				break;

			case 'p':
				strcpy(u_pass, argv[i + 1]);
				i += 2;
				got_pass = 1;
				break;

			default:
				fprintf(stderr, "Illegal option %s\n", argv[i]);
				++i;
			}

	}

	if (!got_node) {
		printf("NODE[%s]: ", node);
		gets(node);
	}
	if (!got_user) {
		printf("USERNAME: ");
		gets(u_name);
	}
	if (!got_pass) {
		printf("PASSWORD: ");
		ioctl(fileno(stdout), TIOCGETP, &t_set);
		t_set.sg_flags ^= ECHO;
		ioctl(fileno(stdout), TIOCSETP, &t_set);
		gets(u_pass);
		t_set.sg_flags ^= ECHO;
		ioctl(fileno(stdout), TIOCSETP, &t_set);
	}
}
