#ifndef lint
static char sccsid[] = "@(#)tserver.c 7.3 91/02/11 Copyr 1986 Sun Micro";
#endif

/*
 * tserver.c - "tell" server for SunLink DNI
 */

#include	<stdio.h>
#include	<fcntl.h>
#include	<sys/ioctl.h>
#include	<ctype.h>
#include	<netdni/dni.h>

extern int errno;

char read_buf[512];
char write_buf[512];
char input_string[100];
char T_name[30] = "";
short T_num = 0;
int fd;
char s[100];
char about[] = "ABOUT_TO_ISSUE_READ";
OpenBlock opblk;
SessionData sd;

FILE *popen();

main(argc, argv)
	int argc;
	char *argv[];
{
	int i;
	int ret;
	int j;
	char command[100];
	FILE *fp;
	register char *a;

	/* init the session data structure for the accept */
	sd.sd_reason = 0;
	sd.sd_data.im_length = 0;

	/*
	 * if argc == 1, started by a command line or started by tserver
	 *
	 * if argc == 2, started by dniserver. argv[0] = tserver, argv[1] = 3
	 */
	if (argc == 1) {
		/* started explicitly */
		fd = open("/dev/dni", O_RDWR);
		if (fd == -1) {
			dnierror("tserver: Open Fail");
			exit(1);
		}

		if (ioctl(fd, SES_GET_LINK, 0)) {
			dnierror("tserver: Error getting a logical link");
			exit(1);
		}

		ret = ioctl(fd, SES_NAME_SERVER, "TELL");
		if (ret == -1) {
			dnierror("tserver: Fail Server Registration");
			exit(1);
		}

		opblk.op_node_name[0] = 0;
		opblk.op_object_nbr = 0;
		opblk.op_task_name[0] = 0;
		opblk.op_userid[0] = 0;
		opblk.op_account[0] = 0;
		opblk.op_password[0] = 0;
		opblk.op_opt_data.im_length = 0;
		opblk.op_opt_data.im_data[0] = 0;

		ret = ioctl(fd, SES_GET_AI, &opblk);
		if (ret == -1) {
			dnierror("tserver: SES_GET_AI Failed");
			exit(1);
		}

		/* generate another copy of ourselves */
		if (fork() == 0) {
			/* child process */
			close(fd);
			sprintf(command, "%s &", argv[0]);
			system(command);
			exit(0);
		}
	} else
		/* started by dniserver */
		fd = 3;

	ret = ioctl(fd, SES_ACCEPT, &sd);
	if (ret == -1) {
		dnierror("tserver: Failed ACCEPT");
		exit(1);
	}

	read_buf[0] = 0;

	while (1) {
		/* Send out the ABOUT_TO_ISSUE_READ */
		if ((ret = write(fd, about, strlen(about))) < 0) {
			if (errno != BY_OBJECT)
				dnierror("tserver: Write Fail");
			break;
		}
		/* Issue the read */
		if ((ret = read(fd, read_buf, 512)) < 0) {
			if (errno != BY_OBJECT)
				dnierror("tserver: Read Fail");
			break;
		}
		read_buf[ret] = '\0';
		if (!strcmp(read_buf, "EXIT"))
			break;

		if (isupper(*read_buf))
			for (a = read_buf; *a != '\0'; ++a)
				if (isupper(*a))
					*a = tolower(*a);
		sprintf(command, "%s", read_buf);

		/* read the results back in */
		if ((fp = popen(command, "r")) == NULL) {
			dnierror("tserver: Popen Fail:");
		}
		while (fgets(read_buf, 512, fp) != NULL) {
			read_buf[strlen(read_buf) - 1] = '\0';
			if (write(fd, read_buf, strlen(read_buf)) < 0) {
				if (errno != BY_OBJECT)
					dnierror("tserver: WRITE FAIL");
				break;
			}
		}
		pclose(fp);
	}
	close(fd);
}
