#ifndef lint
static char sccsid[] = "@(#)intsrv.c 7.3 91/02/11 Copyr 1986 Sun Micro";
#endif

/*
 * intsrv.c
 *
 * simple demo program to test receiving interrupt
 * data using the SunLink DNI session interface
 */

#include	<ctype.h>
#include	<fcntl.h>
#include	<signal.h>
#include	<stdio.h>
#include	<sys/ioctl.h>
#include	<sys/types.h>
#include	<netdni/dni.h>

extern int errno;

int fd;
OpenBlock opblk;
Image16 idata;
Image16 rdata;
struct ses_io_type sesopts;
char s[100];
char zeros[100];
char T_name[30] = "";
short T_num = 0;
fd_set readfds, exceptfds;
char *sp;

void int_func();

main()
{
	int ret;

	for (ret = 0; ret < 100; ++ret)
		zeros[ret] = 0;

	fd = open("/dev/dni", O_RDWR);
	if (fd == -1) {
		dnierror("Open Fail");
		exit(1);
	}

	if (ioctl(fd, SES_GET_LINK, 0)) {
		dnierror("Get Link failed");
		exit(1);
	}

	sesopts.io_flags = SES_IO_NBIO + SES_IO_INT_MODE;
	sesopts.io_io_signal = 0;
	sesopts.io_int_signal = 0;
	ret = ioctl(fd, SES_IO_TYPE, &sesopts);
	if (ret == -1) {
		dnierror("SES_IO_TYPE failed");
		exit(1);
	}

	printf("Registering self as server.\n");
	printf("Open as (name or number)? ");
	sp = gets(s);
	if (sp == 0) {
		printf("\n");
		exit(1);
	}
	if (isdigit(*s)) {
		T_num = atoi(s);
		ret = ioctl(fd, SES_NUM_SERVER, &T_num);
	} else {
		strcpy(T_name, s);
		ret = ioctl(fd, SES_NAME_SERVER, T_name);
	}

	if (ret == -1) {
		dnierror("Server Registration Failed");
		exit(1);
	}

	opblk.op_node_name[0] = 0;
	opblk.op_object_nbr = 0;
	opblk.op_task_name[0] = 0;
	opblk.op_userid[0] = 0;
	opblk.op_account[0] = 0;
	opblk.op_password[0] = 0;
	opblk.op_opt_data.im_length = 0;
	opblk.op_opt_data.im_data[0] = 0;

	ret = ioctl(fd, SES_GET_AI, &opblk);
	if (ret == -1) {
		dnierror("Ses_Get_AI failed");
		exit(1);
	}

	ret = ioctl(fd, SES_ACCEPT, zeros);
	if (ret == -1) {
		dnierror("Ses_Accept failed:");
		exit(1);
	}

	FD_ZERO(&readfds);
	FD_ZERO(&exceptfds);
	while (1) {
		FD_SET(fd, &readfds);
		FD_SET(fd, &exceptfds);
		select(fd + 1, &readfds, 0, &exceptfds, 0);
		ret = ioctl(fd, SES_RCV_INT, &rdata);
		if (ret == -1) {
			dnierror("SES_RCV_INT failed");
			break;
		}
		printf("Received %d bytes, data : %s\n",
			rdata.im_length, rdata.im_data);
	}
}
