#ifndef lint
static char sccsid[] = "@(#)request.c 7.3 91/02/11 Copyr 1986 Sun Micro";
#endif

/*
 * Module:  REQUEST.C
 * 
 *****************************************************************************
 *       COPYRIGHT (C) 1985 by Technology Concepts Inc.                      *
 *                             Sudbury, Massachusetts 01776                  *
 *                             -- ALL RIGHTS RESERVED --                     *
 *                                                                           *
 *  This software is furnished under license and may be used and copied      *
 *  only in accordace with the terms of such license and with the inclusion  *
 *  of the above copyright notice. This software or any other copies thereof *
 *  may not be provided or otherwise made available to any other person. No  *
 *  title to and ownership of the software is hereby transferred.            *
 *                                                                           *
 *  The information in this software is subject to change without notice and *
 *  should not be construed as a commitment by Technology Concepts Inc.      *
 *****************************************************************************
 * 
 * Version:     1        Revision: 1
 * 
 * Facility:    Example program 
 *
 * Product:     SunLink DNI
 * 
 * Abstract:    This program demonstrates how to exchange messages with a
 *              remote process using SunLink DNI. This operation is called
 *              task-to-task communication and is performed by issuing commands
 *              to the SunLink DNI network software.
 *
 *              This program demonstrates how to:
 *
 *		1) Establish a logical link as the requestor  
 *                
 *                 A logical link must be established between your process and
 *                 the remote process before messages can be exchanged.
 *                 To establish a logical link, one process must initiate
 *                 the link request. The initiating process is 
 *                 called the requestor and the other is called the server.
 *                 This program is an example of the requestor. It requests 
 *                 a connection to a server.
 *
 *              2) Exchange messages over the link
 *
 *                 Once the logical link is established, no distinction is
 *                 made between the requestor and the server. Both processes 
 *                 can receive and send messages across the logical link using
 *                 the read and write functions. The sending and receiving
 *                 of messages is application dependent. 
 *
 *              3) Terminate the logical link
 *
 *                 A logical link should be closed before program termination. 
 *****************************************************************************/

#include	<stdio.h>
#include	<fcntl.h>
#include	<sys/ioctl.h>
#include	<netdni/dni.h>

#define  NUM_BYTES  100		/* Maximum number of bytes to read */

short ll;			/* Logical link identifier */
char buffer[NUM_BYTES];		/* Character buffer */
OpenBlock opblk;		/* OpenBlock defined in dni.h */
Image16 opt;			/* optional data temporary */

int bad_request = 0;		/* use adb to change this so things fail */

extern int errno;

/*  Program description
 * 
 *  We will request logical connection to the server named "EXAMPLE" on our
 *  local node.  If the server accepts our link request, we will send
 *  it the message "This is an example".  We will then wait for the reply 
 *  message, "Got it".  After we receive this message we will terminate the
 *  connection and exit the program successfully.  If an error is returned 
 *  the error handler routine will be called to display the error number,
 *  terminate the connection, and exit the program.
 *  
 */
main()
{
	int i;
	int ret;
	int len;

	/*
	 * To request a logical link, we must first open the logical link
	 * device, "/dev/dni". Open() will return a file descriptor of the
	 * logical link. If the returned value is -1, an error occurred on
	 * the open. The external variable errno contains the error code. 
	 */
	ll = open("/dev/dni", O_RDWR);
	if (ll == -1) {
		dnierror("Open Fail");
		exit(1);
	}

	if (ioctl(ll, SES_GET_LINK, 0)) {
		dnierror("Error getting a logical link");
		exit(1);
	}

	/*
	 * Next, we must make the link request to the server. To do this, we
	 * must specify the remote system and the server we want to connect
	 * to. In addition, we must identify ourself so the server knows who
	 * is making the request. This information is contained in a data
	 * structure called the OpenBlock. We will fill in an OpenBlock with
	 * the necessary data, then issue the SES_LINK_ACCESS ioctl request
	 * to make the link request to the server. Ioctl() will return a 0 if
	 * the link is established to the server. If it returns a -1, the
	 * link is not open. The reason or error number is contained in the
	 * external variable errno.  
	 */
	/* null node name is local node, could make this more fancy */
	strcpy(opblk.op_node_name, "");		/* Remote system name */
	strcpy(opblk.op_task_name, "EXAMPLE");	/* Server task name */
	if (bad_request)
		strcpy(opblk.op_userid, "HARRY");	/* Invalid id */
	else
		strcpy(opblk.op_userid, "REQUEST");	/* Our id */
	opblk.op_object_nbr = 0;		/* Any fields not used */
	opblk.op_account[0] = '\0';		/* should be set to zero */
	opblk.op_password[0] = '\0';
	opblk.op_opt_data.im_length = 0;

	if (ioctl(ll, SES_LINK_ACCESS, &opblk)) {
		dnierror("Ioctl Link Access failed");
		ioctl(ll, SES_GET_OPT_DATA, &opt);
		printf("%d bytes of optional reject data: ", opt.im_length);
		for (i = 0; i < opt.im_length; i++)
			printf("%x ", opt.im_data[i] & 0xff);
		printf("\n");
		exit(1);
	}

	/*
	 * The logical link is established once our connect request is
	 * accepted by the server. We may now proceed to send and receive
	 * data across the link using read and write. We will now send
	 * (write) the message "This is an example" to the remote system. We
	 * will then wait to receive (read) the response message before
	 * terminating the connection. Note that we are using the default I/O
	 * options, stream data format and blocking reads. 
	 */

	/*
	 * First, copy the message to send into the character buffer. The
	 * copied string is NULL terminated so we must add 1 to the string
	 * length for the NULL. Then send the message. 
	 */
	strcpy(buffer, "This is an example");
	len = strlen(buffer) + 1;
	if (write(ll, buffer, len) < 0) {
		dnierror("Write failed");
		exit(1);
	}

	/* Wait to receive the response message. */
	if ((ret = read(ll, buffer, NUM_BYTES)) < 0) {
		dnierror("Read failed");
		exit(1);
	}

	/*
	 * If the read was successful, display the message. Note that ret
	 * contains the actual number of bytes received. 
	 */
	display_msg(buffer, ret);

	/*
	 * Terminate the connection before successfully exiting the program.
	 * This example chooses not to send the optional disconnect data
	 * Therefore, only the close() function is needed. 
	 */
	close(ll);
}

/*
 *  Display message
 */
display_msg(buf, count)
	char *buf;
	int count;
{
	int i;

	/* Display count number of characters from the buffer buf */
	for (i = 0; i < count; i++) {
		putchar(*buf);
		++buf;
	}

	putchar('\n');
	return;
}
