#ifndef lint
static char sccsid[] = "@(#)server.c 7.3 91/02/11 Copyr 1986 Sun Micro";
#endif

/*
 * Module:  SERVER.C
 * 
 *****************************************************************************
 *       COPYRIGHT (C) 1985 by Technology Concepts Inc.                      *
 *                             Sudbury, Massachusetts 01776                  *
 *                             -- ALL RIGHTS RESERVED --                     *
 *                                                                           *
 *  This software is furnished under license and may be used and copied      *
 *  only in accordace with the terms of such license and with the inclusion  *
 *  of the above copyright notice. This software or any other copies thereof *
 *  may not be provided or otherwise made available to any other person. No  *
 *  title to and ownership of the software is hereby transferred.            *
 *                                                                           *
 *  The information in this software is subject to change without notice and *
 *  should not be construed as a commitment by Technology Concepts Inc.      *
 *****************************************************************************
 * 
 * Version:     1        Revision: 1
 * 
 * Facility:    Example program 
 *
 * Product:     SunLink DNI
 * 
 * Abstract:    This program demonstrates how to exchange messages with a
 *              remote process using SunLink DNI. This operation is called
 *              task-to-task communication and is performed by issuing commands
 *              to the SunLink DNI network software.
 *
 *              This program demonstrates how to:
 *
 *		1) Establish a logical link as a server  
 *                
 *                 A logical link must be established between your process and
 *                 the remote process before messages can be exchanged.
 *                 To establish a logical link, one process must initiate
 *                 the link request. The initiating process is 
 *                 called the requestor and the other is called the server. 
 *                 This program is an example of the server. It demonstrates  
 *                 how a server process registers itself and waits for a
 *                 request. It also demonstrates how a server may use the
 *                 the access control information received with a request to 
 *                 decide whether to accept or reject the link request.
 *
 *              2) Exchange messages over the link
 *
 *                 Once the logical link is established, no distinction is
 *                 made between the requestor and the server. Both processes 
 *                 can receive and send messages across the logical link using
 *                 the read() and write() functions.
 *
 *              3) Terminate the logical link
 *
 *                 A logical link should be closed before process termination. 
 *                 A server program must reopen the logical link device and
 *                 re-register itself before it can receive additional requests
 *****************************************************************************/

#include	<stdio.h>
#include	<fcntl.h>
#include	<sys/ioctl.h>
#include	<netdni/dni.h>

#define  NUM_BYTES  100		/* Maximum number of bytes to read */

short ll;			/* Logical link identifier */
char buffer[NUM_BYTES];		/* Character buffer */
OpenBlock opblk;		/* OpenBlock */

extern int errno;

/*  Program description
 * 
 *  We will register ourself as a server for the task name "EXAMPLE"
 *  and wait for a link request. If the request received is for the user
 *  "REQUEST", we will accept the link request, otherwise we will reject it.
 *  Once a logical link is established, we will wait to receive (read) 
 *  the message "This is an example". Upon receiving it, we will display
 *  it and send back (write) the reply message, "Got it". Then we will 
 *  terminate the connection, and exit the program successfully.
 *  If an error is returned the error handler routine will be called
 *  to display the error and terminate the process.
 */
main()
{
	int len;
	int ret;
	static SessionData sd = {0, {0, ""}};

	/*
	 * Before establishing a logical link, we must first
	 * open the logical link device, "/dev/dni". 
	 */
	if ((ll = open("/dev/dni", O_RDWR)) < 0) {
		dnierror("Open Fail");
		exit(1);
	}

	if (ioctl(ll, SES_GET_LINK, 0)) {
		dnierror("Error getting a logical link");
		exit(1);
	}

	/*
	 * Next, we must register ourself as a server. We will register
	 * ourself as a server for the task name "EXAMPLE". This is
	 * accomplished by using ioctl(), to issue the SES_NAME_SERVER
	 * request to the DNI network software 
	 */
	if (ioctl(ll, SES_NAME_SERVER, "EXAMPLE") < 0) {
		dnierror("Ioctl Name Server Failed");
		exit(1);
	}

	/*
	 * Once registered as a server, we must wait for the access control
	 * information from a requestor. This is accomplished by the
	 * SES_GET_AI ioctl request. When a link request comes in, the
	 * requestor's access control information will be copied into our
	 * OpenBlock. Note that this ioctl() will not return until a request
	 * is made for this server or an error occurs.	 
	 */
	if (ioctl(ll, SES_GET_AI, &opblk) < 0) {
		dnierror("Ioctl Get AI Failed");
		exit(1);
	} else {
		/*
		 * We received a request and the access control information.
		 * We must now determine whether or not we want to accept or
		 * reject the request. This determination is application
		 * dependent. In this example, we will accept the request if
		 * it is from the user "REQUEST", otherwise we will reject
		 * it with some optional session reject data.
		 */
		if (strcmp(opblk.op_userid, "REQUEST") == 0) {
			if (ioctl(ll, SES_ACCEPT, &sd) < 0) {
				dnierror("Ioctl Accept failed");
				exit(1);
			}
		} else {
			sd.sd_reason = ACCESS_CONT;
			sd.sd_data.im_length = 7;
			bcopy("ACCESS", sd.sd_data.im_data, 7);
			if (ioctl(ll, SES_REJECT, &sd) < 0) {
				dnierror("Ioctl Reject Failed");
				exit(1);
			}

			/*
			 * A close command must always be issued after a
			 * SES_REJECT. 
			 */
			close(ll);
			exit(1);
		}

	}		/* end received Open Block */

	/*
	 * The logical link is established once we (the server) accept the
	 * link request. We may now proceed to send and receive data across
	 * the link using read and write. We will first wait to receive
	 * (read) the message "This is an example" from the remote system.
	 * Upon receiving it, we will display it and send back (write) the
	 * message "Got it". Then we will terminate the connection. Note that
	 * we are using the default I/O data format and Input mode. They are
	 * stream data format and blocking reads. 
	 */

	/* Wait to receive a message from the remote system */
	if ((ret = read(ll, buffer, NUM_BYTES)) < 0) {
		dnierror("Read Failed");
		exit(1);
	}

	/*
	 * If no error occurred, display the message. Note that ret contains
	 * the actual number of bytes received. 
	 */
	display_msg(buffer, ret);

	/*
	 * Copy the response message into the allocated character buffer. The
	 * copied string is NULL terminated, so we must add 1 to the string
	 * length for the NULL. Then send the response message. 
	 */
	strcpy(buffer, "Got it");
	len = strlen(buffer) + 1;
	if (write(ll, &buffer[0], len) < 0) {
		dnierror("Write Failed");
		exit(1);
	}

	/*
	 * Terminate the connection before successfully exiting the program.
	 * This example chooses not to send the optional disconnect data.
	 * Therefore, only the close() is needed. 
	 */
	close(ll);
	return;
}

/*
 *   Display message
 */
display_msg(buf, count)
	char *buf;
	int count;
{
	int i;

	/* Display count number of characters from the buffer buf */
	for (i = 0; i < count; i++) {
		putchar(*buf);
		++buf;
	}
	putchar('\n');
	return;
}
