/*
*  This file contains values that appear in the variable nfars_errno
*     indicating the exact cause of the failure of an NFARS function
*
*/

/*
*    global error reporting variables
*/

extern	short nfars_errno;
extern	short nfars_dperror;

/*
 *	nfars_errno values
 */

#define NF_SUCCESS		0	/* operation was successful */
#define NF_ELOCPROTO		1       /* local discovered protocol error */ 
#define NF_EREMPROTO		2	/* remote discovered protocol error */ 
#define NF_EUNKNOWN            	3	/* error unknown */
#define	NF_EDAP                	4	/* DAP error detected */
#define NF_EMSGBUILD            5	/* message building failed */
#define NF_EUNSUPPOP		6       /* unsupported operation */
#define NF_EOPABORT		7	/* operation aborted */
#define NF_ESTABLE             	8  	/* state table error */
#define NF_EOPFAIL             	9	/* network operation failed at remote */
#define NF_EINVWILDOP          	10	/* invalid wildcard operation */
#define NF_ELNOTESTAB   	11	/* link was not established */
#define NF_EINACTLINK		12	/* inactive DAP link */
#define	NF_EALLOCNCB		13	/* cannot alloc NFARS NCB structure */
#define	NF_EINVNFD		14	/* invalid NFD/NWD */
#define	NF_EINCARG		15	/* inconsistant arguments */
#define	NF_EINAPPOP		16	/* inappropriate operation */
#define	NF_EFILESPEC		17	/* invalid or missing filespec */
#define NF_EINVVOL	       	18      /* invalid device or volume */
#define NF_EINVDIR		19	/* invalid directory */
#define NF_EINVFILE		20	/* invalid file */
#define NF_EINVVER	       	21      /* invalid version */
#define NF_EDIRNOATTRIB        	22	/* no file attributes for dir list */
#define NF_EDIRNAME       	23	/* error in reading name for dir list */
#define NF_EDIRATTRIB       	24	/* error in reading attribs; dir list */
#define NF_EDIRNORECOVERY  	25	/* unable to recover; dir list */
#define NF_ENOMOREF           	26	/* no more files (wildcard expansion) */
#define NF_EDELFDIR            	27  	/* error deleting full directory */
#define	NF_EDELLOCKF           	28      /* error deleting a locked file */
#define	NF_EDELFILE		29	/* error deleting a file */
#define NF_ERENDIFFDEV         	30	/* 2 different devices in rename */
#define NF_ERENFILESYS         	31	/* cannot rename old file systems */
#define NF_ERENDIR             	32	/* invalid directory rename operation */
#define	NF_ERENNODES		33	/* inconsistant nodes for rename */
#define	NF_ERENACI		34	/* rename mismatch Access Control info*/
#define NF_ERENFLOST           	35	/* rename failed; file lost */
#define NF_ENOFILE	      	36 	/* file not found */
#define NF_EFEXISTS		37      /* file already exists */
#define NF_EACCESS	       	38	/* access permission violation */
#define	NF_EOSDENY		39	/* priv violation (os denied access) */
#define NF_EFILELOCK	       	40	/* file is locked by another user */
#define NF_EFILEOPEN	       	41      /* error in opening file */
#define NF_EFILEREAD	       	42      /* error in reading file */
#define NF_EFILEWRITE	       	43      /* error in writing file */
#define NF_EFILEFULL	       	44	/* device or file are full */
#define NF_EFILECLOSE	       	45      /* error in closing file */
#define NF_EFILEEND		46	/* end of file */
#define	NF_EBADDATA		47	/* bad data format */
#define	NF_EMEMALLOC		48	/* can't allocating memory */
#define	NFLASTERROR	NF_EMEMALLOC	/* last error of this list */
