/*	@(#)stdlib.h 1.2 89/10/10 SMI; from include/stdlib.h 1.6 */

/*
 * stdlib.h
 */

#ifndef	__stdlib_h
#ifndef _PARAMS
#if defined(__STDC__) || defined(__cplusplus)
#define _PARAMS(ARGS) ARGS
#else
#define _PARAMS(ARGS) ()
#endif
#endif /* _PARAMS */
#define	__stdlib_h

#include <sys/stdtypes.h>	/* to get size_t */

extern unsigned int _mb_cur_max;
#define MB_CUR_MAX    _mb_cur_max

#define	mblen(s, n)	mbtowc((wchar_t *)0, s, n)

/* declaration of various libc functions */
extern void	abort(/* void */);
extern int	abs _PARAMS((int));
extern double	atof _PARAMS((const char *));
extern int	atoi _PARAMS((const char *));
extern long int	atol _PARAMS((const char *));
extern char *	bsearch _PARAMS((const void *, const void *, __SIZE_TYPE__ , __SIZE_TYPE__ , int (*) (const void *, const void *)));
extern void *	calloc _PARAMS((__SIZE_TYPE__ , __SIZE_TYPE__ ));
extern void	exit _PARAMS((int));
extern void	free _PARAMS((void *));
extern char *	getenv _PARAMS((const char *));
extern void *	malloc _PARAMS((__SIZE_TYPE__ ));
extern int	qsort _PARAMS((void *, __SIZE_TYPE__ , __SIZE_TYPE__ , int (*) (const void *, const void *)));
extern int	rand(/* void */);
extern void *	realloc _PARAMS((void *, __SIZE_TYPE__ ));
extern int	srand _PARAMS((unsigned int));

extern int    mbtowc _PARAMS((__WCHAR_TYPE__ *, const char *, __SIZE_TYPE__ ));
extern int    wctomb _PARAMS((char *, __WCHAR_TYPE__ ));
extern size_t mbstowcs _PARAMS((__WCHAR_TYPE__ *, const char *, __SIZE_TYPE__ ));
extern size_t wcstombs _PARAMS((char *, const __WCHAR_TYPE__ *, __SIZE_TYPE__ ));

#if defined(__cplusplus) || defined(__USE_FIXED_PROTOTYPES__)
extern int atexit (void (*) (void));
extern long int labs (long int);
extern int putenv (char *);
extern double strtod (const char *, char **);
extern long int strtol (const char *, char **, int);
extern long unsigned int strtoul (const char *, char **, int);
extern int system (const char *);
#endif /* defined(__cplusplus) || defined(__USE_FIXED_PROTOTYPES__*/
#endif
