/*	@(#)setjmp.h 1.4 89/06/16 SMI; from UCB 4.1 83/05/03	*/

#ifndef	__sun3_setjmp_h
#ifndef _PARAMS
#if defined(__STDC__) || defined(__cplusplus)
#define _PARAMS(ARGS) ARGS
#else
#define _PARAMS(ARGS) ()
#endif
#endif /* _PARAMS */
#define	__sun3_setjmp_h

/*
 * onsstack,sigmask,sp,pc,psl,d2-d7,a2-a6,
 * fp2-fp7, 	for 68881
 * fpa4-fpa15	for FPA
 */
#define	_JBLEN	58

typedef	int jmp_buf[_JBLEN];

/*
 * One extra word for the "signal mask saved here" flag.
 */
typedef	int sigjmp_buf[_JBLEN+1];

int	setjmp _PARAMS((jmp_buf));
int	_setjmp _PARAMS((jmp_buf));
int	sigsetjmp _PARAMS((sigjmp_buf, int));
void	longjmp _PARAMS((jmp_buf, int));
void	_longjmp _PARAMS((jmp_buf, int));
void	siglongjmp _PARAMS((sigjmp_buf, int));

/*
 * Routines that call setjmp have strange control flow graphs,
 * since a call to a routine that calls resume/longjmp will eventually
 * return at the setjmp site, not the original call site.  This
 * utterly wrecks control flow analysis.
 */
#pragma unknown_control_flow(sigsetjmp, setjmp, _setjmp)

/*
 * On the 68000, there is the additional problem that registers
 * are restored to their values at the time of the call to setjmp;
 * they should be set to their values at the time of the call to
 * whoever eventually called longjmp.  Thus, on routines that call
 * setjmp, automatic register allocation must be suppressed.
 */
#pragma makes_regs_inconsistent(sigsetjmp, setjmp, _setjmp)

#endif	/* !__sun3_setjmp_h */
