/*******************************************************************************
********************************************************************************
****                                                                        ****
****                   Copyright 1986, 1988 Ciprico, Inc.                   ****
****                                                                        ****
****                         Ciprico Incorporated                           ****
****                           2955 Xenium Lane                             ****
****                          Plymouth, MN  55441                           ****
****                            (612) 559-2034                              ****
****                                                                        ****
****	Module Name:	rferr.h                                             ****
****	Package:	Rimfire 3200/3400 Unix 4.2 BSD for Sun 3/160        ****
****	Date:		$Date:   13 Feb 1989 13:49:02  $		    ****
****	Module Rev:	$Revision:   1.16  $				    ****
****									    ****
****	Subroutines:    None                                                ****
****	                                                                    ****
****	Description:                                                        ****
****		This is an include file for the Rimfire 3200/3400 driver.   ****
****		It defines the possible errors which can occur.             ****
****	                                                                    ****
********************************************************************************
*******************************************************************************/

/*******************************************************************************
*									       *
*				Revision History			       *
*									       *
********************************************************************************

    Revision    Date		Author
	Description of Change
--------------------------------------------------------------------------------

    1.1		04/01/86	M. J. Tobias
	Initial Release

    1.2		11/12/86	D. A. Dickey
	Incorporated 3400 modifications

    1.3		87/09/25	J. E. Lind
	Added error codes 0a, 0f, 10, 11, 12, 2f and 33

    1.8 	87/11/11	J. E. Lind
	Added error code 31

    1.9		88/1/3		J. E. Lind
	No change

    1.10	88/1/28		J. E. Lind
	g)  Removed redundant error codes from rfmsg.

    1.11	88/4/27         J. D. Flatt
       No change

    1.12 	88/6/24		J. E. Lind
	a) Put the "lint" take on the "ifndef" for the SCCS id which
	   was put in at 1.11.

    1.13	88/7/27		J. E. Lind
	No change.

    1.14	88/8/88		J. E. Lind
	No change.
    
    $Log:   I:\software\drivers\rf3200\sun\vcs\rferr.h_v  $
   
      Rev 1.16   13 Feb 1989 13:49:02   JLind
   1.16:
     a) Increase the I/O control group representation to one per controller
        rather than one per driver.  This is really a bug fix for a bug
        left over from when the driver was first expanded to support
        multiple controllers.
        [rf.c,rfparam.h]
   
     b) Removed the GOPTWDL (Write Data Loaded) flags since the handling
        of Write Data Loaded had never been completely implemented.  This
        problem first showed up when the controllers began looking at
        this flag.
        [rf.c]
   
     c) Cleared the label magic number before reading the label to
        ensure that we don't get a false label display.
        [rf.c]
   
     d) Any sector containing an error according to the manufacturer's
        defect list is now considered bad.  Before, errors contained
        within the head scatter and gap3 were considered "harmless".
        [rfutil.c]
   
     e) Add the ability to examine the IDs of a track.  The track is reported
        as being map or bad, or the skew is shown, along with any "inter-
        esting" sectors.  The ioctl DKIOCTRAKID command (as used by compsec
        within rfutil) was renamed to DKIOCPHYSID to better reflect its
        function (returning the ID of a specified physical sector on a track),
        while DKIOCTRAKID returns the IDs of all sectors on a track. 
        DKIOCPHYSID is the same value as the old DKIOTRAKID for binary
        compatibility.  In the process, the interesting id FLAG, SECTOR,
        and ALT values were given meaningful names and moved to rfreg.h.
        XTCOFF and POSCOFF were moved from rfparam.h to rfreg.h.
        [rfutil.c,rfreg.h,rfparam.h,rfioctl.h,rf.c]
   
     f) The input routine (getcyltrack) which requests block numers or
        cylinder/head pairs now does so on one line, hopefully reducing
        user confusion.
        [rfutil.c]
   
     g) The map sector routine now asks whether you wish to map by track
        or sector.  Mapping by track helps out by figuring the track
        boundaries.
        [rfutil.c]
   
     h) A bug in ver_cyl incorrectly computed the block number from c/h/s,
        failing to verify the full disk.  The block numbers reported as
        failing really did fail and really were processed properly, but did
        not correspond to the c/h/s displayed.  Also, the variable "badhead"
        and the associated computations were discarded from the "ver_to"
        routines, since this information was already available.
        [rfutil.c]
   
     i) Slipping now accepts the block to slip either in c/h/s or as
        a block number through the use of a new routine, rdblkno.
        Rdblkno will accept input in either form if the label or
        geometry is available, but only as a block number if they are
        not.
        [rfutil.c]
   
     j) Corrected bzero(...,sizeof (EXTB)) to be bzero(...,sizeof(EXTPB)).
        [rf.c]
   
     k) Corrected comparison of unit number to be >= NRF instead of > NRF
        in several locations and moved assignment of the automatic variable
        device out of the declaration in rfdump() so that a bounds check is
        performed on unit.
        [rf.c]
   
      Rev 1.15   23 Nov 1988 13:12:08   JLind
           a) Corrected the indexing of rfcontroller_info to be by
   	   CONTROLLER number rather than DRIVE number (duh!),
   	   thereby fixing the dreaded dkinfo and newfs crashes.
   	   [rf.c]
   	b) Inserted debug flag tests on "not alive" messages.
   	   [rf.c]
   	c) Dual-port support.
   	   [rf.c,rfreg.h]
   	d) STANDALONE support for standalone rfutil.
   	   [rf.c, rfutil.c]
   	e) Changed default control group cache control to use full cacheing
   	   and sorting. [rfparam.h]
   	f) added safealloc and safefree (replacing rmalloc and rmfree,
   	   respectively) to make the driver insensitive to misalignment of
   	   the iopbmap resource, while also not causing it for anyone else.
   	   [rf.c]
    
   
   
   
   
*******************************************************************************/
#ifndef lint	/* 1.12a */
static char	Sccsh3id[] = "@(#)rferr.h  75182013 $Revision:   1.16  $ $Date:   13 Feb 1989 13:49:02  $ Copyright 1986, 1988 Ciprico, Inc.";
#endif


/************************************************************************
 *	Error Codes
 ************************************************************************/

#define ERRFILE		/* we were here */


#define	RFE_INVCMD	0x01	/* invalid command */
#define	RFE_UNITNO	0x02	/* bad unit number */
#define	RFE_UNITTYPE	0x03	/* invalid unit for this command */
#define	RFE_NOCONF	0x04	/* drive not configured */
#define	RFE_BLOCKSTRT	0x06	/* invalid logical block number */
#define	RFE_BLOCKCNT	0x07	/* bad number of block specified */
#define	RFE_TRACKSTRT	0x08	/* bad track starting block */
#define	RFE_TRACKCNT	0x09	/* bad number of blocks for track-wide op */
#define	RFE_BADTAG	0x0a	/* bad tag number */
#define	RFE_NOTZERO	0x0b	/* reserved field in parameter block not zero */
#define	RFE_SGLISTSIZ	0x0c	/* bad number of scatter/gather headers */
#define	RFE_INVTABLE	0x0d	/* bad length of scatter/gather table */
#define RFE_INVCMDLS	0x0f	/* bad command list size */
#define RFE_INVCMDLN	0x10	/* bad command list number >7 or <1 */
#define	RFE_INVCMDL	0x11	/* command list cannot be started/stopped */
#define RFE_SWBTO	0x12	/* software bus timeout */
#define	RFE_BUSTIME	0x13	/* VMEbus memory timeout */
#define	RFE_NODRIVE	0x14	/* drive won't select or not present */
#define	RFE_DRIVERDY	0x15	/* drive is not ready */
#define RFE_DRIVEBSY	0x16	/* disk busy */
#define	RFE_SEEKFAULT	0x1c	/* drive reported seek fault */
#define	RFE_WRITFAULT	0x1e	/* write fault detected */
#define	RFE_OVERRUN	0x23	/* sector too short / overrun error */
#define	RFE_ECC		0x24	/* data ECC error, no correction done */
#define	RFE_IDSYNC	0x25	/* ID sync error (sector not found) */
#define	RFE_IDCRC	0x26	/* ID CRC error */
#define	RFE_DATASYNC	0x27	/* no data synchronization */
#define	RFE_SEEKTIME	0x28	/* seek timeout */
#define	RFE_DATATIME	0x29	/* data operation timeout */
#define	RFE_MISSEEK	0x2a	/* misseek / bad disk format */
#define	RFE_SECTORID	0x2b	/* error reading sector ID */
#define	RFE_ACCESSBAD	0x2c	/* direct access to a bad track or sector */
#define	RFE_ECCTRY	0x2d	/* ECC correction performed */
#define	RFE_ECCFAIL	0x2e	/* ECC correction failed */
#define RFE_SECTCOUNT	0x2f	/* bad sector count	*/
#define RFE_WRITEPROT	0x31	/* drive write protected */
#define	RFE_INVSECTRK	0x32	/* sectors per track greater than physical */
#define	RFE_BADBPS	0x33	/* bad bytes/sector field */
#define	RFE_TOOLONG	0x34	/* field too long */
#define	RFE_BADPARAM	0x37	/* bad parameter in configure command */
#define	RFE_IOCG0	0x39	/* attempt to initialize control group 0 */
#define	RFE_BADSOURCE	0x3a	/* bad source in defect mapping command */
#define	RFE_BADDEST	0x3b	/* bad destination in defect mapping command */
#define	RFE_NOSPARE	0x3c	/* no spare sectors left on this track */
#define	RFE_RECOVERY	0x3d	/* bad recovery field in defect mapping cmd */
#define	MAXERRCODE	0x3d

/************************************************************************
 *	Error Messages
 ************************************************************************/

#ifndef NORFMSG
char *rfmsg[] = {
/* 0x00 */	"unknown",
/* 0x01 */	"invalid command",
/* 0x02 */	"bad unit number specification",
/* 0x03 */	"bad unit type for this command",
/* 0x04 */	"drive not configured",
/* 0x05 */	"unknown",
/* 0x06 */	"bad logical block number specified",
/* 0x07 */	"bad number of blocks specified",
/* 0x08 */	"bad track starting block",
/* 0x09 */	"bad number of block for track-wide operation",
/* 0x0a */	"bad tag",
/* 0x0b */	"reserved field not zero",
/* 0x0c */	"bad number of scatter/gather headers specified",
/* 0x0d */	"bad length of scatter/gather table",
/* 0x0e */	"command list stopped (info only)",
/* 0x0f */	"command list size invalid",
/* 0x10 */	"command list number invalid",
/* 0x11 */	"command list already started/stopped",
/* 0x12 */	"software bus timeout",
/* 0x13 */	"VMEbus memory timeout",
/* 0x14 */	"drive won't select or not present",
/* 0x15 */	"drive not ready",
/* 0x16 */	"disk busy",
/* 0x17 */	"unknown",
/* 0x18 */	"unknown",
/* 0x19 */	"unknown",
/* 0x1a */	"unknown",
/* 0x1b */	"unknown",
/* 0x1c */	"drive reported seek fault",
/* 0x1d */	"unknown",
/* 0x1e */	"write fault detected",
/* 0x1f */	"unknown",
/* 0x20 */	"unknown",
/* 0x21 */	"unknown",
/* 0x22 */	"unknown",
/* 0x23 */	"sector too short / overrun error",
/* 0x24 */	"data ECC error, no correction done",
/* 0x25 */	"ID sync error, sector not found",
/* 0x26 */	"ID CRC error",
/* 0x27 */	"no data synchronization",
/* 0x28 */	"seek timeout",
/* 0x29 */	"data operation timeout",
/* 0x2a */	"misseek / bad disk format",
/* 0x2b */	"error reading sector ID",
/* 0x2c */	"direct access to bad track or sector",
/* 0x2d */	"ECC correction performed",
/* 0x2e */	"ECC correction failed",
/* 0x2f */	"sector count doesn't match hardware",
/* 0x30 */	"unknown",
/* 0x31 */	"drive write protected",
/* 0x32 */	"sectors per track bad or greater than physical size",
/* 0x33 */	"bytes/sector field bad",
/* 0x34 */	"field too long (preamble gap)",
/* 0x35 */	"unknown",
/* 0x36 */	"unknown",
/* 0x37 */	"bad parameter in configure command",
/* 0x38 */	"unknown",
/* 0x39 */	"attempt to initialize control group 0",
/* 0x3a */	"bad source in defect mapping command",
/* 0x3b */	"bad destination in defect mapping command",
/* 0x3c */	"no spares left on track",
/* 0x3d */	"bad recovery field in defect mapping command"
};
#else
extern char *rfmsg[];
#endif
