/*******************************************************************************
********************************************************************************
****                                                                        ****
****                   Copyright 1986, 1988 Ciprico, Inc.                   ****
****                                                                        ****
****                         Ciprico Incorporated                           ****
****                           2955 Xenium Lane                             ****
****                          Plymouth, MN  55441                           ****
****                            (612) 559-2034                              ****
****                                                                        ****
****	Module Name:	rfioctl.h                                           ****
****	Package:	Rimfire 3200/3400 Sun OS driver for Sun 3/160       ****
****	Date:		$Date:   13 Feb 1989 11:46:58  $		    ****
****	Module Rev:	$Revision:   1.16  $				    ****
****	                                                                    ****
****	Subroutines:    None                                                ****
****	                                                                    ****
****	Description:                                                        ****
****		This is the include file for ioctl calls used in the        ****
****		Rimfire 3200/3400 Disk controller driver which are not	    ****
****		directly supported by Sun OS.                               ****
****	                                                                    ****
********************************************************************************
*******************************************************************************/

/*******************************************************************************
*									       *
*				Revision History			       *
*									       *
********************************************************************************

    Revision    Date		Author
	Description of Change
--------------------------------------------------------------------------------

    1.1		04/16/86	M. J. Tobias
	Initial Release
    1.2		11/12/86	D. A. Dickey
	Incorporate changes for Rimfire 3400
    1.3		03/13/87	R. A. Simning

    1.6 	87/11/11	J. E. Lind
	Added ESDI defect list to dk_rdb.

    1.9		87/12/15 - 88/1/3	J. E. Lind
	c)  Added dkd_error to the read defect list structure (had to rearrange
	    it to accomplish this) and dkf_error to disk format request
	    structure.
	f)  Added DKIOCRESDI and DKIOCSMDCHR to support disk enquiry.
    1.10	88/3/14			J. E. Lind
	No change.
    1.11	88/4/27 	        J. D. Flatt
       No change

    1.12	88/7/5		J. E. Lind
	No change.

    1.13	88/7/27		J. E. Lind
	No change.

    1.14	88/8/88		J. E. Lind
	No change.

    $Log:   I:\software\drivers\rf3200\sun\vcs\rfioctl.h_v  $
   
      Rev 1.16   13 Feb 1989 11:46:58   JLind
   1.16:
     a) Increase the I/O control group representation to one per controller
        rather than one per driver.  This is really a bug fix for a bug
        left over from when the driver was first expanded to support
        multiple controllers.
        [rf.c,rfparam.h]
   
     b) Removed the GOPTWDL (Write Data Loaded) flags since the handling
        of Write Data Loaded had never been completely implemented.  This
        problem first showed up when the controllers began looking at
        this flag.
        [rf.c]
   
     c) Cleared the label magic number before reading the label to
        ensure that we don't get a false label display.
        [rf.c]
   
     d) Any sector containing an error according to the manufacturer's
        defect list is now considered bad.  Before, errors contained
        within the head scatter and gap3 were considered "harmless".
        [rfutil.c]
   
     e) Add the ability to examine the IDs of a track.  The track is reported
        as being map or bad, or the skew is shown, along with any "inter-
        esting" sectors.  The ioctl DKIOCTRAKID command (as used by compsec
        within rfutil) was renamed to DKIOCPHYSID to better reflect its
        function (returning the ID of a specified physical sector on a track),
        while DKIOCTRAKID returns the IDs of all sectors on a track. 
        DKIOCPHYSID is the same value as the old DKIOTRAKID for binary
        compatibility.  In the process, the interesting id FLAG, SECTOR,
        and ALT values were given meaningful names and moved to rfreg.h.
        XTCOFF and POSCOFF were moved from rfparam.h to rfreg.h.
        [rfutil.c,rfreg.h,rfparam.h,rfioctl.h,rf.c]
   
     f) The input routine (getcyltrack) which requests block numers or
        cylinder/head pairs now does so on one line, hopefully reducing
        user confusion.
        [rfutil.c]
   
     g) The map sector routine now asks whether you wish to map by track
        or sector.  Mapping by track helps out by figuring the track
        boundaries.
        [rfutil.c]
   
     h) A bug in ver_cyl incorrectly computed the block number from c/h/s,
        failing to verify the full disk.  The block numbers reported as
        failing really did fail and really were processed properly, but did
        not correspond to the c/h/s displayed.  Also, the variable "badhead"
        and the associated computations were discarded from the "ver_to"
        routines, since this information was already available.
        [rfutil.c]
   
     i) Slipping now accepts the block to slip either in c/h/s or as
        a block number through the use of a new routine, rdblkno.
        Rdblkno will accept input in either form if the label or
        geometry is available, but only as a block number if they are
        not.
        [rfutil.c]
   
     j) Corrected bzero(...,sizeof (EXTB)) to be bzero(...,sizeof(EXTPB)).
        [rf.c]
   
     k) Corrected comparison of unit number to be >= NRF instead of > NRF
        in several locations and moved assignment of the automatic variable
        device out of the declaration in rfdump() so that a bounds check is
        performed on unit.
        [rf.c]
   
      Rev 1.15   23 Nov 1988 13:12:02   JLind
           a) Corrected the indexing of rfcontroller_info to be by
   	   CONTROLLER number rather than DRIVE number (duh!),
   	   thereby fixing the dreaded dkinfo and newfs crashes.
   	   [rf.c]
   	b) Inserted debug flag tests on "not alive" messages.
   	   [rf.c]
   	c) Dual-port support.
   	   [rf.c,rfreg.h]
   	d) STANDALONE support for standalone rfutil.
   	   [rf.c, rfutil.c]
   	e) Changed default control group cache control to use full cacheing
   	   and sorting. [rfparam.h]
   	f) added safealloc and safefree (replacing rmalloc and rmfree,
   	   respectively) to make the driver insensitive to misalignment of
   	   the iopbmap resource, while also not causing it for anyone else.
   	   [rf.c]
    
   
   
   
   

*******************************************************************************/
#ifndef lint
static char	Sccshid[] = "@(#)rfioctl.h  75182013 $Revision:   1.16  $ $Date:   13 Feb 1989 11:46:58  $ Copyright 1986, 1988 Ciprico, Inc.";
#endif


/* structures used by ioctl calls */
#define	DKC_RF3200	8	/* another controller type */
#define	DKC_RF3400	9	/* another controller type */

/* disk format request */
struct dk_fmt {
	daddr_t	dkf_blkno;			/* starting block number */
	daddr_t	dkf_nblk;			/* # of blocks */
	u_char  dkf_error;
	daddr_t dkf_badblk;
};

/* disk re-map request */
struct dk_mapr {
	daddr_t	dkm_fblk;			/* from block */
	daddr_t	dkm_tblk;			/* to block */
	daddr_t	dkm_nblk;			/* # of blocks */
	u_char  dkm_recover;
	u_char  dkm_error;
};

/* disk verify request */
struct dk_vfy {
	daddr_t dkv_blkno;
	daddr_t dkv_nblk;
	u_char  dkv_error;
	daddr_t dkv_badblk;
};

/* disk slip request */
struct dk_slip {
	daddr_t dks_fblk;
	u_char  dks_recover;
	u_char  dks_error;
};

/* SMD parameters */
struct smd_param {
	u_char smd_interleave;
	u_char smd_headskew;
	u_char smd_cylskew;
	u_char smd_hgskew;
	u_int  smd_recovery;
	u_char smd_idpre;
	u_char smd_datapre;
};

/* Defect list request */
struct dk_rdb {
	u_char dkd_error;
	union {
		DEFECTSMD smd;
		DEFECTESDI esdi;
	} db;

};

#ifndef	RFSTATS
typedef char	*IORQS;
#endif

/* Command codes for ioctl() calls */
#define DKIOCRESDI	_IOR ('d',24, ESDIPARAMS)	/* return ESDI configuration */
#define DKIOCSMDCHR	_IOR ('d',25, SMDCHRS)	/* get SMD characteristics   */
#define DKIOCFMT	_IOWR('d', 6, struct dk_fmt)	/* format	     */
#define	DKIOCMAP	_IOWR('d', 7, struct dk_mapr)	/* map		     */
#define	DKIOCGDEBUG	_IOR ('d', 9, int)	/* Get driver debug level    */
#define	DKIOCSDEBUG	_IOW ('d',10, int)	/* Set driver debug level    */
#define DKIOCGSTAT	_IOWR('d',11, BOARDST)	/* Get RF3200 statistics     */
#define DKIOCPHYSID	_IOWR('d',44, TRAKID)	/* Get one sequential ID     */
#define DKIOCIDTRAK	_IOW ('d',45, TRAKID **)	/* Get track of ID's	     */

#define DKIOCSEEK	_IOW ('d',46, LOOK)	/* do seek		     */

#define DKIOCRDDAT	_IOW ('d',37, long)	/* read defect data	     */
#define DKIOCRDMAP	_IOWR('d',57, struct dk_rdb) /* read defect map	     */

/* verify blocks, returns bad block in the starting block field (dkf_blkno)  */
#define DKIOCVFY	_IOWR('d',12, struct dk_vfy) /* bad block if cmd fails */
#define DKIOCSLP	_IOWR('d',13, struct dk_slip)    /* sector slipping    */

#define	DKIOCGIOCG	_IOWR('d',14, struct iocgrp)	/* Get iocg settings */
#define	DKIOCSIOCG	_IOW ('d',15, struct iocgrp)	/* Set iocg options  */
#define	DKIOCSSMD	_IOW ('d',16, DEFSMDPB)	/* define SMD parameters     */
#define	DKIOCGSMD	_IOR ('d',17, RETCONF)	/* return configuration	     */
#define	DKIOCGTUNE	_IOR ('d',18, TUNEST)	/* Get Tuning Statistics     */
#define	DKIOCSTUNE	_IOW ('d',19, TUNEST)	/* Set Tuning Statistics     */
#define	DKIOCGIORQN	_IOR ('d',20, long)	/* Retrieve # of IO Requests */
#define	DKIOCGIORQS	_IOWR('d',21, IORQS)	/* Retrieve an IO Request    */
#define	DKIOCIORQC	_IOR ('d',22, long)	/* Clear IO Requests	     */
#define DKIOCGBTYP	_IOR ('d',23, int)	/* Get board type	     */
#define DKIOCGBID	_IOR ('d', 5, RETID)	/* Get board ID		     */
