/*******************************************************************************
********************************************************************************
****                                                                        ****
****                   Copyright 1986, 1988 Ciprico, Inc.                   ****
****                                                                        ****
****                         Ciprico Incorporated                           ****
****                           2955 Xenium Lane                             ****
****                          Plymouth, MN  55441                           ****
****                            (612) 559-2034                              ****
****                                                                        ****
****	Module Name:	rfparam.h                                           ****
****	Package:	Rimfire 3200/3400 Sun OS driver for Sun 3/160       ****
****	Date:		$Date:   13 Feb 1989 11:46:54  $                    ****
****	Module Rev:	$Revision:   1.16  $                                ****
****	                                                                    ****
****	Subroutines:    None                                                ****
****	                                                                    ****
****	Description:                                                        ****
****		Machine dependent configuration initialization.             ****
****	                                                                    ****
********************************************************************************
*******************************************************************************/

/*******************************************************************************
*									       *
*				Revision History			       *
*									       *
********************************************************************************

    Revision    Date		Author
	Description of Change
--------------------------------------------------------------------------------

    1.1		04/16/86	Michael J. Tobias
	Initial Release
    1.2		07/16/86	Michael J. Tobias
	Updated for 32 bit transfers and modified interrupt level
	(32 bit transfer does not work)
    1.3         04/10/87        Mark E. Erickson
	Add read ahead across heads and cylinders
    1.9		88/1/3		John Lind
	No change

    1.10	88/2/24		John Lind
	i) Use address modifier 3D rather than 0D for most sun machines.
    1.11	88/4/27         J. D. Flatt
       No change

    1.12	88/7/5		J. E. Lind
	No change.

    1.13	88/7/27		J. E. Lind
	No change.

    1.14	88/8/28		J. E. Lind
	No change.

    $Log:   I:\software\drivers\rf3200\sun\vcs\rfparam.h_v  $
   
      Rev 1.16   13 Feb 1989 11:46:54   JLind
   1.16:
     a) Increase the I/O control group representation to one per controller
        rather than one per driver.  This is really a bug fix for a bug
        left over from when the driver was first expanded to support
        multiple controllers.
        [rf.c,rfparam.h]
   
     b) Removed the GOPTWDL (Write Data Loaded) flags since the handling
        of Write Data Loaded had never been completely implemented.  This
        problem first showed up when the controllers began looking at
        this flag.
        [rf.c]
   
     c) Cleared the label magic number before reading the label to
        ensure that we don't get a false label display.
        [rf.c]
   
     d) Any sector containing an error according to the manufacturer's
        defect list is now considered bad.  Before, errors contained
        within the head scatter and gap3 were considered "harmless".
        [rfutil.c]
   
     e) Add the ability to examine the IDs of a track.  The track is reported
        as being map or bad, or the skew is shown, along with any "inter-
        esting" sectors.  The ioctl DKIOCTRAKID command (as used by compsec
        within rfutil) was renamed to DKIOCPHYSID to better reflect its
        function (returning the ID of a specified physical sector on a track),
        while DKIOCTRAKID returns the IDs of all sectors on a track. 
        DKIOCPHYSID is the same value as the old DKIOTRAKID for binary
        compatibility.  In the process, the interesting id FLAG, SECTOR,
        and ALT values were given meaningful names and moved to rfreg.h.
        XTCOFF and POSCOFF were moved from rfparam.h to rfreg.h.
        [rfutil.c,rfreg.h,rfparam.h,rfioctl.h,rf.c]
   
     f) The input routine (getcyltrack) which requests block numers or
        cylinder/head pairs now does so on one line, hopefully reducing
        user confusion.
        [rfutil.c]
   
     g) The map sector routine now asks whether you wish to map by track
        or sector.  Mapping by track helps out by figuring the track
        boundaries.
        [rfutil.c]
   
     h) A bug in ver_cyl incorrectly computed the block number from c/h/s,
        failing to verify the full disk.  The block numbers reported as
        failing really did fail and really were processed properly, but did
        not correspond to the c/h/s displayed.  Also, the variable "badhead"
        and the associated computations were discarded from the "ver_to"
        routines, since this information was already available.
        [rfutil.c]
   
     i) Slipping now accepts the block to slip either in c/h/s or as
        a block number through the use of a new routine, rdblkno.
        Rdblkno will accept input in either form if the label or
        geometry is available, but only as a block number if they are
        not.
        [rfutil.c]
   
     j) Corrected bzero(...,sizeof (EXTB)) to be bzero(...,sizeof(EXTPB)).
        [rf.c]
   
     k) Corrected comparison of unit number to be >= NRF instead of > NRF
        in several locations and moved assignment of the automatic variable
        device out of the declaration in rfdump() so that a bounds check is
        performed on unit.
        [rf.c]
   
      Rev 1.15   23 Nov 1988 13:11:56   JLind
           a) Corrected the indexing of rfcontroller_info to be by
   	   CONTROLLER number rather than DRIVE number (duh!),
   	   thereby fixing the dreaded dkinfo and newfs crashes.
   	   [rf.c]
   	b) Inserted debug flag tests on "not alive" messages.
   	   [rf.c]
   	c) Dual-port support.
   	   [rf.c,rfreg.h]
   	d) STANDALONE support for standalone rfutil.
   	   [rf.c, rfutil.c]
   	e) Changed default control group cache control to use full cacheing
   	   and sorting. [rfparam.h]
   	f) added safealloc and safefree (replacing rmalloc and rmfree,
   	   respectively) to make the driver insensitive to misalignment of
   	   the iopbmap resource, while also not causing it for anyone else.
   	   [rf.c]
    
   
   
   
   
*******************************************************************************/
#ifndef lint
static char	Sccsh4id[] = "@(#)rfparam.h  75182013 $Revision:   1.16  $ $Date:   13 Feb 1989 11:46:54  $ Copyright 1986, 1988 Ciprico, Inc.";
#endif


#define	HOST_ID		1	/* unique host identifier */

#ifndef __sun4__
#define	VME_ADD_MOD	0x0D	/* address modifier for extended VME memory */
#else
#define	VME_ADD_MOD	0x3D	/* address modifier for standard VME memory */
#endif

/* 32 bit xfer, NO word or byte swapping */
#define	CNTRL		(CTRLSET | CTRLWID)   /* OR in CTRLWID for 32 bit xfer*/

struct iocgrp iocg[NRFC][MAXIOCG+1] = {
/* group, cache, readahead, recovery, dretry, ndretry, resv */
   { { 0, 0, 0, 0, 11, 3, 0 },
     /* PHYS RD/WT */
     { 1, COPTXCY|COPTXHD|COPTSWT|COPTSRD|COPTSEA, 255, 0, 3, 3, 0 },
     /* 4K Multiples */
     { 2, COPTXHD|COPTSWT|COPTSRD|COPTSEA, 255, 0, 3, 3, 0 },
     /* ~4K Multiples */
     { 3, COPTSWT|COPTSRD|COPTSEA, 0, 0, 3, 3, 0 }, },
#if NRFC > 1
   { { 0, 0, 0, 0, 11, 3, 0 },
     /* PHYS RD/WT */
     { 1, COPTXCY|COPTXHD|COPTSWT|COPTSRD|COPTSEA, 255, 0, 3, 3, 0 },
     /* 4K Multiples */
     { 2, COPTXHD|COPTSWT|COPTSRD|COPTSEA, 255, 0, 3, 3, 0 },
     /* ~4K Multiples */
     { 3, COPTSWT|COPTSRD|COPTSEA, 0, 0, 3, 3, 0 }, },
#if NRFC > 2
   { { 0, 0, 0, 0, 11, 3, 0 },
     /* PHYS RD/WT */
     { 1, COPTXCY|COPTXHD|COPTSWT|COPTSRD|COPTSEA, 255, 0, 3, 3, 0 },
     /* 4K Multiples */
     { 2, COPTXHD|COPTSWT|COPTSRD|COPTSEA, 255, 0, 3, 3, 0 },
     /* ~4K Multiples */
     { 3, COPTSWT|COPTSRD|COPTSEA, 0, 0, 3, 3, 0 }, },
#if NRFC > 3
   { { 0, 0, 0, 0, 11, 3, 0 },
     /* PHYS RD/WT */
     { 1, COPTXCY|COPTXHD|COPTSWT|COPTSRD|COPTSEA, 255, 0, 3, 3, 0 },
     /* 4K Multiples */
     { 2, COPTXHD|COPTSWT|COPTSRD|COPTSEA, 255, 0, 3, 3, 0 },
     /* ~4K Multiples */
     { 3, COPTSWT|COPTSRD|COPTSEA, 0, 0, 3, 3, 0 }, },
#endif
#endif
#endif

/* COPTXHD = READ AHEAD ACROSS HEAD
   COPTXCY = READ AHEAD ACROSS CYLINDERS
   COPTSEA = SEARCH CACHE

   Group 1, for physical I/O, is set up for read ahead across heads, cylinders,
   and searching cache.  Also the read ahead length is 100 sectors.

   Group 2, 4k Multiples: read ahead across heads, and search cache. 
   Also the read ahead length is 100 sectors.

   Group 3, NON 4k Multiples: set the same as group 2. */
};
