/*******************************************************************************
********************************************************************************
****                                                                        ****
****                   Copyright 1986, 1988 Ciprico, Inc.                   ****
****                                                                        ****
****                         Ciprico Incorporated                           ****
****                           2955 Xenium Lane                             ****
****                          Plymouth, MN  55441                           ****
****                            (612) 559-2034                              ****
****                                                                        ****
****	Module Name:	rfreg.h                                             ****
****	Package:	Rimfire 3200/3400 Sun OS driver for Sun 3 & 4       ****
****	Date:		$Date:   13 Feb 1989 11:47:02  $		    ****
****	Module Rev:	$Revision:   1.16  $				    ****
****	                                                                    ****
****	Subroutines:    None                                                ****
****	                                                                    ****
****	Description:                                                        ****
****		This is the include file for the Rimfire 3200 driver.       ****
****		It defines the software interface to the board.  Included   ****
****		are the various structures used by the driver and the       ****
****		controller.                                                 ****
****	                                                                    ****
********************************************************************************
*******************************************************************************/

/*******************************************************************************
*									       *
*				Revision History			       *
*									       *
********************************************************************************

    Revision    Date		Author
	Description of Change
--------------------------------------------------------------------------------

   1.1		04/16/86	M. J. Tobias
	Initial Release

   1.2		03/16/87	R. A. Simning
	Add read track of id's
	Do a seek track command.

   1.3          04/10/87        M. E. Erickson
	Add read ahead across track
	and read ahead across cylinders

   1.4		09/25/87	J. E. Lind
	Added DEFECTDB to support read defect list from SMD drives.

   1.9		11/11/87	J. E. Lind
	a) Added the ESDI information to DEFECTDB.
	b) Extended capacity to 16 physical volumes from 4 and clean up the
	   documentation on the "unit" part of the minor device number as
	   it now corresponds to the Sun config way of doing things.
	g) Split DEFECTDB into DEFECTESDI and DEFECTSMD so that their union
	   could be more reasonably made in rfioctl.h (along with other
	   useful information for making an ioctl call).

    1.10	88/1/28 - 88/3/14	J. E. Lind
	d) Finished the Scatter/Gather list descriptor definition so that
	   we can abuse it for transfers which are not a multiple of
	   our sector size....  Also needed to fix the order of SGDESCRIPTOR.
	e) Added C_MSTART for ESDI motor start.
	k) Added TRUE and FALSE definitions if needed.
	l) Reduced the number of parameter blocks and status blocks per
	   controller to be more in keeping with the limitations of the DVMA
	   resource.

    1.11	88/4/27         J. D. Flatt
       No change

    1.12	88/5/31 -- 88/7/6	J. E. Lind
       b) Added flags for the operating system release level (SunOS3, SunOS4)

    1.13	88/7/27		J. E. Lind
       a) Added C_ISSUEESDI command for new rfslave routine.

    1.14	88/8/8		J. E. Lind
       a) No change.

    $Log:   I:\software\drivers\rf3200\sun\vcs\rfreg.h_v  $
   
      Rev 1.16   13 Feb 1989 11:47:02   JLind
   1.16:
     a) Increase the I/O control group representation to one per controller
        rather than one per driver.  This is really a bug fix for a bug
        left over from when the driver was first expanded to support
        multiple controllers.
        [rf.c,rfparam.h]
   
     b) Removed the GOPTWDL (Write Data Loaded) flags since the handling
        of Write Data Loaded had never been completely implemented.  This
        problem first showed up when the controllers began looking at
        this flag.
        [rf.c]
   
     c) Cleared the label magic number before reading the label to
        ensure that we don't get a false label display.
        [rf.c]
   
     d) Any sector containing an error according to the manufacturer's
        defect list is now considered bad.  Before, errors contained
        within the head scatter and gap3 were considered "harmless".
        [rfutil.c]
   
     e) Add the ability to examine the IDs of a track.  The track is reported
        as being map or bad, or the skew is shown, along with any "inter-
        esting" sectors.  The ioctl DKIOCTRAKID command (as used by compsec
        within rfutil) was renamed to DKIOCPHYSID to better reflect its
        function (returning the ID of a specified physical sector on a track),
        while DKIOCTRAKID returns the IDs of all sectors on a track. 
        DKIOCPHYSID is the same value as the old DKIOTRAKID for binary
        compatibility.  In the process, the interesting id FLAG, SECTOR,
        and ALT values were given meaningful names and moved to rfreg.h.
        XTCOFF and POSCOFF were moved from rfparam.h to rfreg.h.
        [rfutil.c,rfreg.h,rfparam.h,rfioctl.h,rf.c]
   
     f) The input routine (getcyltrack) which requests block numers or
        cylinder/head pairs now does so on one line, hopefully reducing
        user confusion.
        [rfutil.c]
   
     g) The map sector routine now asks whether you wish to map by track
        or sector.  Mapping by track helps out by figuring the track
        boundaries.
        [rfutil.c]
   
     h) A bug in ver_cyl incorrectly computed the block number from c/h/s,
        failing to verify the full disk.  The block numbers reported as
        failing really did fail and really were processed properly, but did
        not correspond to the c/h/s displayed.  Also, the variable "badhead"
        and the associated computations were discarded from the "ver_to"
        routines, since this information was already available.
        [rfutil.c]
   
     i) Slipping now accepts the block to slip either in c/h/s or as
        a block number through the use of a new routine, rdblkno.
        Rdblkno will accept input in either form if the label or
        geometry is available, but only as a block number if they are
        not.
        [rfutil.c]
   
     j) Corrected bzero(...,sizeof (EXTB)) to be bzero(...,sizeof(EXTPB)).
        [rf.c]
   
     k) Corrected comparison of unit number to be >= NRF instead of > NRF
        in several locations and moved assignment of the automatic variable
        device out of the declaration in rfdump() so that a bounds check is
        performed on unit.
        [rf.c]
   
      Rev 1.15   23 Nov 1988 13:11:00   JLind
           a) Corrected the indexing of rfcontroller_info to be by
   	   CONTROLLER number rather than DRIVE number (duh!),
   	   thereby fixing the dreaded dkinfo and newfs crashes.
   	   [rf.c]
   	b) Inserted debug flag tests on "not alive" messages.
   	   [rf.c]
   	c) Dual-port support.
   	   [rf.c,rfreg.h]
   	d) STANDALONE support for standalone rfutil.
   	   [rf.c, rfutil.c]
   	e) Changed default control group cache control to use full cacheing
   	   and sorting. [rfparam.h]
   	f) added safealloc and safefree (replacing rmalloc and rmfree,
   	   respectively) to make the driver insensitive to misalignment of
   	   the iopbmap resource, while also not causing it for anyone else.
   	   [rf.c]
    
   
   
   
   

*******************************************************************************/
#ifndef lint
static char	Sccsh2id[] = "@(#)rfreg.h  75182013 $Revision:   1.16  $ $Date:   13 Feb 1989 11:47:02  $ Copyright 1986, 1988 Ciprico, Inc.";
#endif


/*                       N O T E
 * You must define exactly one of the following system symbols.
 */

/*#define SunOS3	/* define for SunOS 3.2, 3.4, and 3.5 systems	*/
/*#define SunOS4	/* define for SunOS 4.0 systems			*/

#if !defined(SunOS3) && !defined(SunOS4)
	char c = OSLEVEL;
#endif

#if defined(SunOS3) && defined(SunOS4)
	char c = OSERROR;
#endif

#define	MOTOROLA			/* Use Motorola byte ordering */

#ifndef TRUE
# define	TRUE	(1)
# define	FALSE	(0)
#endif

#define	byte	unsigned char		/* 8 bit quantity */
#define	word	unsigned short		/* 16 bit quantity */
#define	dword	unsigned int		/* 32 bit quantity */

/* UNIX minor device number
 *
 *	The minor device number is interpretted as follows:
 *
 *	   7     6     5     4     3     2     1     0
 *	+-----+-----+-----+-----+-----+-----+-----+-----+
 *      |     |        Unit no.       |    Partition    |
 *	+-----+-----+-----+-----+-----+-----+-----+-----+
 *
 *	Unit number	Specifies physical disk (0-15)
 *	Partition	Specifies UNIX logical disk partition (0-7)
 *
 *	The unit number is used to index a table of mb_device
 *	structures built by config which describe the drive and
 *	drive options. (See md_flags discussion below.)
 *
 *	Unit numbers are assigned to drives and volumes by config.  The
 *	slave drive number and the flags are combined to form the internal unit
 *	number as follows:
 *
 *		Number		Unit
 *
 *		  1		SMD drive 0, main volume (fixed)
 *		  2		SMD drive 0, second volume (removable)
 *		  3		SMD drive 1, main volume (fixed)
 *		  4		SMD drive 1, second volume (removable)
 *
 *	Note:  Unit numbers issued to the controller are biased to start from
 *	       1. This allows commands not associated with a specific drive
 *	       and/or volume to use a unit number of 0.
 */

/* Macros to manipulate the minor device number */
#define UNIT(A)		((A) >> 3 & 0xf) /* unit number */
#define	PARTITION(A)	((A) & 7)	/* disk partition */

/* Hardware Ports
 *
 *	The Rimfire 3200 is seen as a 512 byte area in the 16 bit
 *	address space.  There are four registers in this space,
 *	each on an 8 byte boundary.  The registers are defined below.
 */
#ifdef MOTOROLA
# define	SWAB(x)	((x) & 0xffff)		/* no need to swap bytes */
#else
# define	SWAB(x)	(((((x) >> 8) & 0xff) | (((x) << 8) & 0xff00)))
#endif

/* support for Dual-port operation 1.15c */

/*#define ENABLE_DUAL_PORT	/* compile-in dual-port support code	*/

#ifndef ENABLE_DUAL_PORT
# define	VOL(flags_byte)	(flags_byte)
#else
# define	VOL(flags_byte)	((flags_byte)&3)
# define	MDF_DUALPORTED	(0x4)	/* this bit is set if the drive is used
						as dual-ported */
# define	MDF_RELEASE	(0x8)	/* this bit is set if the drive
						is being shared continuously */
#endif

/* Hardware ports */
typedef struct {
#ifdef MOTOROLA
	word	resv;		/* msb address */
#endif
	word	addrbuf;	/* Address Buffer Port (see below) */
	word	space1[3];
	word	attention;	/* Channel Attention Port */
	word	space2[3];
	word	status;		/* Board Status Port */
	word	space3[3];
	word	reset;		/* Controller Reset Port */
} RF32REG;

/* Address Buffer Port
 * 	Requires three writes in the order provided below:
 *
 *	15				0
 *	+---------------+---------------+
 *	|    Control    | AM bits for PB|
 *	+---------------+---------------+
 *	|     PB address:  16 MSB       |
 *	+-------------------------------+
 *	|     PB address:  16 LSB       |
 *	+-------------------------------+
 */

/* Control Field bit masks */
#define	CTRLSET	0x80		/* apply these controls this command */
#define	CTRLWID	0x04		/* width of data transfer, 0=16, 1=32 bit */
#define	CTRLWSW	0x02		/* word swap control, 0=no swap, 1=swap */
#define	CTRLBSW	0x01		/* byte swap control, 0=no swap, 1=swap */

/* Status Port bit masks */
#define	STATRST	0xfe		/* status of a board reset */
#define	STATBSY	0x01		/* status of the Address Buffer Port */
#define	STATRDY	0x02		/* board is ready */
#define	SRAMBAD	0x04		/* static RAM had an error */
#define	DRAMBAD	0x08		/* dynamic RAM had an error */
#define	RESETDONE STATRDY	/* reset has completed */
#define	STATCTYPE 0xFF00	/* Mask to grab controller type. */
#define	STATRF3200 0x0000	/* A Rimfire 3200 Controller */
#define	STATRF3400 0x0100	/* A Rimfire 3400 Controller */

/* Standard Parameter Block
 *
 *	+-----------------------------------------------+
 *	|                  Identifier                   |
 *	+-----------+-----------+-----------+-----------+
 *	| Addr Mod  |   Unit    |  Control  |  Command  |
 *	+-----------+-----------+-----------+-----------+
 *	|                 Disk Address                  |
 *	+-----------------------------------------------+
 *	|              VME Memory Address               |
 *	+-----------------------+-----------------------+
 *	|       Reserved        |      Block Count      |
 *	+-----------------------+-----------------------+
 */
typedef struct {
	dword	id;		/* unique command identifier */
#ifdef MOTOROLA
	byte	addrmod;	/* address modifier used to access VME memory */
	byte	unit;		/* unit for the command to apply */
	byte	control;	/* I/O control group */
	byte	command;	/* command to execute */
#else
	byte	command;	/* command to execute */
	byte	control;	/* I/O control group */
	byte	unit;		/* unit for the command to apply */
	byte	addrmod;	/* address modifier used to access VME memory */
#endif
	dword	diskaddr;	/* absolute starting sector number */
	dword	vmeaddr;	/* VME address to read from or write to */
#ifdef MOTOROLA
	word	reserved;	/* always zero */
	word	blkcount;	/* number of logical blocks to process */
#else
	word	blkcount;	/* number of logical blocks to process */
	word	reserved;	/* always zero */
#endif
} PARMBLK;

/* Command control bit masks */
#define	RF_IOCG		0x0f	/* I/O control group */
#define RF_INH		0x40	/* Inhibit command complete interrupt	*/
#define RF_RLS		0x80	/* Release drive on command complete 1.12a */

/* Status Block
 *
 *	+-----------------------+-----------+-----------+
 *	|                  Identifier                   |
 *	+-----------------------+-----------+-----------+
 *	|   Extra Information   |   Error   |  Status   |
 *	+-----------------------+-----------+-----------+
 *	|               Extra Information               |
 *	+-----------------------------------------------+
 */
typedef struct {
	dword	id;		/* command identifier generating status */
#ifdef MOTOROLA
	word	errextra;	/* extra error information */
	byte	errcode;	/* error, retry, or status which occured */
	byte	status;		/* type of status block and results */
#else
	byte	status;		/* type of status block and results */
	byte	errcode;	/* error, retry, or status which occured */
	word	errextra;	/* extra error information */
#endif
	dword	errdata;	/* error code specific data */
} STATBLK;

/* Status Block Status Field bit masks */
#define	ST_CC	0x80		/* Command complete, last status block */
#define	ST_ERR	0x40		/* Error, check error code */
#define	ST_RTY	0x20		/* Retry required */
#define	ST_COR	0x10		/* Correction required */

/* Extended Parameter Block
 *
 *	+-----------------------------------------------+
 *	|                                               |
 *	+--                                           --+
 *	|                                               |
 *	+--         Standard Parameter Block          --+
 *	|                                               |
 *	+--                                           --+
 *	|                                               |
 *	+--                                           --+
 *	|                                               |
 *	+-----------------------+-----------------------+
 *	|    Error Interrupt    |   No Error Interrupt  |
 *	+-----------------------+-----------------------+
 *	|               Reserved, MUST be 0             |
 *	+-----------------------------------------------+
 *	|                                               |
 *	+--                                           --+
 *	|                 Status Block                  |
 *	+--                                           --+
 *	|                                               |
 *	+-----------------------+-----------------------+
 */
typedef struct {
	PARMBLK pb;		/* standard parameter block */
#ifdef MOTOROLA
	word	errintr;	/* error interrupt */
	word	intr;		/* no error interrupt */
#else
	word	intr;		/* no error interrupt */
	word	errintr;	/* error interrupt */
#endif
	dword	resv;		/* reserved, must be 0 (zero) */
	STATBLK	sb;		/* status block */
} EXTPB;


/* Command list format
 *
 *	+-----------------------------------------------+
 *	|       Parameter block IN pointer              |
 *	+-----------------------------------------------+
 *	|       Parameter block OUT pointer             |
 *	+-----------------------------------------------+
 *	|         Status block IN pointer               |
 *	+-----------------------------------------------+
 *	|         Status block OUT pointer              |
 *	+-----------------------------------------------+
 *	|        Parameter block area size              |
 *	+-----------------------------------------------+
 *	|         Status block area size                |
 *	+-----------------------------------------------+
 *	|                 Reserved                      |
 *	+-----------------------------------------------+
 *	|                 Reserved                      |
 *	+-----------------------------------------------+
 *	|                                               |
 *	|                                               |
 *	|           Parameter block area                |
 *	|                                               |
 *	|                                               |
 *	+-----------------------------------------------+
 *	|                                               |
 *	|                                               |
 *	|             Status block area                 |
 *	|                                               |
 *	|                                               |
 *	+-----------------------------------------------+
 */

/* Almost every command will require a DVMA mapping, of which there are only
 * 31 total available, so there is no point in having many more than 31.  1.10l
 */
#define	RF32NPB	(0x20)		/* Max. number of parameter blocks */
#define	RF32NSB	(0x20)		/* Max. number of status blocks */

/* Masks for wrappping around IN/OUT pointers - do NOT define these if
 * the corresponding NxB value is not a power of 2.
 */
#define	NPBMASK	(RF32NPB-1)	/* mask for valid parameter block index */
#define	NSBMASK	(RF32NSB-1)	/* mask for valid status block index */

typedef struct {
	dword	pbin;		/* parameter block in pointer */
	dword	pbout;		/* parameter block out pointer */
	dword	sbin;		/* status block in pointer */
	dword	sbout;		/* status block out pointer */
	dword	pbsize;		/* paramter block area size */
	dword	sbsize;		/* status block area size */
	dword	resv1;
	dword	resv2;
	PARMBLK	pblist[RF32NPB];	/* parameter blocks */
	STATBLK	sblist[RF32NSB];	/* status blocks */
} CMDLIST;

/* RF 3200/3400 command definitions */
#define	C_SETUPCL	1	/* setup command list */
#define	C_STOPCL	2	/* stop command list */

#define	C_IDENTIFY	5	/* identify */
#define	C_STATS		6	/* board statistics */
#define	C_OPTION	7	/* general options */
#define	C_SETIOCG	8	/* init I/O control group */
#define	C_DIAGNOSTIC	9	/* board self-test command */

#define	C_SETCONFIG	16	/* configure disk */
#define	C_SETSMDPARAM	17	/* define SMD parameters */
#define	C_GETCONFIG	18	/* return drive configuration */
#define	C_INTERROGATE	19	/* 3200 Only - Interrogate disk */
#define	C_GETESDICONF	19	/* 3400 Only - Return ESDI config/status */
#define	C_TAGSTATUS	20	/* 3200 Only - Issue tag / return status */
#define	C_ISSUEESDI	21	/* 3400 Only - Issue ESDI serial command 1.13a*/

#define	C_READ		24	/* read */
#define	C_WRITE		25	/* write */
#define	C_SREAD		26	/* scatter read */
#define	C_GWRITE	27	/* gather write */

#define	C_FORMAT	32	/* format */
#define	C_VERIFY	33	/* verify */
#define	C_SLIPSECTOR	34	/* slip sector */
#define	C_MAPSECTOR	35	/* map sector */
#define	C_MAPTRACK	36	/* map track */
#define	C_READDEFECT	37	/* read defect data */

#define	C_IGNOREID	40	/* ignore id read data */
#define	C_READLONG	41	/* read long */
#define	C_WRITELONG	42	/* write long */
#define	C_READID	43	/* read a single id */
#define	C_READTID	44	/* read a track of id's */
#define	C_REZERO	45	/* rezero */
#define	C_SEEK		46	/* perform a seek */

#define C_MSTART	48	/* Motor Start (3400)	1.10e */

#define	C_WRITEMAP	56	/* write defect map table */
#define	C_READMAP	57	/* read defect map table */

/************************************************************************
 *	Command #1 - Setup Command List
 ************************************************************************/

/* Alternate Parameter Block - Setup command list */
typedef struct {
	dword	id;		/* unique command identifier */
#ifdef MOTOROLA
	byte	addrmod;	/* address modifier used to access VME memory */
	byte	unit;		/* unit (always 0) */
	byte	iocg;		/* I/O control group */
	byte	command;	/* command to execute */
	word	errintr;	/* error interrupt */
	word	doneintr;	/* done interrupt */
#else
	byte	command;	/* command to execute */
	byte	iocg;		/* I/O control group */
	byte	unit;		/* unit (always 0) */
	byte	addrmod;	/* address modifier used to access VME memory */
	word	doneintr;	/* done interrupt */
	word	errintr;	/* error interrupt */
#endif
	dword	start;		/* command list start address */
#ifdef MOTOROLA
	byte	resv[3];	/* reserved */
	byte	listno;		/* number of the command list (1-7) */
#else
	byte	listno;		/* number of the command list (1-7) */
	byte	resv[3];	/* reserved */
#endif
} SETUPPB;

/************************************************************************
 *	Command #2 - Stop Command List
 ************************************************************************/

/* Alternate Parameter Block - Stop command list */
typedef struct {
	dword	id;		/* unique command identifier */
#ifdef MOTOROLA
	byte	resv1;		/* reserved */
	byte	unit;		/* unit (always 0) */
	byte	iocg;		/* I/O control group */
	byte	command;	/* command to execute */
#else
	byte	command;	/* command to execute */
	byte	iocg;		/* I/O control group */
	byte	unit;		/* unit (always 0) */
	byte	resv1;		/* reserved */
#endif
	dword	resv2;		/* reserved */
#ifdef MOTOROLA
	byte	resv3[3];	/* reserved */
	byte	listno;		/* number of the command list (1-7) */
#else
	byte	listno;		/* number of the command list (1-7) */
	byte	resv3[3];	/* reserved */
#endif
	dword	resv4;		/* reserved */
} STOPPB;

/************************************************************************
 *	Command #5 - Identify
 ************************************************************************/

/* Alternate Status Block for Identify command */
typedef struct {
	dword	id;		/* identifier */
#ifdef MOTOROLA
	byte	fwrev;		/* firmware revision level */
	byte	engrev;		/* Engineering revision level */
	byte	error;		/* error code */
	byte	status;		/* status */
	byte	flags;		/* configuration of board (see below) */
	byte	day;		/* day the firmware was generated */
	byte	month;		/* month the firmware was generated */
	byte	year;		/* year the firmware was generated */
#else
	byte	status;		/* status */
	byte	error;		/* error code */
	byte	engrev;		/* Engineering revision level */
	byte	fwrev;		/* firmware revision level */
	byte	year;		/* year the firmware was generated */
	byte	month;		/* month the firmware was generated */
	byte	day;		/* day the firmware was generated */
	byte	flags;		/* configuration of board (see below) */
#endif
} RETID;

/* Flags byte in Identify Status Block */
#define IDNDRIV	0x01		/* set 	 = 4-drive 3200
				 * reset = 2-drive 3200 */
/************************************************************************
 *	Command #6 - Board Statistics
 ************************************************************************/

/* Alternate Parameter Block - Board Statistics */
typedef struct {
	dword	id;		/* unique command identifier */
#ifdef MOTOROLA
	byte	addrmod;	/* address modifier used to access VME memory */
	byte	unit;		/* unit for the command to apply */
	byte	control;	/* I/O control group */
	byte	command;	/* command to execute */
#else
	byte	command;	/* command to execute */
	byte	control;	/* I/O control group */
	byte	unit;		/* unit for the command to apply */
	byte	addrmod;	/* address modifier used to access VME memory */
#endif
	dword	spare;		/* unused */
	dword	vmeaddr;	/* where to put statistics data */
#ifdef MOTOROLA
	word	resv;		/* reserved */
	byte	resv1;		/* reserved */
	byte	clear;		/* clear statistics if non-zero */
#else
	byte	clear;		/* clear statistics if non-zero */
	byte	resv1;		/* reserved */
	word	resv;		/* reserved */
#endif
} STATPB;

/* Statistics Block - returned from Board statistics command */
typedef struct {
	dword	commands;	/* total number of commands */
	dword	reads;		/* number of disk reads */
	dword	diskrd;		/* sectors read from disk */
	dword	cacherd;	/* sectors read from cache */
	dword	writes;		/* number of disk writes */
	dword	diskwr;		/* sectors written to disk */
#ifdef MOTOROLA
	word	d1_seek;	/* smd 1: number of seek errors */
	word	d1_smdint;	/* smd 1: number of smd interface errors */
	word	d1_ecccor;	/* smd 1: number of ecc corrections */
	word	d1_nonecc;	/* smd 1: number of non-ecc data errors */
	word	d1_altseek;	/* smd 1: number of alternate seeks */
	word	d1_corfail;	/* smd 1: number of ecc correction failures */
	word	d2_seek;	/* smd 2: number of seek errors */
	word	d2_smdint;	/* smd 2: number of smd interface errors */
	word	d2_ecccor;	/* smd 2: number of ecc corrections */
	word	d2_nonecc;	/* smd 2: number of non-ecc data errors */
	word	d2_altseek;	/* smd 2: number of alternate seeks */
	word	d2_corfail;	/* smd 2: number of ecc correction failures */
	word	d3_seek;	/* smd 3: number of seek errors */
	word	d3_smdint;	/* smd 3: number of smd interface errors */
	word	d3_ecccor;	/* smd 3: number of ecc corrections */
	word	d3_nonecc;	/* smd 3: number of non-ecc data errors */
	word	d3_altseek;	/* smd 3: number of alternate seeks */
	word	d3_corfail;	/* smd 3: number of ecc correction failures */
	word	d4_seek;	/* smd 4: number of seek errors */
	word	d4_smdint;	/* smd 4: number of smd interface errors */
	word	d4_ecccor;	/* smd 4: number of ecc corrections */
	word	d4_nonecc;	/* smd 4: number of non-ecc data errors */
	word	d4_altseek;	/* smd 4: number of alternate seeks */
	word	d4_corfail;	/* smd 4: number of ecc correction failures */
#else
	word	d1_smdint;	/* smd 1: number of smd interface errors */
	word	d1_seek;	/* smd 1: number of seek errors */
	word	d1_nonecc;	/* smd 1: number of non-ecc data errors */
	word	d1_ecccor;	/* smd 1: number of ecc corrections */
	word	d1_corfail;	/* smd 1: number of ecc correction failures */
	word	d1_altseek;	/* smd 1: number of alternate seeks */
	word	d2_smdint;	/* smd 2: number of smd interface errors */
	word	d2_seek;	/* smd 2: number of seek errors */
	word	d2_nonecc;	/* smd 2: number of non-ecc data errors */
	word	d2_ecccor;	/* smd 2: number of ecc corrections */
	word	d2_corfail;	/* smd 2: number of ecc correction failures */
	word	d2_altseek;	/* smd 2: number of alternate seeks */
	word	d3_smdint;	/* smd 3: number of smd interface errors */
	word	d3_seek;	/* smd 3: number of seek errors */
	word	d3_nonecc;	/* smd 3: number of non-ecc data errors */
	word	d3_ecccor;	/* smd 3: number of ecc corrections */
	word	d3_corfail;	/* smd 3: number of ecc correction failures */
	word	d3_altseek;	/* smd 3: number of alternate seeks */
	word	d4_smdint;	/* smd 4: number of smd interface errors */
	word	d4_seek;	/* smd 4: number of seek errors */
	word	d4_nonecc;	/* smd 4: number of non-ecc data errors */
	word	d4_ecccor;	/* smd 4: number of ecc corrections */
	word	d4_corfail;	/* smd 4: number of ecc correction failures */
	word	d4_altseek;	/* smd 4: number of alternate seeks */
#endif
} BOARDST;

/* Tuning Statistics Block - Used by DKIOCGTUNE & DKIOCSTUNE Ioctl Command */
typedef	struct {
#ifdef	MOTOROLA
	u_short	sort_limit;
	u_char	ready_limit,
		combining;
	u_short	max_clist,
		max_cboard,
		max_pbxferlen,
		max_sbxferlen;
	u_long	board_empty;
	u_long	tot_req_sorted,
		tot_req_combined,
		hit_sort_limit,
		cnt_pbxfer,
		tot_pbxfer_size,
		nopb_ca,
		cnt_sbxfer,
		tot_sbxfer_size,
		norm_mem_xfer_cnt,
		corequest_mem_xfer_cnt;
	u_short	cache_exp_count,
		blk_alloc_fail,
		xfer_restart,
		cache_alloc_fail,
		disk_idle,
		xfer_idle,
		mtr_idle,
		disk_collision,
		max_pbxfersize,
		mtr_collision,
		max_sbxfersize,
		resv1,
		drv0_li,
		drv0_fdl,
		drv0_cg,
		drv0_sb,
		drv1_li,
		drv1_fdl,
		drv1_cg,
		drv1_sb,
		drv2_li,
		drv2_fdl,
		drv2_cg,
		drv2_sb,
		drv3_li,
		drv3_fdl,
		drv3_cg,
		drv3_sb;
#else	/* These have not been swapped yet: */
#endif
} TUNEST;

/************************************************************************
 *	Command #7 - General Options
 ************************************************************************/

/* Alternate Parameter Block - General Options command */
typedef struct {
	dword	id;		/* identifier */
#ifdef MOTOROLA
	byte	throttle;	/* bus throttle */
	byte	unit;		/* always zero */
	byte	control;	/* IO control group */
	byte	command;	/* command */
	word	sbintr;		/* status block interrupts (see below) */
	word	sbenable;	/* status block enables (see below) */
#else
	byte	command;	/* command */
	byte	control;	/* IO control group */
	byte	unit;		/* always zero */
	byte	throttle;	/* bus throttle */
	word	sbenable;	/* status block enables (see below) */
	word	sbintr;		/* status block interrupts (see below) */
#endif
	dword	resv[2];
} GOPTPB;

/* Status Block Enable and Interrupt Words */
#define	GOPTWDL	0x01		/* Return Write Data Loaded on writes */
#define	GOPTDTE	0x02		/* Return Retries and Corrections */
#define	GOPTIDE	0x04		/* Return ID/interface related errors */

/************************************************************************
 *	Command #8 - Initialize I/O Control Group
 ************************************************************************/

/* Alternate Parameter Block - Initialize I/O Control Group */
typedef struct {
	dword	id;		/* command identifier */
#ifdef MOTOROLA
	byte	resv1;		/* reserved */
	byte	unit;		/* unit (always 0) */
	byte	control;	/* I/O control group */
	byte	command;	/* command to execute */
	word	cache;		/* cache control (see below) */
	byte	readahead;	/* read ahead */
	byte	recovery;	/* recovery */
	word	resv2;		/* reserved */
	byte	dretry;		/* maximum data retries */
	byte	ndretry;	/* maximum non-data retries */
#else
	byte	command;	/* command to execute */
	byte	control;	/* I/O control group */
	byte	unit;		/* unit (always 0) */
	byte	resv1;		/* reserved */
	byte	recovery;	/* recovery */
	byte	readahead;	/* read ahead */
	word	cache;		/* cache control (see below) */
	byte	ndretry;	/* maximum non-data retries */
	byte	dretry;		/* maximum data retries */
	word	resv2;		/* reserved */
#endif
	dword	resv3;		/* reserved */
} IOCGPB;

/* Cache Control word */
/* Add these defines to the rfparam.h file in the I/O control groups 1-3
   if you want them active in your driver 
      15  14  13  12  11  10  9   8   7   6   5   4   3   2   1   0
    -----------------------------------------------------------------
    | 0 | 0 | 0 | 0 | 0 | 0 |RCC|RCT| 0 | 0 |SWT|SRD|CWT|RAP|CRD|SEA|
    -----------------------------------------------------------------   
*/

#define	COPTSEA	0x01		/* search cache */
#define	COPTCRD	0x02		/* save read data in cache */
#define	COPTRAP	0x04		/* read ahead priority */
#define	COPTCWT	0x08		/* save write data in cache */
#define	COPTSRD	0x10		/* sort reads */
#define	COPTSWT	0x20		/* sort writes */
#define COPTXHD 0x100           /* read ahead across head */   
#define COPTXCY 0x200           /* read ahead across cylinder */

/************************************************************************
 *	Command #16 - Configure Disk
 ************************************************************************/

/* Alternate Parameter Block - Configure disk */
typedef struct {
	dword	id;		/* identifier */
#ifdef MOTOROLA
	byte	resv1;		/* reserved */
	byte	unit;		/* unit for this command */
	byte	control;	/* I/O control group */
	byte	command;	/* command to execute */
	word	bytsec;		/* bytes per sector */
	word	cyldsk;		/* cylinders per disk */
	byte	nspares;	/* number of spare sectors per track */
	byte	sectrk;		/* sectors per track */
	byte	headcyl;	/* heads per cylinder */
	byte	basehead;	/* first physical head number this volume */
	byte	resv2[3];	/* reserved */
	byte	flags;		/* characteristics of drive (see below) */
#else
	byte	command;	/* command to execute */
	byte	control;	/* I/O control group */
	byte	unit;		/* unit for this command */
	byte	resv1;		/* reserved */
	word	cyldsk;		/* cylinders per disk */
	word	bytsec;		/* bytes per sector */
	byte	basehead;	/* first physical head number this volume */
	byte	headcyl;	/* heads per cylinder */
	byte	sectrk;		/* sectors per track */
	byte	nspares;	/* number of spare sectors per track */
	byte	flags;		/* characteristics of drive (see below) */
	byte	resv2[3];	/* reserved */
#endif
} CONFPB;

/* Flags field in Configure Disk command */
#define	CONFSSP	0x01		/* short sector present */
#define	CONFEAD	0x02		/* extended addressing, 0=use 11th cyl,
				 * 1=use SMD-E addressing */
#define	MASKCFF		(3)	/* all valid configuration flags	    */
#define	CONFEDP 0x04		/* Enable active Dual Port	1.12a	*/
#define CONFBSY 0x08		/* Look at dual port BuSY bit	1.12a	*/

/************************************************************************
 *	Command #17 - Define SMD Parameters
 ************************************************************************/

/* Alternate Parameter Block - Define SMD parameters */
typedef struct {
	dword	id;		/* identifier */
#ifdef MOTOROLA
	byte	resv1;		/* reserved */
	byte	unit;		/* unit for this command */
	byte	control;	/* I/O control group */
	byte	command;	/* command to execute */
	byte	interleave;	/* interleave factor to use */
	byte	headskew;	/* head skew to use */
	byte	cylskew;	/* cylinder skew to use */
	byte	hgskew;		/* 3400 Only - Head group skew */
	word	recovery;	/* data recovery (see below) */
	byte	idpre;		/* 3200 Only - ID preamble length */
	byte	datapre;	/* 3200 Only - data preamble length */
#else
	byte	command;	/* command to execute */
	byte	control;	/* I/O control group */
	byte	unit;		/* unit for this command */
	byte	resv1;		/* reserved */
	byte	hgskew;		/* 3400 Only - Head group skew */
	byte	cylskew;	/* cylinder skew to use */
	byte	headskew;	/* head skew to use */
	byte	interleave;	/* interleave factor to use */
	byte	datapre;	/* 3200 Only - data preamble length */
	byte	idpre;		/* 3200 Only - ID preamble length */
	word	recovery;	/* data recovery (see below) */
#endif
	dword	resv3;		/* reserved */
} DEFSMDPB;

/* Data Recovery for Define SMD parameters command */
#define	DSMDBUS	0x03ff		/* Data bus value */
#define	DSMDTAG	0xe000		/* tag number (1 to 6) */

/************************************************************************
 *	Command #18 - Return Drive Configuration
 ************************************************************************/

/* Structure for Return Configuration of an SMD drive */
typedef struct {
#ifdef MOTOROLA
	word	bytsec;		/* bytes per sector */
	word	cyldsk;		/* cylinders per disk */
	byte	nspares;	/* number of spare sectors per track */
	byte	sectrk;		/* sectors per track */
	byte	headcyl;	/* heads per cylinder */
	byte	basehead;	/* head offset for this volume */
	byte	zero1[3];	/* zeros */
	byte	flags;		/* as in configure */
#else
	word	cyldsk;		/* cylinders per disk */
	word	bytsec;		/* bytes per sector */
	byte	basehead;	/* head offset for this volume */
	byte	headcyl;	/* heads per cylinder */
	byte	sectrk;		/* sectors per track */
	byte	nspares;	/* number of spare sectors per track */
	byte	flags;		/* as in configure */
	byte	zero1[3];	/* zeros */
#endif
	dword	secdsk;		/* number of logical sectors per disk */
#ifdef MOTOROLA
	byte	interleave;	/* interleave factor */
	byte	headskew;	/* head skew factor */
	byte	cylskew;	/* cylinder skew factor */
	byte	hgskew;		/* 3400 Only - Head group skew */
	word	recovery;	/* data recovery */
	byte	idpre;		/* 3200 Only - id preamble length */
	byte	datapre;	/* 3200 Only - data preamble length */
#else
	byte	hgskew;		/* 3400 Only - Head group skew */
	byte	cylskew;	/* cylinder skew factor */
	byte	headskew;	/* head skew factor */
	byte	interleave;	/* interleave factor */
	byte	datapre;	/* 3200 Only - data preamble length */
	byte	idpre;		/* 3200 Only - id preamble length */
	word	recovery;	/* data recovery */
#endif
	dword	zero3;		/* zero */
	dword	zero4;		/* zero */
} RETCONF;
/************************************************************************
*	Command # 44 - read track of id's
************************************************************************/


typedef struct  {
#ifdef MOTOROLA
	word    cyl;
	byte    sec;
        byte	head;
	byte	alt;
	byte	flag;
#else
	byte	sec;
	byte	head;
	word	cyl;
	byte	flag;
	byte 	alt;
#endif
}TRAKID;
/*********** Structure defect map is not currently used.    ****************/

typedef struct {
	word terr;
	word ter;
	word;
	word;
	word;
	word;
	word;
	word;
	word;
	word;
	word;
	word;
	word;
	}DEFECTMAP;

/************************************************************************
*      Command # 46 - Seek to a specific head/cyclinder
*************************************************************************/
typedef struct {
#ifdef MOTOROLA
	word cyl;
	byte head;
	byte sec;
#else
	byte sec;
	byte head;
	word cyl;
#endif
}LOOK;

/************************************************************************
 *	Command #19 - Return ESDI Drive Configuration (ESDI only)
 ************************************************************************/

/* Structure for Return Configuration of an ESDI drive */
typedef struct {
	word	genconf;	/* general configuration */
	word 	fixcyl; 	/* number of fixed cylinders */
	word 	remcyl;		/* number of removable cylinders */
#ifdef MOTOROLA
	byte	remhead;	/* number of removable heads */
	byte	fixhead;	/* number of fixed heads */
	word	minbytrk;	/* minimum unformatted bytes per track */
	word	bytesec;	/* unformatted bytes per sector */
	byte	resv0;		/* reserved */
	byte	sectrk;		/* sectors per track */
	byte	isgbyte;	/* isg bytes after index */
	byte 	minisg;		/* minimum isg bytes */
	byte	spare;		/* spare */
	byte	plosync;	/* bytes in plo sync */
	word	nwords;		/* number of words of vendor-unique status */
	word	resv[5];	/* reserved */
	byte	vendid;		/* vendor id */
	byte	vendmodel;	/* vendor model */
#else
	byte	fixhead;	/* number of fixed heads */
	byte	remhead;	/* number of removable heads */
	word	minbytrk;	/* minimum unformatted bytes per track */
	word	bytesec;	/* unformatted bytes per sector */
	byte	sectrk;		/* sectors per track */
	byte	resv0;		/* reserved */
	byte 	minisg;		/* minimum isg bytes */
	byte	isgbyte;	/* isg bytes after index */
	byte	plosync;	/* bytes in plo sync */
	byte	spare;		/* spare */
	word	nwords;		/* number of words of vendor-unique status */
	word	resv[5];	/* reserved */
	byte	vendmodel;	/* vendor model */
	byte	vendid;		/* vendor id */
#endif
	word	statbits;	/* general drive status bits */
	word	resv1;		/* reserved */
} ESDIPARAMS;

/*
 * Definitions for General Configuration Word
 */
#define GC_TAPE		0x8000	/* Tape drive				*/
#define GC_TOLGAP	0x4000	/* Format speed tolerance gap required	*/
#define GC_TRKOFF	0x2000	/* Track offset option available	*/
#define GC_DATAOFF	0x1000	/* Data strobe offset option available	*/
#define GC_SPEEDTOL	0x0800	/* Rotational speed tolerance > 0.5%	*/
#define GC_XFER10	0x0400	/* Transfer rate > 10MHz		*/
#define GC_XFER510	0x0200	/* Transfer rate > 5MHz, <= 10MHz	*/
#define GC_XFER5	0x0100	/* Transfer rate <= 5MHz		*/
#define GC_REMOV	0x0080	/* Removable cartridge drive		*/
#define GC_FIXED	0x0040	/* Fixed drive				*/
#define GC_MOTORCTL	0x0020	/* Spindle motor control option implmn. */
#define GC_HDSWLONG	0x0010	/* Head switch time > 15 uS		*/
#define GC_RLL		0x0008	/* RLL encoded (not MFM)		*/
#define GC_CTLSOFT	0x0004	/* Controller soft-sectored (ADR mark)	*/
#define GC_DRVHARD	0x0002	/* Drive hard-sectored (Sector pulse)	*/
#define GC_CTLHARD	0x0001	/* Controller hard-sectored (Byte clock)*/

/*
 * Definitions for General drive status bits above
 */
/*			0x8000		Not used			*/
#define DS_NOREMOV	0x4000	/* Removable media not present		*/
#define DS_WPREM	0x2000	/* Write protected, removable media	*/
#define DS_WPFIX	0x1000	/* Write protected, fixed media		*/
/*			0x0800		Not used			*/
/*			0x0400		Not used			*/
#define DS_SPINDWN	0x0200	/* Spindle motor stopped		*/
#define DS_POR		0x0100	/* Power on reset conditions exist	*/
#define DS_CMDPARITY	0x0080	/* Command data parity fault		*/
#define DS_INTFLT	0x0040	/* Interface fault			*/
#define DS_INVCMD	0x0020	/* Invalid or unimplemented cmd fault	*/
#define DS_SEEKFLT	0x0010	/* Seek fault				*/
#define DS_TOFLT	0x0008	/* Write gate with track offset fault	*/
#define DS_STATAVAIL	0x0004	/* Vendor-unique status available	*/
#define DS_WRTFLT	0x0002	/* Write fault				*/
#define DS_MEDIACHG	0x0001	/* Removable media changed		*/



/************************************************************************
 *	Command #19 - Interrogate Drive (SMD only)
 ************************************************************************/

/* Structure for Return Characteristics of a SMD drive */
typedef struct {
	word resv0;		/* reserved, always 0	*/
	word cyld;		/* cylinders/disk	*/
	byte nspare;		/* number of spares	*/
	byte dsctrk;		/* data sectors/track	*/
	byte nhead;		/* number of heads	*/
	byte resv1;		/* reserved, always 0	*/
	word resv2;		/* reserved, always 0	*/
	byte psctrk;		/* physical sectors/track */
	byte flags;		/* only SSP right now	*/
} SMDCHRS;



/************************************************************************
 *	Command #20 - Issue Tag / Return Status
 ************************************************************************/

/* Alternate Parameter Block for Issue Tag / Return Status command */
typedef struct {
	dword	id;		/* identifier */
#ifdef MOTOROLA
	byte	resv1;		/* reserved */
	byte	unit;		/* unit */
	byte	control;	/* IO Control Group */
	byte	command;	/* command number */
	word	resv2;		/* reserved */
	word	data;		/* data to send */
	word	resv3;		/* reserved */
	word	tag;		/* tag number */
#else
	byte	command;	/* command number */
	byte	control;	/* IO Control Group */
	byte	unit;		/* unit */
	byte	resv1;		/* reserved */
	word	data;		/* data to send */
	word	resv2;		/* reserved */
	word	tag;		/* tag number */
	word	resv3;		/* reserved */
#endif
	dword	resv4;		/* reserved */
} TAGPB;

/* Issue Tag Status Block */
typedef struct {
	dword	id;		/* identifier */
#ifdef MOTOROLA
	word	zero1;		/* zero */
	byte	error;		/* error code */
	byte	status;		/* status */
	byte	zero2[3];	/* zeros */
	byte	data;		/* drive data */
#else
	byte	status;		/* status */
	byte	error;		/* error code */
	word	zero1;		/* zero */
	byte	data;		/* drive data */
	byte	zero2[3];	/* zeros */
#endif
} TAGSB;

/************************************************************************
 *	Command #26 and #27 - Scatter Read and Gather Write   1.10d
 ************************************************************************/

/* Structure for the scatter/gather descriptor entry */
typedef struct {
	dword	bytes;		/* byte count */
	dword	sdptr;		/* source/destination pointer */
} SGDESCRIPTOR;

typedef struct {
	dword 		next;		/* pointer to the next SGHEADER	*/
	SGDESCRIPTOR	desc[8];	/* 8 memory chunk description/header */
} SGHEADER;

#define sglistsize	blkcount	/* number of sg pairs in list */

/************************************************************************
 *	Command #32 and #33 - Format and Verify
 ************************************************************************/

/* Alternate Parameter Block - format and verify */
typedef struct {
	dword	id;		/* unique command identifier */
#ifdef MOTOROLA
	byte	addrmod;	/* address modifier used to access VME memory */
	byte	unit;		/* unit for the command to apply */
	byte	control;	/* I/O control group */
	byte	command;	/* command to execute */
#else
	byte	command;	/* command to execute */
	byte	control;	/* I/O control group */
	byte	unit;		/* unit for the command to apply */
	byte	addrmod;	/* address modifier used to access VME memory */
#endif
	dword	diskaddr;	/* absolute starting sector number */
	dword	vmeaddr;	/* VME address to read from or write to */
	dword	blkcount;	/* number of logical blocks to process */
} FMTVERPB;

/************************************************************************
 *	Command #34, #35, and #36 - Slip Sector, Map Track, and Map Sector
 ************************************************************************/

/* Alternate Parameter Block - map and slip */
typedef struct {
	dword	id;		/* unique command identifier */
#ifdef MOTOROLA
	byte	resv1;		/* reserved */
	byte	unit;		/* unit for the command to apply */
	byte	control;	/* I/O control group */
	byte	command;	/* command to execute */
#else
	byte	command;	/* command to execute */
	byte	control;	/* I/O control group */
	byte	unit;		/* unit for the command to apply */
	byte	resv1;		/* reserved */
#endif
	dword	baditem;	/* bad sector or track (first sector) */
	dword	alternate;	/* alternate track or sector */
#ifdef MOTOROLA
	word	resv2;		/* reserved */
	word	recover;	/* recover data in error? */
#else
	word	recover;	/* recover data in error? */
	word	resv2;		/* reserved */
#endif
} MAPPB;
/************************************************************************
 *	Command #37 - Read Defect Data
 ************************************************************************/

/* SMD disk defect structure */
typedef struct {
#ifdef MOTOROLA
	byte	zero1;		/* zero */
	byte	x19;		/* Constant (0x19) */
	word	cylinder;	/* cylinder number */
	byte	head;		/* head number */
	byte	zero2;		/* zero */
	word	pos1;		/* position 1 */
	word	len1;		/* length 1 */
	word	pos2;		/* position 2 */
	word	len2;		/* length 2 */
	word	pos3;		/* position 3 */
	word	len3;		/* length 3 */
	word	pos4;		/* position 4 */
	word	len4;		/* length 4 */
	byte	zero3;		/* zero */
	byte	xf0;		/* Constant (0xf0) */
#else
	byte	x19;		/* Constant (0x19) */
	byte	zero1;		/* zero */
	word	cylinder;	/* cylinder number */
	byte	zero2;		/* zero */
	byte	head;		/* head number */
	word	pos1;		/* position 1 */
	word	len1;		/* length 1 */
	word	pos2;		/* position 2 */
	word	len2;		/* length 2 */
	word	pos3;		/* position 3 */
	word	len3;		/* length 3 */
	word	pos4;		/* position 4 */
	word	len4;		/* length 4 */
	byte	xf0;		/* Constant (0xf0) */
	byte	zero3;		/* zero */
#endif
} DEFECTSMD;

/* ESDI disk defect structure */
/* The ESDI spec calls for the eventual maximum size of 2048 byte defect
 * list (408 defects).  This is too large to use the permanently mapped
 * memory in the Sun architecture.  Since all manfucturers to date are
 * using the 256 byte size, we will put in a maximum of 512 bytes (101
 * defects) for now, and add more sophisticated techniques of memory use
 * in the future, if required */

#define DSZ256	(50)
#define DSZ512	(101)
#define DSZ1024	(203)
#define DSZ2048 (408)

typedef struct {
	struct {
		byte	cylhigh;	/* header cylinder high	*/
		byte	cyllow;		/* header cylinder low	*/
		byte	head;		/* header head		*/
		byte	sector;		/* header sector (0)	*/
		byte	flag;		/* phys. length of list flag */
		byte	crc1;		/* first CRC byte	*/
		byte	z0;		/* always zero (0)	*/
		byte	z1;		/* always zero (0)	*/
		} header;
	struct {
		byte	month;		/* list date		*/
		byte	day;		/* list day		*/
		byte	year;		/* list year		*/
		byte	head;		/* list head (better equal
							head)	*/
		byte	z0;		/* always zero (0)	*/
		byte	z1;		/* always zero (0)	*/
		byte	dl[5*DSZ512];	/* data list 
					 * (5 byte structures!)
					 * cyl high, cyl low,
					 * offset high offset low,
					 * length */
		byte crc0;		/* fist CRC byte	*/
		byte crc1;		/* second CRC byte	*/
		} data;
} DEFECTESDI;


/* maximum size for writing */
#define	MAX_RF_BSIZE	1024*63  /* maximum block size is 63K */
 
/* number of spares for sector slipping */
/* Define this if there is the element dkl_apc in your disk label structure. */
#define NSPARES		/* Label contains # of spare sectors per cylinder */

			/* On SunOS 3.2, this IS in disk label. */
/* This is the number of spares PER CYLINDER! */

/* Alternate Parameter Block - Initialize I/O Control Group */
struct iocgrp {
	word    group;		/* I/O control group */
	word	cache;		/* cache control (see below) */
	byte	readahead;	/* read ahead */
	byte	recovery;	/* recovery */
	byte	dretry;		/* maximum data retries */
	byte	ndretry;	/* maximum non-data retries */
	word	resv;		/* reserved */
};
/* Maximum # of IO Control Group used - This means we use groups 1-3 */
#define	MAXIOCG	3

#ifdef	RFSTATS
/* For gathering statistics: */
typedef struct {
	struct timeval	iorq_time;
	u_long	iorq_bn;
	u_char	iorq_rq;
	u_char	iorq_ns;
	u_char	iorq_type;
} IORQ_STAT;
/* Types: */
#define	IORQ_START	0x1
#define	IORQ_FINISH	0x2

typedef struct {
	long	which;
	IORQ_STAT iorq;
} IORQS;

typedef struct {
	long	niorq;
	IORQ_STAT	iorqs[512 * 20];
} IORQ;
#endif

#define	XTCFF	(1)	/* byte in "extra" field of geometry information) */
#define	POSCFF	(127)	/* byte position in dkl_asciilabel of conf flags  */

#define	FLG_NRM	(0xaa)
#define	FLG_DEF	(0x3c)
#define FLG_ALT	(0xc3)
#define FLG_BAD	(0x33)
#define FLG_DSC (0x5a)
#define FLG_ASC	(0xa5)
#define FLG_BSC	(0x35)

#define	SEC_SLP	(0xff)
#define	SEC_SHR	(0xfd)
#define	SEC_SPR	(0xfe)
