/*	@(#)if_levar.h	1.13	*/

/*
 * Copyright (c) 1989 by Sun Microsystems, Inc.
 */

#ifndef _sunif_if_levar_h
#define _sunif_if_levar_h

/*
 * Definitions for data structures that the
 * AMD 7990 LANCE driver uses internally.
 *
 * This file exists primarily to allow network monitoring
 * programs easy access to the definition of le_softc.
 */

/*
 * Transmit and receive buffer layout.
 *	The chip sees only the fields from lb_ehdr onwards; the
 *	preceding fields are for the driver's benefit. The e_to_lb
 *	and b_to_lb macros defined below convert the address of the
 *	start of a lb_ehdr or lb_buffer field to the address of the
 *	start of the containing le_buf structure.
 *
 *	The buffer size is chosen to give room for the maximum ether
 *	transmission unit, an overrun consisting of the entire fifo
 *	contents, and slop that experience indicates is necessary.
 *	(The exact amount of slop required is still unknown.)
 */
struct le_buf {
	/* Fields used only by driver: */
	struct le_buf	*lb_next;		/* Link to next buffer */
	struct le_softc	*lb_es;			/* Link back to sw status */
	short	lb_loaned;				/* Align buffer on long boundary */
	/* Fields seen by LANCE chip: */
	struct ether_header	lb_ehdr;	/* Packet's ether header */
	u_char		lb_buffer[MAXBUF];	/* Packet's data */
};

/*
 * Given a pointer to the ethernet frame,
 * return a pointer to the containing le_buf.
 * N.B.: This assumes that the compiler inserts no padding
 * between the fields of the le_buf structure.  (If it did, we'd be
 * in trouble on other grounds as well.)
 */
#define e_to_lb(e) \
	(struct le_buf *)((caddr_t)(e) - sizeof (short) - sizeof (struct le_softc *) \
			- sizeof (struct le_buf *))


/*
 * Ethernet software status per interface.
 *
 * Each interface is referenced by a network interface structure,
 * es_if, which the routing code uses to locate the interface.
 * This structure contains the output queue for the interface, its address, ...
 * "es" indicates Ethernet Software status.
 */
struct	le_softc {
	struct	arpcom es_ac;		/* common ethernet structures */
#define	es_if		es_ac.ac_if	/* network-visible interface */
#define	es_enaddr	es_ac.ac_enaddr	/* hardware ethernet address */
#define	es_mcaddr	es_ac.ac_mcaddr	/* multicast address vector */
#define	es_nmcaddr	es_ac.ac_nmcaddr
					/* count of multicast addrs */

	struct	le_init_block *es_ib;	/* Initialization block */

	/* LANCE message descriptor info */
	struct	le_md *es_rdrp;		/* Receive Descriptor Ring Ptr */
	struct	le_md *es_rdrend;	/* Receive Descriptor Ring End */
	int	es_nrmdp2;		/* log(2) Num. Rcv. Msg. Descs. */
	int	es_nrmds;		/* Num. Rcv. Msg. Descs. */
	struct	le_md *es_tdrp;		/* Transmit Descriptor Ring Ptr */
	struct	le_md *es_tdrend;	/* Receive Descriptor Ring End */
	int	es_ntmdp2;		/* log(2) Num. Tran. Msg. Descs. */
	int	es_ntmds;		/* Num. Xmit. Msg. Descs. */
	struct	le_md *es_his_rmd;	/* Next descriptor in ring */
	struct	le_md *es_cur_tmd;	/* Tmd for start of current xmit request */
	struct	le_md *es_nxt_tmd;	/* Tmd for start of next xmit request */

	/* Buffer info */
	struct	le_buf *es_rbufs;	/* Receive Buffers */
	int	es_nrbufs;		/* Number of Receive Buffers */
	u_char	*es_tbuf;		/* Single Transmit Buffer */
	struct	le_buf *es_rbuf_free;	/* Head of free list */
	struct	mbuf **es_tmbufc;	/* mbuf chain heads for xmit packets */

	u_int	es_flags;		/* State info: see below */

	/* Error counters */
	int	es_extrabyte;		/* Rev C,D LANCE extra byte problem */
	int	es_fram;		/* Receive Framing Errors (dribble) */
	int	es_crc;			/* Receive CRC Errors */
	int	es_oflo;		/* Receive overruns */
	int	es_uflo;		/* Transmit underruns */
	int	es_retries;		/* Transmit packets w/at least one retry (collision) */
	int	es_missed;		/* Number of missed packets */
	int	es_noheartbeat;		/* Number of nonexistent heartbeats */
	int	es_tBUFF;		/* BUFF bit in tmd occurrences */
	int	es_tlcol;		/* Transmit late collisions */
	int	es_trtry;		/* Transmit retry errors (failed after 16 retries) */
	int	es_tnocar;		/* No carrier errors */
	int	es_dogreset;		/* Number of ledog() chip resets */

	/* Performance statistics counters */
	int	es_started;		/* Times through lestart with > 0
					   packets ready to go out */
	int	es_no_tmds;		/* Number of output packets dropped
					   due to unavailability of tmd's */
	int	es_tsync;		/* Times we lost xmit sync with chip */
	int	es_defer;		/* Deferred transmission counter */
	int	es_outcpy;		/* Output copy operations */
	int	es_incpy;		/* Input copy operations */
};

/*
 * Bit definitions for es_flags field:
 */
#define LE_TBUSY	0x01	/* Single static xmit buffer in use */
#define LE_TOPENDING	0x02	/* Transmit timeout pending */
#define	LE_NEEDTMD	0x04	/* Output waiting for tmd to free up */

#ifdef	OPENPROMS

/*
 * This structure for OPENPROM machines which have no mb structures
 */

struct le_info {
	struct le_device	*le_addr;	/* mapped in chip register */
	struct dev_info		*le_dev;	/* backpointer to dev_info */
};

#define	LE_ADDR(unit)	leinfo[(unit)].le_addr
#define	LE_ALIVE(unit)	\
	(leinfo[unit].le_dev && leinfo[unit].le_dev->devi_driver)

#else

#define	LE_ADDR(unit)	(struct le_device *)leinfo[(unit)]->md_addr
#define	LE_ALIVE(unit)	(leinfo[unit] && leinfo[unit]->md_alive)

#endif
#ifdef KERNEL
/*
 * Variables imported from le_conf.c
 */
extern struct le_softc	*le_softc;
#ifdef	OPENPROMS
extern struct le_info *leinfo;
#else
extern struct mb_device *leinfo[];
#endif
extern int le_units;
extern int le_high_ntmdp2, le_high_nrmdp2, le_high_nrbufs;
extern int le_low_ntmdp2, le_low_nrmdp2, le_low_nrbufs;
#endif

#endif /*!_sunif_if_levar_h*/
