/*	@(#)mount.h 2.14 89/08/23 SMI; from UCB 4.4 82/07/19	*/

#ifndef _ufs_mount_h
#define	_ufs_mount_h

/*
 * Mount structure.
 * One allocated on every ufs mount.
 * Used to find the super block.
 */
struct	mount {
	struct mount	*m_nxt;		/* linked list of all mounts */
	struct vfs	*m_vfsp;	/* vfs structure for this filesystem */
	struct vnode	*m_devvp;	/* vnode for block device mounted */
	struct buf	*m_bufp;	/* pointer to superblock */
	dev_t		m_dev;		/* device mounted */
	u_short		m_qflags;	/* QUOTA: filesystem flags */
	struct inode	*m_qinod;	/* QUOTA: pointer to quota file */
	u_long		m_btimelimit;	/* QUOTA: block time limit */
	u_long		m_ftimelimit;	/* QUOTA: file time limit */
};

#ifdef KERNEL
/*
 * Convert vfs ptr to mount ptr.
 */
#define	VFSTOM(VFSP)	((struct mount *)((VFSP)->vfs_data))

/*
 * mount table
 */
extern struct mount	*mounttab;

/*
 * Lock and unlock mounttab.
 */
extern int	mounttab_flags;
#define	MLOCKED	0x00000001
#define	MWANT	0x00000002

#ifdef MOUNTLOCK_DEBUG
#define	MOUNTFLAGS_BITS "\020\2MWANT\1MLOCKED"
int	mounttab_owner, mounttab_wanter, mounttab_counter;
#define	MLOCK() { \
	while ((mounttab_flags & MLOCKED)) { \
		mounttab_flags |= MWANT; \
		mounttab_wanter = u.u_procp->p_pid; \
		mounttab_counter++; \
		mounttab_debug(MWANT); \
		(void) sleep((caddr_t)mounttab, PINOD); \
		mounttab_counter--; \
	} \
	mounttab_owner = u.u_procp->p_pid; \
	mounttab_flags |= MLOCKED; \
	mounttab_debug(MLOCKED); \
}

#define	MUNLOCKED	0x0
#define	MUNLOCK() { \
	mounttab_debug(MUNLOCKED); \
	mounttab_flags &= ~MLOCKED; \
	if (mounttab_flags & MWANT) { \
		mounttab_flags &= ~MWANT; \
		wakeup((caddr_t)mounttab); \
	} \
}
#else
#define	MLOCK() { \
	while ((mounttab_flags & MLOCKED)) { \
		mounttab_flags |= MWANT; \
		(void) sleep((caddr_t)mounttab, PINOD); \
	} \
	mounttab_flags |= MLOCKED; \
}
#define	MUNLOCK() { \
	mounttab_flags &= ~MLOCKED; \
	if (mounttab_flags & MWANT) { \
		mounttab_flags &= ~MWANT; \
		wakeup((caddr_t)mounttab); \
	} \
}
#endif

/*
 * Operations
 */
struct mount *getmp();
#endif

#endif /*!_ufs_mount_h*/
