(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: Attributes.d,v 0.3 1993/10/03 14:55:22 borchert Exp $
   ----------------------------------------------------------------------------
   $Log: Attributes.d,v $
   Revision 0.3  1993/10/03  14:55:22  borchert
   component rlabel added to Attribute

   Revision 0.2  1993/06/16  09:44:28  borchert
   int16AT added to ArithmeticType for SYSTEM.INT16
   global added for PIC

   Revision 0.1  1992/07/30  10:46:05  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

DEFINITION MODULE Attributes; (* AFB 2/89 *)

   (* data structures of the code generator *)

   FROM Lex IMPORT Constval, Symbol;
   FROM SymTab IMPORT Size, Type, Ident, ParamList, FieldList;

   TYPE
      Reg = (d0, d1, d2, d3, d4, d5, d6, d7,
	     a0, a1, a2, a3, a4, a5, a6, a7,
	     illegal, pc, ccr,
	     (* MC68881 *)
	     fp0, fp1, fp2, fp3, fp4, fp5, fp6, fp7,
	     fpcr, fpsr);
      RegSet = SET OF Reg;
   CONST
      base = a6;
      top = a7;
      global = a5; (* needed for position-independent code only *)
   TYPE
      ArithmeticType = (shortAT, int16AT, intAT, longAT, floatAT, longfloatAT,
			bitAT, logAT);
      TestType = (lt, le, eq, ne, ge, gt);
      Label =
	 RECORD
	    ok: BOOLEAN;		(* valid label? *)
	    head: CHAR;			(* leading letter *)
	    n1, n2: CARDINAL;		(* unique numbers *)
	 END;

   TYPE
      Attribute = POINTER TO AttrRec;
      AtMode = (moduleAt, constAt, typeAt, varAt, procAt,
		refAt, selectAt, indexAt, guardAt,
		binaryAt, unaryAt, callAt,
                regMode, addrMode, indexMode, memIndexMode, condMode,
		floatRegMode);
      AtModeSet = SET OF AtMode;
      AttrRec =
	 RECORD
	    link: Attribute; (* parameter list *)
	    CASE mode: AtMode OF
	    | moduleAt:
	    ELSE
	       attype: Type;
	    END;
	    CASE (* mode *) : AtMode OF
	    | callAt:               firstparam,
				    tail: Attribute; (* of parameter list *)
			            paramcnt: CARDINAL; (* number of params *)
				    paramref: ParamList; (* -> next parameter *)
				    procat: Attribute;
				    toomany: BOOLEAN; (* error printed *)
	    | refAt, selectAt, indexAt, guardAt:
				    desat: Attribute; (* designator *)
				    CASE (* mode *) : AtMode OF
				    | indexAt:  indexat: Attribute;
				    | selectAt: field: FieldList;
				    END;
	    | unaryAt, binaryAt:    opsy: Symbol;
				    rightop: Attribute;
				    CASE (* mode *) : AtMode OF
				    | binaryAt: leftop: Attribute;
				    END;
	    | regMode, addrMode, indexMode, memIndexMode, floatRegMode:
				    reg: Reg;
				    CASE (* mode *) : AtMode OF
				    | regMode:  extended: BOOLEAN;
				    | indexMode, memIndexMode, addrMode:
					  tagged: BOOLEAN;
					  CASE (* mode *) : AtMode OF
					  | indexMode, memIndexMode:
						(* only one of the labels
						   may be given
						*)
						labelip: Ident;
						rlabel: Label;
						addr: Size;
						xreg: Reg;
						scale: CARDINAL;
						tmp: BOOLEAN; (* on stack *)
						CASE (* mode *) : AtMode OF
						| memIndexMode:   post: BOOLEAN;
								  od: Size;
						END;
					  END;
				    END;
	    | condMode:             test: TestType;
				    atype: ArithmeticType;
				    tlabel: Label; (* branch on TRUE *)
				    flabel: Label; (* branch on FALSE *)
	    ELSE
	       atip: Ident;
	       CASE (* mode *) : AtMode OF
	       | constAt:  cval: Constval;
	       END;
	    END;
	 END;

   CONST
      IdModes = AtModeSet{moduleAt..procAt}; (* attributes with atip-field *)
      DesignatorModes = AtModeSet{varAt, indexAt, selectAt, refAt, guardAt};
      GenModes = AtModeSet{regMode, addrMode, indexMode, memIndexMode,
			   floatRegMode, condMode};
      OpModes = AtModeSet{binaryAt, unaryAt, callAt, constAt, procAt} +
		DesignatorModes + GenModes;  (* attributes with attype-field *)

   TYPE
      CaseLabel = INTEGER;
      Labels = POINTER TO LabelsRec;
      LabelList = POINTER TO LabelRec;
      LabelsRec =
	 RECORD
	    min, max: CaseLabel;
	    count: CARDINAL; (* number of cases *)
	    ltype: Type; (* type of labels *)
	    head, tail: LabelList;
	 END;
      LabelRec =
	 RECORD
	    low, high: CaseLabel;
	    case: CARDINAL; (* each case has a unique number *)
	    link: LabelList;
	 END;

   VAR (* set by CodeGen *)
      procedureAt: Attribute; (* set by `ProcedureBegin' *)
      badprocedure: BOOLEAN; (* current procedureAt is not valid *)

   VAR (* set by GenBlocks *)
      returnLabel: Label; (* jump to this label on return *)

   PROCEDURE GetLabel(VAR l: Label);
      (* get label with unique `n1'; head = 0C and n2 = 0 *)

   PROCEDURE NewAttribute(VAR at: Attribute);
      (* NEW(at) *)

   PROCEDURE DisposeAttribute(VAR at: Attribute);
      (* DISPOSE(at); at := NIL; *)

   PROCEDURE NoAttributes;
      (* to be called if no Attribute-record is allocated/used *)

END Attributes.
