(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: ConstExpr.d,v 0.1 1992/07/30 10:46:13 borchert Exp $
   ----------------------------------------------------------------------------
   $Log: ConstExpr.d,v $
   Revision 0.1  1992/07/30  10:46:13  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

DEFINITION MODULE ConstExpr; (* AFB 1/89 *)

   (* evaluation of operations with constants *)

   FROM Lex IMPORT Symbol, Constval;

   (* to be called after semantic checks:
      1) operands must be compatible (except IN-operator)
      2) operator must be applyable to the operands

      error messages can result from overflow
      and division by zero
   *)

   PROCEDURE Unary(opsy: Symbol; VAR cval: Constval);
      (* apply `opsy' to `cval'; result in `cval' *)

   PROCEDURE Binary(opsy: Symbol; VAR left: Constval; right: Constval);
      (* apply `opsy' to `left' and `right'; result in `left' *)

END ConstExpr.
