(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: GenBlocks.d,v 0.2 1993/02/03 12:51:19 borchert Stab $
   ----------------------------------------------------------------------------
   $Log: GenBlocks.d,v $
   Revision 0.2  1993/02/03  12:51:19  borchert
   GenPreamble added

   Revision 0.1  1992/07/30  10:46:28  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

DEFINITION MODULE GenBlocks; (* AFB 4/89 *)

   (* generate code for
	 1) modules / module initializations
	 2) global variables
	 3) procedure entries and exits
   *)

   FROM Attributes IMPORT Label;
   FROM SymTab IMPORT Ident;

   PROCEDURE GenModuleHeader;
      (* `mainmod' is taken from `SymFile' *)

   PROCEDURE GenProcEntry(procp: Ident);

   PROCEDURE GenProcExit(procp: Ident);

   PROCEDURE GenPreamble;
      (* the preamble contains the code which is processed during
	 startup to build up various tables w/o initializing the module;
	 is the last code generation procedure to be called
      *)

   PROCEDURE GenModuleEntry;

   PROCEDURE GenModuleExit;

END GenBlocks.
