(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: GenExpr.d,v 0.1 1992/07/30 10:46:31 borchert Exp $
   ----------------------------------------------------------------------------
   $Log: GenExpr.d,v $
   Revision 0.1  1992/07/30  10:46:31  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

DEFINITION MODULE GenExpr; (* AFB 4/89 *)

   (* generate code for expressions
      `at' and everything in connection with `at' must be valid
      (i.e. Scan.errorflag must be FALSE)
   *)

   FROM Attributes IMPORT Attribute, Label;

   PROCEDURE GenExpr(VAR at: Attribute);
      (* `at' is an expression tree of CodeGen;
	 the result attribute is returned in `at'
      *)

   PROCEDURE GenLogExpr(VAR at: Attribute; VAR trueLab, falseLab: Label);
      (* like GenExpr; result is in condMode;
	 if tlabel or flabel are set they equal trueLab and falseLab
      *)

   PROCEDURE GenCall(VAR at: Attribute);
      (* GenCall must not be called if Scan.errorflag is TRUE;
	 in case of functions the function value attribute is
	 returned in `at'
	 else `at' is NIL
      *)

END GenExpr.
