(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: GenStmts.d,v 0.1 1992/07/30 10:46:35 borchert Exp $
   ----------------------------------------------------------------------------
   $Log: GenStmts.d,v $
   Revision 0.1  1992/07/30  10:46:35  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

DEFINITION MODULE GenStmts; (* AFB 5/89 *)

   FROM Attributes IMPORT Attribute, Labels;
   FROM SymTab IMPORT Type;

   PROCEDURE GenAssign(desat, exprat: Attribute);
      (* desat := exprat; both attributes are cleaned up *)

   PROCEDURE GenIfThen(condat: Attribute);
   PROCEDURE GenElsifThen(condat: Attribute);
   PROCEDURE GenElse;
   PROCEDURE GenEndIf;

   PROCEDURE GenWhileDo(condat: Attribute);
   PROCEDURE GenEndWhile;

   PROCEDURE GenRepeat;
   PROCEDURE GenUntil(condat: Attribute);

   PROCEDURE GenLoop;
   PROCEDURE GenExitLoop;
   PROCEDURE GenEndLoop;

   PROCEDURE GenCaseOf(at: Attribute);
   PROCEDURE GenCase(labels: Labels);
   PROCEDURE GenCaseElse(labels: Labels);
   PROCEDURE GenEndCase(labels: Labels);

   PROCEDURE GenReturn;
   PROCEDURE GenReturnExpr(restype: Type; at: Attribute);

   PROCEDURE GenWith(at: Attribute; guard: Type);

END GenStmts.
