(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: Lex.d,v 0.2 1993/06/18 15:29:57 borchert Exp $
   ----------------------------------------------------------------------------
   $Log: Lex.d,v $
   Revision 0.2  1993/06/18  15:29:57  borchert
   Lex depends now on Types.Integer etc.

   Revision 0.1  1992/07/30  10:46:45  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

DEFINITION MODULE Lex;			(* Martin Hasch, Jan 1989 *)

   FROM IdentSys IMPORT Identifier;
   FROM Scan IMPORT Pos;
   FROM Types IMPORT Integer, Real, Set;

   TYPE
      Symbol = (

	 (* keywords *)
	 arraySY, beginSY, caseSY, constSY, definitionSY, divSY, doSY,
	 elseSY, elsifSY, endSY, exitSY, ifSY, importSY, inSY, isSY, loopSY,
	 modSY, moduleSY, nilSY, ofSY, orSY, pointerSY, procedureSY,
	 recordSY, repeatSY, returnSY, thenSY, toSY, typeSY, untilSY,
	 varSY, whileSY, withSY,

	 (* operators and delimiters *)
	 plus, minus, times, slash, tilde, ampersand, period,
	 comma, semicolon, bar,
	 lparen (* "(" *), lbracket (* "[" *), lbrace (* "{" *),
	 becomes, arrow,
	 eql, neq, lst, grt, leq, geq,
	 range, colon,
	 rparen (* ")" *), rbracket (* "]" *), rbrace (* "}" *),

	 (* miscellaneous symbols *)
	 identSY, stringcon,
	 charcon, intcon, realcon, longrealcon,
	 (* not returned by GetSy: *) setcon, boolcon,
	 eop
	 );

   TYPE
      String;
      Constval =
	 RECORD
	    CASE sy: Symbol OF
	    | stringcon:   string: String;
	    | charcon:     charval: CHAR;
	    | intcon:      intval: Integer;
	    | realcon,
	      longrealcon: realval: Real;
	    (* not returned by GetSy: *)
	    | setcon:	   setval: Set;
	    | boolcon:     boolval: BOOLEAN;
	    | nilSY:
	    END;
	 END;

   TYPE
      CompilerOptionChar = ["A".."Z"];
      CompilerOptions = SET OF CompilerOptionChar;

   VAR
      sy: Symbol;		(* set by GetSy *)
      ident: Identifier;	(* if sy=identSY only *)
      cval: Constval;		(* constant value; if sy=*con only *)
      pos: Pos;			(* default error position *)
      previdpos: Pos;		(* position of previous identifier *)
      statementpos: Pos;	(* position of last statement *)
      dummyid: Identifier;	(* identifier that can never be declared *)
      options: CompilerOptions;	(* options actually set *)

   PROCEDURE GetSy;

   PROCEDURE Mark;
      (* set default error position to current token instead of last one *)

   PROCEDURE Insert;
      (* set default error position after last token *)

   PROCEDURE InsertId;
      (* set current identifier position after last token *)

   PROCEDURE PosStatement;
      (* set statementpos to position of last token *)

   PROCEDURE Skip;
      (* leave current symbol out of error positioning *)

   PROCEDURE GetStringChar(str: String; VAR ch: CHAR);
      (* str must be read completely. Last value of ch: 0C *)

   PROCEDURE StringLen(str: String) : CARDINAL;
      (* the terminal 0C is not counted *)

   PROCEDURE GetStringNumber(str: String) : CARDINAL;

   PROCEDURE FirstString;
      (* FirstString; WHILE NextString(s) DO ... END; *)

   PROCEDURE NextString(VAR str: String) : BOOLEAN;

   PROCEDURE InitLex;
      (* to be called after argument scanning *)

   PROCEDURE PutStringChar(ch: CHAR);
      (* only for SymFile *)

   PROCEDURE PutString(VAR str: String);
      (* only for SymFile *)

   PROCEDURE GetSymString(sym: Symbol; VAR str: ARRAY OF CHAR);
      (* useful for error messages *)

   PROCEDURE AddLegalOptions(co: CompilerOptions);
      (* includes co into the set of legal compiler option characters *)
      (* and sets default values TRUE *)
      (* must be called before InitLex *)

   PROCEDURE SetDefault(ochar: CHAR; val: BOOLEAN): BOOLEAN;
      (* changes default value of ochar according to val *)
      (* result is TRUE iff ochar is a CompilerOptionChar and legal *)
      (* must be called before InitLex *)

END Lex.
