(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: Machine.d,v 0.4 1993/06/18 15:31:43 borchert Exp $
   ----------------------------------------------------------------------------
   $Log: Machine.d,v $
   Revision 0.4  1993/06/18  15:31:43  borchert
   environment set unix added
   Size has been moved to Types

   Revision 0.3  1993/06/16  09:44:02  borchert
   constants for SYSTEM.INT16 added
   macintosh added to the list of environments

   Revision 0.2  1993/02/03  12:53:00  borchert
   nilvalue added

   Revision 0.1  1992/07/30  10:46:51  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

DEFINITION MODULE Machine; (* AFB 1/89 *)

   FROM Types IMPORT Real, Size;

   TYPE
      Direction = (forwardDir, backwardDir);

   CONST
      stackdirection = backwardDir;
      alignparam = TRUE;		(* parameters must be aligned *)

      bitsperword = 32;
      onebyte = 1;
      oneshort = 1 * onebyte;
      oneint16 = 2 * onebyte; (* size of SYSTEM.INT16 *)
      oneword = 4 * onebyte; (* oneword should be the size of the bus *)
      onelong = 4 * onebyte;
      onereal = 8 * onebyte;
      onelreal = 12 * onebyte;
      align = oneword;
      procmarkspace = 2 * oneword; (* dynamic link + return address *)
      recspace = 2 * oneword; (* type tag + reference count *)

      ordminchar = 0;
      ordmaxchar = 255;
      maxshort = 127;
      minshort = -maxshort-1;
      maxint16 = 32767;
      minint16 = -maxint16-1;
      maxint = 2147483647;
      minint = -maxint-1;
      maxlong = maxint;
      minlong = -maxlong-1;

      maxreal = MAX(Real);
      minreal = MIN(Real);
      maxlreal = MAX(Real);
      minlreal = MIN(Real);

      nilvalue = 0;

   TYPE
      Targets = (mc68020);
      Environments = (targon31, sun3, macintosh);
      EnvironmentSet = SET OF Environments;
   CONST
      unix = EnvironmentSet{targon31, sun3};
      target = mc68020;
      environment = sun3;

   PROCEDURE Align(VAR size: Size);

END Machine.
