(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: RealConsts.d,v 0.1 1992/07/30 10:47:12 borchert Exp $
   ----------------------------------------------------------------------------
   $Log: RealConsts.d,v $
   Revision 0.1  1992/07/30  10:47:12  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

DEFINITION MODULE RealConsts; (* LG / AFB / MH *)

   FROM Lex IMPORT Constval;

   PROCEDURE InitRealConst;
      (* initialise the calculation of a constant real number *)

   PROCEDURE ConvertToFraction(ch: CHAR);
      (* convert a character to the fraction of a constant real number *)

   PROCEDURE ConvertToExponent(ch: CHAR);
      (* convert a character to the exponent of a constant real number *)

   PROCEDURE TermRealConst(VAR cval: Constval; long: BOOLEAN;
			   VAR success: BOOLEAN);
      (* terminate the calculation of a constant real number *)

END RealConsts.
