(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: RegMan.d,v 0.1 1992/07/30 10:47:15 borchert Exp $
   ----------------------------------------------------------------------------
   $Log: RegMan.d,v $
   Revision 0.1  1992/07/30  10:47:15  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

DEFINITION MODULE RegMan; (* AFB 4/89 *)

   FROM Attributes IMPORT Reg;
   FROM SymTab IMPORT Ident;

   (* (* imported from Attributes *)
      Reg = (d0, d1, d2, d3, d4, d5, d6, d7,
	     a0, a1, a2, a3, a4, a5, a6, a7,
	     illegal, pc, ccr,
	     (* MC68881 *)
	     fp0, fp1, fp2, fp3, fp4, fp5, fp6, fp7,
	     fpcr, fpsr);
      
      available registers:

      data registers:	 d1..d7
      address registers: a0..a5
      fp registers:	 fp1..fp7

      d0 and fp0 are for temporary use (incl. return)
      a6 and a7 are reserved for stack management
   *)

   PROCEDURE GetReg(VAR r: Reg);
      (* return data register *)

   PROCEDURE GetAddrReg(VAR r: Reg);
      (* return address register *)

   PROCEDURE GetAnyReg(VAR r: Reg);
      (* get data or address register *)

   PROCEDURE GetFloatReg(VAR r: Reg);
      (* get floating point register *)

   PROCEDURE RequestReg(r: Reg) : BOOLEAN;
      (* request register `r'; if `r' is already locked FALSE is returned *)

   PROCEDURE FreeReg(r: Reg);

   (* static links and addresses of variables remains unchanged
      during the execution of a procedure;
      so if they have been loaded into a register and
      the register has not been used otherwise
      we needn't to load them again.

      ReturnStaticLink and ReturnAddress returns registers
      (like FreeReg) to the register manager.
      GetStaticLink and GetAddress returns the
      (previously returned) registers if they are still valid.
   *)

   PROCEDURE ReturnStaticLink(r: Reg; level: CARDINAL);

   PROCEDURE ReturnAddress(r: Reg; ip: Ident);

   PROCEDURE GetStaticLink(VAR r: Reg; level: CARDINAL) : BOOLEAN;

   PROCEDURE GetAddress(VAR r: Reg; ip: Ident) : BOOLEAN;

   (* values of variables which has been loaded into a register
      can be released by ReturnVariable.
      If the value of a variable is changed (due to assignments
      or procedure calls) TouchVariable must be called.
      TouchAllVariables causes any information to be forgotten.
   *)

   PROCEDURE ReturnVariable(r: Reg; ip: Ident);

   PROCEDURE TouchVariable(ip: Ident);

   PROCEDURE TouchAllVariables;

   PROCEDURE GetVariable(VAR r: Reg; ip: Ident) : BOOLEAN;

   PROCEDURE BeginBlock;
      (* forget any information about returned registers *)

   PROCEDURE EndBlock;
      (* check that all registers has been released *)

   PROCEDURE SaveRegs;
      (* save currently used registers *)

   PROCEDURE RestoreRegs;
      (* restore registers saved previously *)

END RegMan.
