(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: StackMan.d,v 0.2 1993/09/27 12:40:21 borchert Exp $
   ----------------------------------------------------------------------------
   $Log: StackMan.d,v $
   Revision 0.2  1993/09/27  12:40:21  borchert
   extended support for garbage collector:
      StackUse returns now a list of temporary pointers

   Revision 0.1  1992/07/30  10:47:26  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

DEFINITION MODULE StackMan; (* AFB 4/89 *)

   (* allocation and deallocation of temporary stack space *)

   FROM Attributes IMPORT Label;
   FROM SymTab IMPORT Size;

   TYPE
      PointerList = POINTER TO PointerListRec;
      PointerListRec =
	 RECORD
	    offset: Size;
	    startlabel, endlabel: Label;
	    next: PointerList;
	 END;

   PROCEDURE StackAlloc(VAR offset: Size; size: Size);
      (* `offset' is aligned *)

   PROCEDURE StackFree(offset: Size; size: Size);

   PROCEDURE StackAllocPtr(VAR offset: Size;
			   startlabel, endlabel: Label);
      (* like StackAlloc but for pointers (=> size = oneword)
	 with additional bookkeeping for the garbage collection:
	 startLabel and endlabel define the pc-range where the
	 pointer has a defined value, i.e. is to be checked for
	 during the garbage collection
      *)

   PROCEDURE StackOffset(offset: Size);
      (* called at block entry; `offset' is the offset for temporaries *)

   PROCEDURE StackUse(VAR size: Size; VAR pointerlist: PointerList);
      (* called at block exit; *)
      (* returns the (aligned) number of bytes used for temporaries *)

END StackMan.
