(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: SymDef.d,v 0.2 1993/06/09 14:50:58 borchert Exp $
   ----------------------------------------------------------------------------
   $Log: SymDef.d,v $
   Revision 0.2  1993/06/09  14:50:58  borchert
   ImportOutDefinition added

   Revision 0.1  1992/07/30  10:47:36  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

DEFINITION MODULE SymDef; (* AFB 1/89 *)

   (* symbol table interface to the parser *)
   (* the main goal of this module is to achieve maximum independency *)
   (* between symbol table management and parsing *)

   FROM Lex IMPORT Constval;
   FROM IdentSys IMPORT Identifier;

   TYPE
      Type; (* avoid dependencies! *)
      QualIdent =
	 RECORD
	    idname: Identifier;
	    CASE qualified: BOOLEAN OF
	    | TRUE:  modname: Identifier;
	    END;
	 END;

   (* ---------------------------------------------------------	*)
   (* imports							*)
   (* ---------------------------------------------------------	*)

   PROCEDURE ImportOurDefinition(id: Identifier);
      (* to be called BEFORE the other imports *)

   PROCEDURE Import(id: Identifier);

   PROCEDURE AliasImport(alias, id: Identifier);


   (* ---------------------------------------------------------	*)
   (* scopes							*)
   (* ---------------------------------------------------------	*)

   PROCEDURE OpenScope(id: Identifier);
      (* the first call opens the module; *)
      (* all further calls are for procedures only *)
      (* module: to be called AFTER the imports *)
      (* procedures: to be called AFTER DeclProc *)

   PROCEDURE CloseScope;
      (* to be called at END (ProcedureName|ModuleName) *)


   (* ---------------------------------------------------------	*)
   (* declaration and retrieval of constant values		*)
   (* ---------------------------------------------------------	*)

   PROCEDURE GetConstVal(id: QualIdent; VAR constval: Constval);
      (* retrieval of a constant value *)

   PROCEDURE DeclConst(id: Identifier; constval: Constval);
      (* CONST id = constval *)


   (* ---------------------------------------------------------	*)
   (* type constructors						*)
   (* ---------------------------------------------------------	*)

   PROCEDURE UseType(qualid: QualIdent; VAR type: Type);
      (* type-identifier 'id' is used; return type-structure *)
      (* if 'id' is unknown or of other id-class an error message *)
      (* will be printed and a dummy-type returned *)

   PROCEDURE NoType() : Type;

   PROCEDURE ArrayOf(dim: Constval; elemtype: Type; VAR type: Type);

   PROCEDURE DynArrayOf(elemtype: Type; VAR type: Type);

   PROCEDURE PointerTo(reftype: Type; VAR type: Type);

   PROCEDURE PointerToIdent(rtype: Identifier; VAR type: Type);
      (* use PointerToIdent instead of PointerTo in case of *)
      (* Identifier = POINTER TO Identifier; *)

   PROCEDURE Record(basetype: Type; VAR type: Type);
      (* basetype may be NoType() *)
      (* Record { AddField } EndRecord *)

   PROCEDURE AddField(id: Identifier; fieldtype: Type; VAR type: Type);

   PROCEDURE EndRecord(VAR type: Type);

   PROCEDURE DeclType(id: Identifier; type: Type);


   (* ---------------------------------------------------------	*)
   (* variable declarations					*)
   (* ---------------------------------------------------------	*)

   PROCEDURE DeclVar(id: Identifier; type: Type);
      (* VAR id: type *)

   (* ---------------------------------------------------------	*)
   (* construction of procedures and procedure types:		*)
   (* procedure types:						*)
   (*    ProcedureType { AddParameterType } [ Function ]	*)
   (* procedure declaration:					*)
   (*    ProcedureType { AddParameter } [ Function ] DeclProc	*)
   (* ---------------------------------------------------------	*)

   PROCEDURE ProcedureType(VAR type: Type);
      (* 1st call for procedure types *)

   PROCEDURE AddParameter(var: BOOLEAN; id: Identifier;
			  paramtype: Type; VAR type: Type);
      (* to be called in the order of parameters *)

   PROCEDURE AddParameterType(var: BOOLEAN; paramtype: Type; VAR type: Type);
      (* like AddParameter but for procedure types (with nameless parameters) *)

   PROCEDURE Function(restype: Type; VAR type: Type);

   PROCEDURE DeclProc(id: Identifier; forward: BOOLEAN; type: Type);


   (* ---------------------------------------------------------	*)
   (* resolution of following grammar conflict:			*)
   (* 		   ident "." ident				*)
   (*		   can be a qualident				*)
   (*		   or qualident "." ident (* field selection *)	*)
   (* ---------------------------------------------------------	*)

   PROCEDURE IsVar(id: Identifier) : BOOLEAN;

END SymDef.
