| -----------------------------------------------------------------------------
| Oberon runtime library -- runtime initializations
| (c) University of Ulm, Sektion Informatik, D-7900 Ulm
| afb 5/89
| rev afb 12/90: adapted to Sun3 and gas
| -----------------------------------------------------------------------------
| $Id: ort0.s,v 1.4 1993/06/11 12:23:21 borchert Exp borchert $
| -----------------------------------------------------------------------------
| $Log: ort0.s,v $
| Revision 1.4  1993/06/11  12:23:21  borchert
| new memory management: SysSegments need to be initialized
| Commands, Main and Modules renamed to SysCommands, SysMain and SysModules
|
| Revision 1.3  1993/01/22  13:58:37  borchert
| new runtime start model implemented (see Main & Modules)
|
| Revision 1.2  1992/08/19  14:06:25  borchert
| init of UnixArguments, UnixClock, UnixFiles and UnixProcess included
|
| Revision 1.1  1992/03/25  11:21:57  borchert
| Initial revision
|
| -----------------------------------------------------------------------------
|
| situation after exec:
|
| begin of the stack +-------------+ (highest address)
|                    |    ...      |
|                    +-------------+
|                    |  * envp[1]  |<--------+
|                    +-------------+         |
|                    |  * envp[0]  |<------+ |
|                    +-------------+       | |
|                    |    ...      |       | |
|                    +-------------+       | |
|                    |  * argv[1]  |<----+ | |
|                    +-------------+     | | |
|                    |  * argv[0]  |<--+ | | |
|                    +-------------+   | | | |
|                    |    NULL     |   | | | |
|                    +-------------+   | | | |
|                    |    ...      |   | | | |
|                    +-------------+   | | | |
|                    |   envp[1] o-+---|-|-|-+
|                    +-------------+   | | |
|                    |   envp[0] o-+---|-|-+
|                    +-------------+   | |
|                    |    NULL     |   | |
|                    +-------------+   | |
|                    |    ...      |   | |
|                    +-------------+   | |
|                    |  argv[1] o--+---|-+
|                    +-------------+   |
|                    |  argv[0] o--+---+
|                    +-------------+
|                    |    argc     |
|              %sp ->+-------------+
|                    |             |
|                    | /-----------/
|                    |/
|------------------------------------------------------------------------------
| private variables of the runtime start
	.lcomm  area,4
	.lcomm	ss,8		| struct sigstack, see <sys/signal.h>
	.lcomm	pagesize,4	| return value of getpagesize(2)
	.lcomm	stacktop,4	| top of stack area
|------------------------------------------------------------------------------
	.text
	trapf			| make sure we have MC68020 and up
|
| make argc, argv and environment available for Oberon
|
	movl	a7@,O_SysArgs_argc
	lea	a7@(4),a0
	movl	a0,O_SysArgs_argv
findenv:
	tstl	a0@+
	bne	findenv
	cmpl	a7@(4),a0	| environment given?
	blt	envfound
	subl	#4,a0		| now: environ^ = 0
envfound:
	movl	a0,O_SysArgs_environ
|
| execute preamble code of all modules to build up all RT tables
|
	clrl	O_Commands_modules	| init both pointers
	clrl	O_Modules_modules	| to NIL
	bra	hop1			| hopper model
	.globl lasthop
lasthop:
|----------------------------------------------------------------------------
| retrieve the pagesize of the system
	getpagesize = 64
	movl	#getpagesize,a7@-
	trap	#0
	movl	d0,pagesize
|
| request some memory for the early initialisation phase
|
| memsize should be a power of 2 and large enough to be greater than
| the system's pagesize
|
| Sys.sbrk does not work; perhaps it's a new system call
| capable of incrementing itself, but currently /lib/libc.a
| does not use Sys.sbrk at all.
| 17 ist the old sbreak system call which is still used
| by brk() and sbrk() of /lib/libc.a
|
	memsize = 0x10000		| request 64kb memory
	brk = 17			| system call #, see comment above
	movl	#_end,d2		| take current break
	movl	pagesize,d0		| align d2 to pagesize boundary
	movl	d0,d1
	subl	#1,d0			| d0 := pagesize - 1
	negl	d1			| d1 := - pagesize
	addl	d0,d2
	andl	d1,d2
	movl	d2,d3			| and keep a copy of it
	addl	#memsize,d2		| addr := SYS.ADR(end) + memsize
	movl	d2,a7@-			| addr parameter of brk(2)
	subl	#4,a7
	movl	#brk,a7@-
	trap	#0
	bcs	nomem
| OK, declare the allocated region as free
	addl	#8,a7			| adjust stack pointer after syscall
	movl	d3,O_Storage_next	| d3: aligned end address
	movl	d3,area			| save a copy of it
	movl	#memsize,O_Storage_left
	bra	allocdone
| Well, let's the library decide how to proceed in such situations...
nomem:
	addl	#8,a7			| adjust stack pointer after syscall
	clrl	O_Storage_next
	clrl	O_Storage_left
allocdone:
| Initialize Storage now
	jsr	O_Storage
|
| initialize SysSegments
|
| +--------+-------------+------+-------------------------+--------+---------+
| | unused |   text      | data |                         | stack  | unused  |
| +--------+-------------+------+-------------------------+--------+---------+
|                                \___________  __________/
|                                            \/
|                          this area is to be maintained by Memory
|
| note: the data area has been extended for the preallocated area
|
	jsr	O_SysSegments
| register program text + static data
	movl	#0,a7@-			| addr := 0;
	movl	#_end,a7@-              | size := SYS.ADR(end);
	movl	#0,a7@-                 | mode := 0; (* fixed *)
	jsr	O_SysSegments_Register
| register preallocated area
	movl	area,a7@-		| addr := area;
	movl	#memsize,a7@-		| size := memsize;
	movl	#0,a7@-			| mode := 0; (* fixed *)
	jsr	O_SysSegments_Register
| register stack of main coroutine
	movl	a7,d2			| align a7 to the next page boundary
	movl	pagesize,d0
	movl	d0,d1
	subl	#1,d0			| d0 := pagesize - 1
	negl	d1			| d1 := - pagesize
	addl	d0,d2
	andl	d1,d2
	movl	d2,stacktop		| keep a copy of it
	movl	d2,a7@-			| addr := top of stack area
	movl	#0x01000000,a7@-	| size := 16Mb;
	movl	#-1,a7@-		| mode := -1; (* growing backward *)
	jsr	O_SysSegments_Register
| register protected area at end of address space
	movl	stacktop,a7@-		| addr := top of stack area
	movl	stacktop,d0
	negl	d0
	movl	d0,a7@-			| size := - stacktop;
	movl	#0,a7@-			| mode := 0; (* fixed *)
	jsr	O_SysSegments_Register
|
| initialize SysStorage
|
	jsr	O_SysStorage
|
| now we can allocate the signal stack for SIGSEGV
| which is needed to handle growing stacks of coroutines
|
	stacksize = 0x10000		| request 64kb memory
	pea	ss			| ptr := SYS.ADR(ss.ss_sp);
	movl	#stacksize,a7@-		| size := stacksize
	movl	#0,a7@-			| mode := 0; (* fixed *)
	jsr	O_Storage_AllocateStack	| returns begin of stack interval in ss
	addl	#stacksize,ss		| ss points to end of interval now
	clrl	ss+4			| ss.ss_onstack := 0;
| now call sigstack(ss, NULL)
	sigstack = 112
	movl	#0,a7@-			| oss := NULL;
	pea	ss			| ss := SYS.ADR(ss);
	subl	#4,a7
	movl	#sigstack,a7@-
	trap	#0			| we ignore the carry bit here
|
| initialize RT interface modules
|
	jsr	O_SysModules		| initialize SysModules
	jsr	O_SysLoader		| initialize SysLoader
	jsr	O_SysCommands		| initialize SysCommands
	jsr	O_RTErrors		| initialize RTErrors
	jsr	O_SysArgs		| initialize SysArgs
	jsr	O_Coroutines		| initialize Coroutines
	jsr	O_SysInterrupts		| initialize SysInterrupts

|
| setup UNIX environment
|
	jsr	O_UnixArguments		| initialize UnixArguments
	jsr	O_UnixClock		| initialize UnicClock
	jsr	O_UnixFiles		| initialize UnixFiles
	jsr	O_UnixProcess		| initialize UnixProcess

|
| start of execution
|
	jsr	O_SysMain
|
| end of execution:
| call Process.Exit(0)
|
	movl	#0,a7@-			| push argument
	jsr	O_Process_Exit		| 1st chance
|
| last chance
|
	movl	#0,a7@-
	movl	#0,a7@-
	movl	#1,a7@-
	trap	#0			| exit(0)
|
	.text
	.align	2
hop1:
