|------------------------------------------------------------------------------
| Oberon runtime library -- signal handling
| (c) University of Ulm, Sektion Informatik, D-7900 Ulm
| afb 3/88
| rev afb 12/90 adapted to Sun3 and gas
|------------------------------------------------------------------------------
| $Id$
|------------------------------------------------------------------------------
| $Log$
|------------------------------------------------------------------------------
        .stabs  "signal.s",0144,0,0,.
include(sys.s)
	nsigs = 32
	sigsegv = 11
|	  
	.text
	jmp	signal_END

	.globl	signal_
signal_:
	.lcomm	G_AREA,nsigs*4+4
	.lcomm	_FLAG,4
	.set	signal_V0_,G_AREA
	.globl	signal_V0_
	.set	sigtab,G_AREA
|------------------------------------------------------------------------------
|
| PROCEDURE Signal(sig: INTEGER;			(* 20(%fp) -> %d2 *)
|                  p: CatchSignal;			(* 16(%fp) -> %d3 *)
|		   VAR old: CatchSignal;		(* 12(%fp) <- %d4 *)
|                  VAR error: INTEGER)			(*  8(%fp) <- %d0 *)
|                  : BOOLEAN;                           (*    %d0  <- %d5 *)
|
|------------------------------------------------------------------------------
	.globl	_signal_
_signal_:
	linkw	a6,#-24
|
| check given signal number
|
	movl	a6@(20),d2
	ble	badsig1
	cmpl	#nsigs,d2
	bgt	badsig1
|
| store function address in sigtab[]
|
        movl    @(sigtab,d2:l:4),d4     | get old function address
        movl    a6@(16),d3
        movl    d3,@(sigtab,d2:l:4)     | store new function address
|
| check for SIG_IGN and SIG_DFL
|
        beq     doit                    | function address=0: SIG_DFL
        btst    #0,d3                   | odd address: SIG_IGN
        bne     doit
        movl    #catch_sig,d3
doit:
        movl    d3,a6@(-24)             | vec->sv_handler = catch_sig
        movl    #0,a6@(-20)             | vec->sv_mask = 0
	cmpl	#sigsegv,d2		| signo == SIGSEGV?
	beq	setflag
        movl    #0,a6@(-16)             | vec->sv_flags = 0
	bra	flagsdone
setflag:				| SIGSEGVs are handled on the sigstack
	movl	#1,a6@(-16)		| vec->sv_mask = SV_ONSTACK
flagsdone:
|
| system call with (ovec,    vec,      signo)
|               at  a6@(-12) a6@(-24)  d2
|
        pea     a6@(-12)                | address of ovec
        pea     a6@(-24)                | address of vec (see sigvec)
        movl    d2,sp@-                 | signal number on stack
        movl    #0,sp@-
        pea     0x6c                    | system call sigvec
        trap    #0
|
| return from system call
|
        scc     d5
        negb    d5
        beq     fail
|
| determine oldproc
|
        cmpl    #catch_sig,a6@(-12)     | ovec->sv_handler == catch_sig?
        beq     setold
        movl    a6@(-12),d4             | return value of system call
setold:
        movl    d4,a6@(12)@(0)
        bra     return
|
| bad signal number
|
badsig1:
        movl    #22,a6@(8)@(0)          | EINVAL
        movl    #0,d5                   | return FALSE
	bra	return
|
| restore old function address in sigtab[] on failure
|
fail:
        movl    d4,@(sigtab,d2:l:4)
        movl    d0,a6@(8)@(0)           | error number
|
| return
|
return:
	movl	d5,d0			| return value
	unlk	a6
	rtd	#16
|
|
|------------------------------------------------------------------------------
|
| general signal catching routine
|
|------------------------------------------------------------------------------
catch_sig:
        linkw   a6,#-64         | link and allocate memory for register saving
        moveml  #0xffff,a6@(-64)
|
| signal number should be in [1..nsigs]
|
        movl    a6@(4),d0
        ble     badsig2
        cmpl    #nsigs,d0
        bgt     badsig2
|
| mark the coroutine as interrupted
|
	movl	O_Coroutines_current,a7@-
	jsr	O_SysInterrupts_IncNumberOfInterrupts
|
| call Oberon signal catching procedure
|
callfunc:
	movl	d0,a7@-		| signal number
	movl	#12,a7@-	| LEN(sysinfo)
	pea	a6@(8)		| ADR(sysinfo)
	addl	#1,a6		| indication for odb
        jsr     @(sigtab,d0:l:4)@(0)
	subl	#1,a6
|
| remove interrupt mark from coroutine
|
	movl	O_Coroutines_current,a7@-
	jsr	O_SysInterrupts_DecNumberOfInterrupts
badsig2:
        moveml  a6@(-64),#0xffff
	unlk	a6
|
| return from interrupt
|
        addl    #8,sp
        pea     0x8b:w
        trap    #0
|------------------------------------------------------------------------------
	.align	2
signal_END:
