#!/bin/sh
# -----------------------------------------------------------------------------
# Ulm's Oberon Library
# Copyright (C) 1989-1994 by University of Ulm, SAI, D-89069 Ulm, Germany
# -----------------------------------------------------------------------------
# Ulm's Oberon Library is free software; you can redistribute it
# and/or modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either version
# 2 of the License, or (at your option) any later version.
# 
# Ulm's Oberon Library is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied warranty
# of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
# 
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# -----------------------------------------------------------------------------
# E-mail contact: oberon@mathematik.uni-ulm.de
#------------------------------------------------------------------------------
# generate configuration file for Oberon compiler interface
# afb 9/90
#------------------------------------------------------------------------------
# $Id: conf.sh,v 1.1 1994/02/23 11:30:41 borchert Exp $
#------------------------------------------------------------------------------
# $Log: conf.sh,v $
# Revision 1.1  1994/02/23  11:30:41  borchert
# Initial revision
#
#------------------------------------------------------------------------------

# default values
	module=SysConf

# tunable parameters
	# the configuration lines are introduced with $conf_begin and
	# ended with $conf_end
	conf_begin='#CONF'
	conf_end='#ENDCONF'
	# the field separator must be chosen carefully -- it may
	# not be mentioned in the configuration table below and
	# it must not be passed as an argument to this script
	field_sep="@"

# command name and usage
	name=`basename $0`
	usage="Usage: $name [-m module] {param=value}"

# temporary files & cleanup
	tmpdir=/tmp
	prefix=`echo $name | sed 's/\(....\).*/\1/'`
	tmpsource=$tmpdir/$prefix.$$.1
	tmpparams=$tmpdir/$prefix.$$.2
	trap "rm -f $tmpsource $tmpparams; exit 1" 1 2 3 15
	trap "rm -f $tmpsource $tmpparams" 0

conf='
#------------------------------------------------------------------------------
# hint: spaces which should not work as field delimiters should be
#       given as "\" followed by " ". "$field_sep" is not permitted.
# configuration parameters:
#
#  name of	default value		depends		is overridden by
#  parameter				on
#------------------------------------------------------------------------------
libdir		/usr/local/lib/oberon	$OBLIB		$OBLIB
compiler	/usr/local/lib/oberon/oberon $OBLIB	$OBLIB/oberon
nameOfCompiler	oberon
assembler	/usr/local/bin/gas	$OBAS		$OBAS
nameOfAssembler	gas-1.36
linkeditor	/usr/bin/ld		$OBLD		$OBLD
nameOfLinkeditor ld
archivist	/usr/5bin/ar		$OBAR		$OBAR
nameOfArchivist	ar
needRanlib	FALSE			$OBNEEDRANLIB	$OBNEEDRANLIB
ranlib		/usr/bin/ranlib		$OBRANLIB	$OBRANLIB
version		0.1			$OBVERSION	$OBVERSION
distributedBy	unknown
distributionDate unknown
#------------------------------------------------------------------------------
'

#------------------------------------------------------------------------------
# get_conf returns the parameters and their values
#------------------------------------------------------------------------------
get_conf()
{	echo "$conf" | sed '/^$/d; /^#/d' |
	while read name default2 depends default1
	do	value=`eval echo \\$PARAM_$name`
		case $value
		in "")	param=`eval echo $depends`
			case $param
			in "")	value="$default2"
			;; *)	value=`eval echo $default1`
				case $value
				in "")	value="$default2"
				esac
			esac
		esac
		echo "$name$field_sep$value"
	done
}

#------------------------------------------------------------------------------
# print usage and exit
#------------------------------------------------------------------------------
print_usage()
{	{	echo "$usage"
		{	echo "valid parameters and their default values:"
			get_conf |
			awk -F"$field_sep" '{ printf "%-16s %s\n", $1, $2 }'
		} | sed 's/^/   /'
		echo "The internal field separator is $field_sep -- do not use it."
	} >&2
	exit 1
}

#------------------------------------------------------------------------------
# work up arguments
#------------------------------------------------------------------------------
scan_args()
{
	params=
	while [ $# -gt 0 ]
	do	case $1
		in --)	shift; break
		;; -m)	shift; module="$1"
		;; -*)	print_usage
		;; *=*)	if [ "" = "$params" ]
			then params="$1"
			else params="$params$field_sep$1"
			fi
		;; *)	print_usage
		esac
		shift
	done
	if [ $# -gt 0 ]
	then	print_usage
	fi
	echo "$params" | tr "$field_sep" '\012' |
	while read param
	do	name=`echo $param | sed 's/=.*//'`
		value=`echo $param | sed 's/^[^=]*=//'`
		if get_conf | grep '^'"$name\\$field_sep" >/dev/null
		then	echo PARAM_$name="'$value'"
			echo export PARAM_$name
		else	echo echo "Parameter $name not known"
			echo print_usage
		fi
	done >$tmpparams
	. $tmpparams
}

#------------------------------------------------------------------------------
# update configuration module
#------------------------------------------------------------------------------
awk_script='
BEGIN		{	copy = 0; part = 1; pindex = 0
		}
/'$conf_end'/	{	for (i = 0; i < pindex; ++ i)
				if (value[i] == "TRUE" || value[i] == "FALSE")
					printf "      %s = %s;\n", \
						name[i], value[i]
				else
					printf "      %s = \"%s\";\n", \
						name[i], value[i]
			copy = 1
		}
		{	if (copy)
				print $0
			else if (part == 1 && NF > 0)
			{	name[pindex] = $1;
				value[pindex] = $2;
				++ pindex;
			}
		}
NF==0		{	if (part == 1)
			{	part = 2; copy = 1
			}
		}
/'$conf_begin'/	{	copy = 0;
		}
'
update_conf()
{
	definition="$module.od"
	module="$module.om"
	if [ -d RCS ]
	then	co -l $definition $module
	else	chmod ug+w $definition $module
	fi
	if [ ! -r $definition ]
	then	echo >&2 "$name: cannot open $definition"; exit 1
	fi

	{	get_conf
		echo
		cat $definition
	} | awk -F"$field_sep" "$awk_script" >$tmpsource &&
	cp $tmpsource $definition &&
	sed <$definition >$module 's/DEFINITION/MODULE/'
	if [ -d RCS ]
	then	ci -m"update by $name" -u $definition $module
	else	chmod -w $definition $module
	fi
}

#------------------------------------------------------------------------------
# main
#------------------------------------------------------------------------------
scan_args "$@"
update_conf
