(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: Attributes.m2,v 0.1 1992/07/30 10:47:51 borchert Exp $
   ----------------------------------------------------------------------------
   $Log: Attributes.m2,v $
   Revision 0.1  1992/07/30  10:47:51  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

IMPLEMENTATION MODULE Attributes; (* AFB 2/89 *)

   FROM Exception IMPORT Assert;
   FROM Memory IMPORT ALLOCATE;

   VAR
      unique: CARDINAL;

   PROCEDURE GetLabel(VAR l: Label);
      (* get label with unique `n1'; head = 0C and n2 = 0 *)
   BEGIN
      WITH l DO
	 ok := TRUE;
	 head := 0C;
	 n1 := unique; INC(unique);
	 n2 := 0;
      END;
   END GetLabel;

   PROCEDURE NewAttribute(VAR at: Attribute);
      (* NEW(at) *)
   BEGIN
      NEW(at);
   END NewAttribute;

   PROCEDURE DisposeAttribute(VAR at: Attribute);
      (* DISPOSE(at); at := NIL; *)
   BEGIN
      at := NIL;
   END DisposeAttribute;

   PROCEDURE NoAttributes;
      (* to be called if no Attribute-record is allocated/used *)
   END NoAttributes;

BEGIN
   unique := 1;
END Attributes.
