(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: CodeGen.d,v 0.1 1992/07/30 10:46:10 borchert Exp $
   ----------------------------------------------------------------------------
   $Log: CodeGen.d,v $
   Revision 0.1  1992/07/30  10:46:10  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

DEFINITION MODULE CodeGen; (* AFB 1/89 *)

   (* code generation interface to the parser *)
   (*    procedures are to be called during the parse of statements *)

   FROM Lex IMPORT Constval, Symbol;
   FROM IdentSys IMPORT Identifier;

   TYPE
      Attribute;
      Labels;

   (* ---------------------------------------------------------	*)
   (* initialize attributes					*)
   (* ---------------------------------------------------------	*)

   PROCEDURE InitConstAt(constval: Constval; VAR at: Attribute);

   PROCEDURE InitIdentAt(id: Identifier; VAR at: Attribute);
      (* get attribute for any identifer: *)
      (* modules, constants, types, variables, and procedures *)

   PROCEDURE InitNILAt(VAR at: Attribute);
      (* get attribute for NIL *)

   PROCEDURE InitEmptyAt(VAR at: Attribute);
      (* usable for errorneous attributes or empty element list *)


   (* ---------------------------------------------------------	*)
   (* designators						*)
   (* ---------------------------------------------------------	*)

   PROCEDURE Qualified(ident: Identifier; VAR at: Attribute);
      (* at.ident *)

   PROCEDURE Index(index: Attribute; VAR at: Attribute);
      (* at[index] *)

   PROCEDURE FieldSelection(field: Identifier; VAR at: Attribute);
      (* at.field *)

   PROCEDURE Dereference(VAR at: Attribute);
      (* at^ *)

   PROCEDURE Typeguard(type: Attribute; VAR at: Attribute);
      (* at(type) *)

   (* ---------------------------------------------------------	*)
   (* resolution of following grammar conflict:			*)
   (*    	ident "(" ident ")"				*)
   (*		   can be a procedure call			*)
   (* 		   or a type guard				*)
   (* ---------------------------------------------------------	*)

   PROCEDURE IsVarNoProcvar(at: Attribute) : BOOLEAN;
      (* returns TRUE if 'qualid' is a variable in the current scope *)
      (*                 and no procedure variable		 *)
      (* to be called on 'qualid' "(" to decide whether a type guard *)
      (* or a procedure call is coming now;			 *)
      (* This test does not print any error messages.		 *)



   (* ---------------------------------------------------------	*)
   (* construction of expressions				*)
   (* ---------------------------------------------------------	*)

   PROCEDURE UnaryOp(op: Symbol; VAR at: Attribute);
      (* op may be: plus, minus, tilde *)

   PROCEDURE BinaryOp(op: Symbol; left, right: Attribute; VAR at: Attribute);
      (* op may be: inSY, isSY, divSY, modSY, orSY *)
      (*	    ampersand, *)
      (*            plus, minus, times, slash, *)
      (*            eql, neq, lst, grt, leq, geq *)
      (* incl. set construction: comma, range *)

   PROCEDURE Set(VAR at: Attribute);
      (* "{" at "}" *)

   PROCEDURE EvalConst(at: Attribute; VAR constval: Constval);

   PROCEDURE AssertConst(at: Attribute);
      (* print error message if `at' is not a constant *)


   (* ---------------------------------------------------------	*)
   (* procedure/function calls					*)
   (* ProcDesignator {Parameter} [ProcedureCall | FunctionCall] *)
   (* ---------------------------------------------------------	*)

   PROCEDURE ProcDesignator(VAR at: Attribute);

   PROCEDURE Parameter(parm: Attribute; VAR at: Attribute);

   PROCEDURE ProcedureCall(at: Attribute);
   
   PROCEDURE FunctionCall(VAR at: Attribute);


   (* ---------------------------------------------------------	*)
   (* statements -- procedure calls see above			*)
   (* ---------------------------------------------------------	*)

   PROCEDURE Assignment(desat, exprat: Attribute);
      (* desat := exprat *)

   PROCEDURE IfThen(condat: Attribute);
      (* IfThen { ElsifThen } [ Else ] EndIf *)

   PROCEDURE ElsifThen(condat: Attribute);

   PROCEDURE Else;

   PROCEDURE EndIf;

   PROCEDURE CaseOf(at: Attribute; VAR label: Labels);
      (* CaseOf { CaseLabels } [ CaseElse ] EndCase *)

   PROCEDURE InitLabel(label: Labels);
      (* InitLabel { AddLabel | AddRange }+ CaseLabels *)

   PROCEDURE AddLabel(at: Attribute; VAR label: Labels);

   PROCEDURE AddRange(at1, at2: Attribute; VAR label: Labels);

   PROCEDURE CaseLabels(labels: Labels);
      (* to be called at ":" *)

   PROCEDURE CaseElse(labels: Labels);

   PROCEDURE EndCase(labels: Labels);

   PROCEDURE WhileDo(condat: Attribute);

   PROCEDURE EndWhile;

   PROCEDURE Repeat;

   PROCEDURE Until(condat: Attribute);

   PROCEDURE Loop;

   PROCEDURE ExitLoop;
      (* correct nesting is checked by CodeGen *)

   PROCEDURE EndLoop;

   PROCEDURE Return;

   PROCEDURE ReturnExpr(at: Attribute);

   PROCEDURE WithDo(VAR at, type: Attribute);

   PROCEDURE EndWith(at: Attribute);


   (* ---------------------------------------------------------	*)
   (* procedures						*)
   (*    o InitIdentAt(procedure name) just before OpenScope	*)
   (*    o ProcedureBegin at BEGIN				*)
   (*    o ProcedureEnd at END procedure name			*)
   (* ---------------------------------------------------------	*)

   PROCEDURE ProcedureBegin(at: Attribute);

   PROCEDURE ProcedureEnd(at: Attribute);

   PROCEDURE ModuleHeader;
      (* to be called just after OpenScope for the module *)

   PROCEDURE ModuleBegin;

   PROCEDURE ModuleEnd;

   PROCEDURE InitCodeGen;
      (* to be called after argument scanning *)

END CodeGen.
