(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: EmitCode.d,v 0.4 1993/09/27 12:42:36 borchert Exp $
   ----------------------------------------------------------------------------
   $Log: EmitCode.d,v $
   Revision 0.4  1993/09/27  12:42:36  borchert
   EmitAlign4 added

   Revision 0.3  1993/04/13  15:08:11  borchert
   %:i (index register pair) added
   %t  (print label of tag record) added

   Revision 0.2  1993/02/03  12:50:10  borchert
   comment for %P added
   %:D and %:= added
   generation of module & command records removed

   Revision 0.1  1992/07/30  10:46:17  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

DEFINITION MODULE EmitCode; (* AFB 3/89 *)

   (* the only assembly output generating module;
      this interface does not depend on a particular assembler

      no code is generated if Scan.errorflag is TRUE
   *)

   FROM Attributes IMPORT Label;
   FROM Lex IMPORT String;
   FROM Mnemonics IMPORT Mnemonic;
   FROM SymTab IMPORT Ident;
   FROM SYSTEM IMPORT BYTE;

   PROCEDURE Emit(m: Mnemonic; s: ARRAY OF CHAR);
   PROCEDURE Emit1(m: Mnemonic; s: ARRAY OF CHAR; p1: ARRAY OF BYTE);
   PROCEDURE Emit2(m: Mnemonic; s: ARRAY OF CHAR; p1, p2: ARRAY OF BYTE);
   PROCEDURE Emit3(m: Mnemonic; s: ARRAY OF CHAR; p1, p2, p3: ARRAY OF BYTE);
   PROCEDURE Emit4(m: Mnemonic; s: ARRAY OF CHAR;
		   p1, p2, p3, p4: ARRAY OF BYTE);
   PROCEDURE Emit5(m: Mnemonic; s: ARRAY OF CHAR;
		   p1, p2, p3, p4, p5: ARRAY OF BYTE);
   PROCEDURE Emit6(m: Mnemonic; s: ARRAY OF CHAR;
		   p1, p2, p3, p4, p5, p6: ARRAY OF BYTE);
   PROCEDURE Emit7(m: Mnemonic; s: ARRAY OF CHAR;
                   p1, p2, p3, p4, p5, p6, p7: ARRAY OF BYTE);
   PROCEDURE Emit8(m: Mnemonic; s: ARRAY OF CHAR;
                   p1, p2, p3, p4, p5, p6, p7, p8: ARRAY OF BYTE);
   PROCEDURE Emit9(m: Mnemonic; s: ARRAY OF CHAR;
		   p1, p2, p3, p4, p5, p6, p7, p8, p9: ARRAY OF BYTE);
   PROCEDURE StrEmit(s: ARRAY OF CHAR);
   PROCEDURE StrEmit1(s: ARRAY OF CHAR; p1: ARRAY OF BYTE);
   PROCEDURE StrEmit2(s: ARRAY OF CHAR; p1, p2: ARRAY OF BYTE);
   PROCEDURE StrEmit3(s: ARRAY OF CHAR; p1, p2, p3: ARRAY OF BYTE);
   PROCEDURE StrEmit4(s: ARRAY OF CHAR; p1, p2, p3, p4: ARRAY OF BYTE);
   PROCEDURE StrEmit5(s: ARRAY OF CHAR; p1, p2, p3, p4, p5: ARRAY OF BYTE);
   PROCEDURE StrEmit6(s: ARRAY OF CHAR; p1, p2, p3, p4, p5, p6: ARRAY OF BYTE);
   PROCEDURE StrEmit7(s: ARRAY OF CHAR;
                   p1, p2, p3, p4, p5, p6, p7: ARRAY OF BYTE);
   PROCEDURE StrEmit8(s: ARRAY OF CHAR;
                   p1, p2, p3, p4, p5, p6, p7, p8: ARRAY OF BYTE);
   PROCEDURE StrEmit9(s: ARRAY OF CHAR;
		   p1, p2, p3, p4, p5, p6, p7, p8, p9: ARRAY OF BYTE);
      (* each Emit generates one line of output
	    exceptions: line numbers (in text segment only)
			definitions of real constants
	 permitted characters in strings and outside of %'s:
		     a-zA-Z0-9_,.
		     , separates operands
		     . is possibly translated to another character
		     (e.g. ~ or % on Nixdorf Targon/31)
	 inside comments (%*...) any printable character (except newline)
	 is permitted
	 composed/"selfmade" labels must be preceded by %_

	 control formats of `s':
	 %%   % (should not be used)
	 %a   attribute (Attributes.Attribute)
	 %A   take size attribute from 1st %a: attype^.size
	 %B   size attribute: byte
	 %:b  (global) bss segment; parameter: size in bytes; label follows
	 %:B  (local) bss segment; parameter: size in bytes; label follows
	 %c   CARDINAL value
	 %C   immediate CARDINAL value
	 %D   size attribute: double
	 %e   import (entry) definition (StrEmit); label follows
	 %g   export (global) definition (StrEmit); label follows
	 %i   INTEGER value
	 %I   immediate INTEGER value
	 %:i  index register pair (two parameters required)
	 %l   label
	 %:l  define label (like EmitLabel) (followed by %'s for the label)
	 %:L  define long constant (followed by %'s for the value)
	 %L   size attribute: long
	 %n   identifier (IdentSys.Identifier)
	 %P   introduces assembler dependent pseudo operations;
	      is followed by %'s for the opcode and the operands
	      (don't use this feature outside of EmitCode.m2)
	 %r   register (register direct)
	 %+r  register (address register indirect with postincrement)
	 %-r  register (address register indirect with predecrement)
	 %:r  register pair (two parameters required)
	 %(r) register (register indirect)
	 %()  inside () one of
	      d,r
	      d,r,r
	      r,r		register indirect with index
	      [d,r],r,d		memory indirect post-indexed
	      [d,r,r],d		memory indirect pre-indexed
	      ...
	      %-sequences instead of `d' permitted
	      `r' may be followed by 2, 4, or 8 (scale)
	 %{}  offset/width specification of bit fields inside {} one of
	      d:d
	      d:r
	      r:d
	      r:r
	      %-sequences instead of `d' permitted
	      r  any data register
	      d  any value between 0-31 (offset) or 1-32 (width)
	      %{} is preceded by the effective address, e.g. %a%{d:d}
	 %s   string (ARRAY OF CHAR)
	 %S   label of string (Lex.String)
	 %:s  define string (like EmitString); parameter: ARRAY OF CHAR
	 %t   print label of tag record (SymTab.Type)
	 %v   constant value (Lex.Constval)
	 %V   (immediate) constant value (Lex.Constval)
	 %W   size attribute: word
	 %X   size attribute: extended
	 %*   treat rest of line as comment
	 %#   immediate expression follows
	 %_   prefix for all labels (except Attribute.Label and string labels)
	 %=   define label (Attributes.Label); followed by anything (value)
	 %:D  define label; followed by anything for the label and ...
	 %:=  which should be followed by anything for the value
      *)

   (* pseudo operations *)

   TYPE
      Segment = (text, data);

   PROCEDURE SetSegment(s: Segment);

   PROCEDURE EmitAlign; (* 2-byte-alignment *)

   PROCEDURE EmitAlign4; (* 4-byte-alignment *)

   PROCEDURE EmitLabel(l: Label); (* define label *)

   PROCEDURE EmitString(s: String); (* define label and string *)

   PROCEDURE EmitHeader(modp: Ident); (* module header and key *)

   PROCEDURE EmitKey(extmodp: Ident); (* key reference to imported module *)

   (* generations of stabs and line numbers *)
   PROCEDURE EmitFileName(filename: ARRAY OF CHAR);
   PROCEDURE EmitBeginBlock1(blockp: Ident; line: CARDINAL);
   PROCEDURE EmitBeginBlock2(blockp: Ident; line: CARDINAL);
   PROCEDURE EmitEndBlock1(blockp: Ident; line: CARDINAL);
   PROCEDURE EmitEndBlock2(blockp: Ident; line: CARDINAL);

   PROCEDURE EmitName(ip: Ident);
      (* generate the name of a module or procedure;
	 this is to be called for each module and procedure
	 which is passed to EmitCmdModuleRec, EmitCommandRec or
	 EmitModuleRec
      *)

   PROCEDURE InitEmitCode;
      (* to be called after ScanArgs *)

END EmitCode.
