(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: Exception.m2,v 0.1 1992/07/30 10:48:11 borchert Exp $
   ----------------------------------------------------------------------------
   $Log: Exception.m2,v $
   Revision 0.1  1992/07/30  10:48:11  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

IMPLEMENTATION MODULE Exception;	(* Martin Hasch, Jan 1989 *)

   FROM Scan IMPORT Message, Message2, ErrorType;
   FROM Errno IMPORT errno;

   PROCEDURE Fatal(mesg: ARRAY OF CHAR);		(* EXPORTED *)
   BEGIN
      Message(fatal,mesg)
   END Fatal;

   PROCEDURE IOFault(filename: ARRAY OF CHAR);		(* EXPORTED *)
   BEGIN
      Message2(fatal,"%s: %E",filename,errno)
   END IOFault;

   PROCEDURE Assert(condition: BOOLEAN);		(* EXPORTED *)
   BEGIN
      IF ~condition THEN
	 Message(bug,"assertion failed")
      END;
   END Assert;

END Exception.
