(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: GenBlocks.m2,v 0.5 1993/09/27 12:52:21 borchert Exp $
   ----------------------------------------------------------------------------
   $Log: GenBlocks.m2,v $
   Revision 0.5  1993/09/27  12:52:21  borchert
   support of temporary pointers for GC

   Revision 0.4  1993/06/11  12:33:54  borchert
   Commands and Modules renamed to SysCommands and SysModules

   Revision 0.3  1993/04/19  14:39:03  borchert
   bug fix: GenCommands was accidently called twice

   Revision 0.2  1993/02/03  12:36:37  borchert
   module records are now generated by GenBlocks
   generation of tag record for global variables
   new initialisation model during early startup phase
   generation of tag records for procedures

   Revision 0.1  1992/07/30  10:48:19  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

IMPLEMENTATION MODULE GenBlocks; (* AFB 4/89 *)

   (* generate code for
	 1) modules / module initializations
	 2) global variables
	 3) procedure entries and exits
   *)

   FROM Attributes IMPORT Reg, top, base, Label, GetLabel, returnLabel;
   FROM EmitCode IMPORT EmitHeader, EmitKey, EmitString, SetSegment, Segment,
      EmitName, EmitAlign, EmitLabel,
      Emit, Emit1, Emit2, Emit3, Emit4,
      StrEmit, StrEmit1, StrEmit2, StrEmit3, StrEmit4,
      EmitFileName,
      EmitBeginBlock1, EmitBeginBlock2, EmitEndBlock1, EmitEndBlock2;
   FROM Exception IMPORT Assert;
   FROM GenBasicOps IMPORT LoadDynArraySize, MoveBytes, ccat;
   FROM GenTypes IMPORT InitLocalPointers, GenTypes, GenExportedTypes,
      GenTypeTagForGlobals, GenTypeTagForBlock;
   FROM Lex IMPORT String, FirstString, NextString, pos;
   FROM Machine IMPORT Align, nilvalue, oneword, environment, Environments;
   FROM Mnemonics IMPORT Mnemonic;
   FROM RegMan IMPORT GetAddrReg, BeginBlock, EndBlock, GetReg, FreeReg;
   FROM Scan IMPORT errorflag;
   FROM ScanArgs IMPORT commands, input;
   FROM StackMan IMPORT PointerList, StackOffset, StackUse;
   FROM Standard IMPORT byteptr, sysmodid;
   FROM Storage IMPORT ALLOCATE;
   FROM SymTab IMPORT Size, Ident, IdentList, globalvars, mainmod, extmods,
      IdentClass, global, VarKind, Type, Form;

   TYPE
      CommandList = POINTER TO CommandRec;
      CommandRec =
	 RECORD
	    next: CommandList;
	    procp: Ident;
	 END;

      BlockList = POINTER TO BlockRec;
      BlockRec =
	 RECORD
	    next: BlockList;
	    begin, end, tag: Label;
	 END;

   VAR
      firstproc: BOOLEAN; (* first procedure? *)
      stackUseLabel: Label;
      cmds, tail: CommandList; (* list of global parameterless procedures *)
      blocks, lastblock: BlockList; nofblocks: CARDINAL;

   PROCEDURE GenModuleHeader;
      (* `mainmod' is taken from `SymFile' *)
   BEGIN
      IF ~errorflag THEN
	 EmitFileName(input);
	 StrEmit1("%:l%_%n__BEGIN", mainmod^.origname);
	 Emit1(JSR, "%_%n__TPRE", mainmod^.origname);
	 Emit1(JSR, "%_%n__PRE", mainmod^.origname);
	 Emit1(JMP, "%_%n__END", mainmod^.origname);
      END;
   END GenModuleHeader;

   PROCEDURE GenVariables;
      (* global variables *)
      CONST
	 sizeOfTag = oneword;
      VAR
	 sizeOfGlobalArea: Size;

      PROCEDURE AssignOffsets(VAR sizeOfGlobalArea: Size);
	 VAR
	    varp: IdentList;
	    alignedsize: Size;
	    globalOffset: Size;
      BEGIN
	 globalOffset := 0;
	 varp := globalvars;
	 WHILE varp # NIL DO
	    WITH varp^.ident^ DO
	       alignedsize := type^.size; Align(alignedsize);
	       offset := globalOffset; INC(globalOffset, alignedsize);
	    END;
	    varp := varp^.link;
	 END;
	 sizeOfGlobalArea := sizeOfTag + globalOffset;
      END AssignOffsets;

      PROCEDURE EmitLabels;
	 VAR
	    varp: IdentList;
      BEGIN
	 varp := globalvars;
	 WHILE varp # NIL DO
	    WITH varp^.ident^ DO
	       StrEmit2("%g%_%n_%n", mainmod^.origname, name);
	       StrEmit4("%:D%_%n_%n%:=%_%n__GLOBALVARS+%c",
		     mainmod^.origname, name, mainmod^.origname, offset);
	    END;
	    varp := varp^.link;
	 END;
      END EmitLabels;

   BEGIN
      IF firstproc THEN
	 firstproc := FALSE;
	 StrEmit("%*global variables");
	 AssignOffsets(sizeOfGlobalArea);
	 StrEmit2("%:B%_%n__GLOBALS", sizeOfGlobalArea, mainmod^.origname);
	 StrEmit2("%:D%_%n__GTAGREF%:=%_%n__GLOBALS",
	    mainmod^.origname, mainmod^.origname);
	 StrEmit3("%:D%_%n__GLOBALVARS%:=%_%n__GLOBALS+%c",
	    mainmod^.origname, mainmod^.origname, sizeOfTag);
	 EmitLabels;
	 GenTypeTagForGlobals(sizeOfGlobalArea - sizeOfTag);
      END;
   END GenVariables;

   PROCEDURE GenStrings;
      (* string constants *)
      VAR
	 s: String;
	 ch: CHAR;
   BEGIN
      SetSegment(text);
      FirstString;
      WHILE NextString(s) DO
	 EmitString(s);
      END;
   END GenStrings;

   PROCEDURE EmitCmdModuleRec(modp, firstcmd: Ident);
   BEGIN
      WITH modp^ DO
	 Assert(class = moduleC);
	 StrEmit1("%*SysCommands.ModuleRec for %n", origname);
	 SetSegment(data); (* allow next-component to be overwritten *)
	 StrEmit1("%:l%_%n__CMDS", origname);
	 StrEmit1("%:L%c", 0); (* next := NIL *)
	 StrEmit1("%:L%_%n__NAME", origname); (* name *)
	 StrEmit1("%:L%_%n", origname); (* init (module body) *)
	 IF firstcmd # NIL THEN
	    StrEmit2("%:L%_%n_%n_CMD", origname, firstcmd^.name); (* commands *)
	 ELSE
	    StrEmit1("%:L%c", 0); (* commands := NIL *)
	 END;
      END;
   END EmitCmdModuleRec;

   PROCEDURE EmitCommandRec(procp, next: Ident);
   BEGIN
      WITH procp^ DO
	 Assert(class = procedureC);
	 StrEmit1("%*SysCommands.CommandRec for %n", name);
	 SetSegment(text);
	 StrEmit2("%:l%_%n_%n_CMD", mod^.origname, name);
	 IF next # NIL THEN
	    StrEmit2("%:L%_%n_%n_CMD", next^.mod^.origname, next^.name);
	 ELSE
	    StrEmit1("%:L%c", 0); (* next := NIL *)
	 END;
	 StrEmit2("%:L%_%n_%n_NAME", mod^.origname, name); (* name *)
	 StrEmit2("%:L%_%n_%n", mod^.origname, name); (* proc *)
      END;
   END EmitCommandRec;

   PROCEDURE GenCommands;
      VAR
	 cmd: CommandList;
   BEGIN
      IF cmds = NIL THEN
	 EmitCmdModuleRec(mainmod, NIL);
      ELSE
	 EmitCmdModuleRec(mainmod, cmds^.procp);
	 cmd := cmds;
	 WHILE cmd^.next # NIL DO
	    WITH cmd^ DO
	       EmitName(procp); (* TEMPORARY *)
	       EmitCommandRec(procp, next^.procp);
	    END;
	    cmd := cmd^.next;
	 END;
	 EmitName(cmd^.procp); (* TEMPORARY *)
	 EmitCommandRec(cmd^.procp, NIL);
      END;
   END GenCommands;

   PROCEDURE GenBlockEntry(ip: Ident);
      VAR
	 cmd: CommandList;
	 block: BlockList;
   BEGIN
      BeginBlock;
      SetSegment(text);
      INC(nofblocks);
      NEW(block); GetLabel(block^.begin); EmitLabel(block^.begin);
      block^.next := NIL;
      IF blocks = NIL THEN
	 blocks := block;
      ELSE
	 lastblock^.next := block;
      END;
      lastblock := block;
      EmitBeginBlock1(ip, pos.line);
      GetLabel(returnLabel);
      GetLabel(stackUseLabel);
      Emit2(LINK, "%L%r,%#%l", base, stackUseLabel);
      WITH ip^ DO
	 IF class = moduleC THEN
	    StackOffset(0);
	 ELSE
	    Align(varoffset);
	    StackOffset(varoffset);
	    IF (plevel = global) & exported & (params = NIL) THEN
	       NEW(cmd);
	       WITH cmd^ DO
		  procp := ip;
		  next := NIL;
	       END;
	       IF tail = NIL THEN
		  cmds := cmd;
	       ELSE
		  tail^.next := cmd;
	       END;
	       tail := cmd;
	    END;
	 END;
      END;
   END GenBlockEntry;

   PROCEDURE GenBlockExit(ip: Ident);
      VAR
	 stackuse: Size;
	 tmpptrs: PointerList;
   BEGIN
      EmitLabel(returnLabel);
      returnLabel.ok := FALSE;
      Emit1(UNLK, "%r", base);
      StackUse(stackuse, tmpptrs);
      WITH ip^ DO
	 IF (class = moduleC) OR (parmoffset = 0) THEN
	    Emit(RTS, "");
	 ELSE
	    Emit1(RTD, "%C", ABS(parmoffset));
	 END;
	 IF class # moduleC THEN
	    INC(stackuse, ABS(varoffset));
	 END;
      END;
      EmitEndBlock2(ip, pos.line);
      StrEmit2("%=%i", stackUseLabel, -stackuse);
      EndBlock;
      GetLabel(lastblock^.end); EmitLabel(lastblock^.end);
      GetLabel(lastblock^.tag); GenTypeTagForBlock(lastblock^.tag, ip, tmpptrs);
   END GenBlockExit;

   PROCEDURE GenBlockList;
      (* generate a list of the form

	 BlockList = POINTER TO BlockListRec;
	 BlockListRec =
	    RECORD
	       next: BlockList;
	       begin, end, tag: SysTypes.Address;
	    END;
      *)
      VAR
	 block: BlockList;
	 nextLabel: Label;
   BEGIN
      nextLabel.ok := FALSE;
      SetSegment(text);
      StrEmit1("%:l%_%n__BLOCKS", mainmod^.origname);
      block := blocks;
      WHILE block # NIL DO
	 IF nextLabel.ok THEN
	    EmitLabel(nextLabel);
	 END;
	 WITH block^ DO
	    IF next = NIL THEN
	       StrEmit1("%:L%c", nilvalue);
	    ELSE
	       GetLabel(nextLabel); StrEmit1("%:L%l", nextLabel);
	    END;
	    StrEmit1("%:L%l", begin);
	    StrEmit1("%:L%l", end);
	    StrEmit1("%:L%l", tag);
	 END;
	 block := block^.next;
      END;
   END GenBlockList;

   PROCEDURE GenProcEntry(procp: Ident);
      VAR
	 param: IdentList;
	 from, to: Reg;

      PROCEDURE CopyDynArray(varp: Ident);
	 VAR
	    sizeReg: Reg;
	    loopLabel: Label;
	    sourceReg: Reg;
	    endLabel: Label;
      BEGIN
	 IF varp^.type^.element^.size > 0 THEN
	    GetReg(sizeReg);
	    LoadDynArraySize(varp, sizeReg);
	    WITH varp^.type^ DO
	       IF element = byteptr THEN
		  GetLabel(endLabel);
		  Emit1(BEQ, "%l", endLabel);
	       ELSE
		  endLabel.ok := FALSE;
	       END;
	    END;
	    (* the contents of `sizeReg' is a multiple of oneword *)
	    StrEmit1("%*copy dynamic array %n", varp^.name);
	    GetAddrReg(sourceReg);
	    Emit4(LEA, "%L%([d,r],r),%r",
		       varp^.offset, base, sizeReg, sourceReg);
	    GetLabel(loopLabel);
	    EmitLabel(loopLabel);
	    Emit2(MOVE, "%L%-r,%-r", sourceReg, top);
	    Emit2(SUB, "%L%C,%r", oneword, sizeReg);
	    Emit1(BNE, "%l", loopLabel);
	    IF endLabel.ok THEN
	       EmitLabel(endLabel);
	    END;
	    FreeReg(sizeReg); FreeReg(sourceReg);
	 END;
	 Emit3(MOVE, "%L%r,%(d,r)", top, varp^.offset, base);
      END CopyDynArray;

   BEGIN
      IF ~errorflag THEN
	 GenVariables;
	 WITH procp^ DO
	    StrEmit("%*");
	    StrEmit1("%*PROCEDURE %n", name);
	    IF (plevel = global) & exported THEN
	       StrEmit2("%g%_%n_%n", mainmod^.name, name);
	       StrEmit2("%:l%_%n_%n", mainmod^.name, name);
	    END;
	    StrEmit2("%:l%_%n_%c", mainmod^.name, procno);
	 END;
	 GenBlockEntry(procp);
	 param := procp^.params;
	 WHILE param # NIL DO
	    WITH param^.ident^ DO
	       IF (type^.form = array) & type^.dyn & (varkind = copyparamV) THEN
		  (* dynamic arrays *)
		  CopyDynArray(param^.ident);
	       ELSIF varkind = copyparamV THEN
		  (* records or arrays *)
		  StrEmit2("%*copy parameter %n with size %c",
		     name, type^.size);
		  GetAddrReg(from); GetAddrReg(to);
		  Emit3(MOVE, "%L%(d,r),%r", ptroffset, base, from);
		  Emit3(LEA, "%(d,r),%r", offset, base, to);
		  MoveBytes(from, to, type^.size);
	       END;
	    END;
	    param := param^.link;
	 END;
	 InitLocalPointers(procp^.local);
	 EmitBeginBlock2(procp, pos.line);
      END;
      ccat := NIL;
   END GenProcEntry;

   PROCEDURE GenProcExit(procp: Ident);
   BEGIN
      IF ~errorflag THEN
	 IF procp^.type^.function THEN
	    StrEmit("%* function does not return any value");
	    Emit(JSR, "%_RTErrors_NoReturn");
	    StrEmit("%* NOT REACHED");
	 END;
	 EmitEndBlock1(procp, pos.line);
	 GenBlockExit(procp);
	 StrEmit1("%*END %n", procp^.name);
	 GenTypes;
      END;
   END GenProcExit;

   PROCEDURE GenPreamble;
      (* the preamble contains the code which is processed during
	 startup to build up various tables w/o initializing the module;
	 is the last code generation procedure to be called
      *)

      PROCEDURE GenPart1;
	 VAR
	    returnLabel: Label;
	    extmod: IdentList;
      BEGIN
	 GetLabel(returnLabel);
	 StrEmit2("%:B%_%n__pflag", oneword, mainmod^.origname);

	 SetSegment(text);
	 StrEmit("%*module preamble (part1 in topological order)");
	 StrEmit1("%g%_%n__TPRE", mainmod^.origname);
	 StrEmit1("%:l%_%n__TPRE", mainmod^.origname);

	 StrEmit("%*part1 of preamble already executed?");
	 IF environment = sun3 THEN
	    (* bug fix for SunOS 4.x (now fixed in SunOS 4.1.1)
	       further reference: GenExpr.om, PROC TestAndSet
	    *)
	    Emit1(TST, "%B%_%n__pflag", mainmod^.origname);
	 ELSE
	    Emit1(TAS, "%B%_%n__pflag", mainmod^.origname);
	 END;
	 Emit1(BNE, "%l", returnLabel);
	 IF environment = sun3 THEN
	    Emit2(MOVE, "%B%C,%_%n__pflag", 1, mainmod^.origname);
	 END;

	 StrEmit("%*execute preambles of imported modules");
	 extmod := extmods;
	 WHILE extmod # NIL DO
	    WITH extmod^ DO
	       IF (ident^.origname # mainmod^.origname) &
		  (ident^.origname # sysmodid) THEN
		  Emit1(JSR, "%_%n__TPRE", ident^.origname);
	       END;
	    END;
	    extmod := extmod^.link;
	 END;

	 IF commands THEN
	    StrEmit("%*insert module record for SysCommands");
	    Emit1(MOVE, "%L%_SysCommands_modules,%_%n__CMDS", mainmod^.origname);
	    Emit1(MOVE, "%L%#%_%n__CMDS,%_SysCommands_modules", mainmod^.origname);
	 END;

	 EmitLabel(returnLabel);
	 Emit(RTS, "");
      END GenPart1;

      PROCEDURE GenPart2;
      BEGIN
	 SetSegment(text);
	 StrEmit("%*module preamble (part2 in linkage order)");
	 StrEmit1("%g%_%n__PRE", mainmod^.origname);
	 StrEmit1("%:l%_%n__PRE", mainmod^.origname);
	 StrEmit("%*insert module record for SysModules");
	 Emit1(MOVE, "%L%_SysModules_modules,%_%n__MODS", mainmod^.origname);
	 Emit1(MOVE, "%L%#%_%n__MODS,%_SysModules_modules", mainmod^.origname);
	 StrEmit("%*init type tag ref of global variables");
	 Emit2(MOVE, "%L%#%_%n__GTAG,%_%n__GTAGREF",
		     mainmod^.origname, mainmod^.origname);
	 Emit(RTS, "");
      END GenPart2;

      PROCEDURE EmitModuleRec(modp: Ident);
      BEGIN
	 WITH modp^ DO
	    Assert(class = moduleC);
	    StrEmit1("%*SysModules.ModuleRec for %n", origname);
	    SetSegment(data); (* allow next component to be overwritten *)
	    StrEmit1("%:l%_%n__MODS", origname);
	    StrEmit1("%:L%c", 0);                   (* next := NIL *)
	    StrEmit1("%:L%_%n__NAME", origname);    (* name *)
	    StrEmit1("%:L%_%n", origname);          (* init (module body) *)
	    StrEmit1("%:L%_%n__BEGIN", origname);   (* begin *)
	    StrEmit1("%:L%_%n__END", origname);     (* end *)
	    StrEmit1("%:L%_%n__GTAGREF", origname); (* vars *)
	    StrEmit1("%:L%_%n__BLOCKS", origname);  (* blocks *)
	    StrEmit1("%:L%c", nofblocks);           (* nofblocks *)
	 END;
      END EmitModuleRec;

   BEGIN
      EmitName(mainmod);
      EmitModuleRec(mainmod);

      GenPart1;
      GenPart2;

      (* generate the last stuff *)
      SetSegment(text);
      EmitAlign;
      StrEmit1("%:l%_%n__END", mainmod^.origname);
      ccat := NIL;
   END GenPreamble;

   PROCEDURE GenModuleEntry;
      VAR
	 extmod: IdentList;
   BEGIN
      IF ~errorflag THEN
	 GenVariables;
	 StrEmit2("%:B%_%n__flag", oneword, mainmod^.origname);
	 IF commands THEN
	    GenCommands;
	 END;
	 SetSegment(text);
	 StrEmit("%*module body");
	 StrEmit1("%g%_%n", mainmod^.origname);
	 StrEmit1("%:l%_%n", mainmod^.origname);
	 GenBlockEntry(mainmod);
	 StrEmit("%*already initialized?");
	 IF environment = sun3 THEN
	    (* bug fix for SunOS 4.x (now fixed in SunOS 4.1.1)
	       further reference: GenExpr.om, PROC TestAndSet
	    *)
	    Emit1(TST, "%B%_%n__flag", mainmod^.origname);
	 ELSE
	    Emit1(TAS, "%B%_%n__flag", mainmod^.origname);
	 END;
	 Emit1(BNE, "%l", returnLabel);
	 IF environment = sun3 THEN
	    Emit2(MOVE, "%B%C,%_%n__flag", 1, mainmod^.origname);
	 END;
	 StrEmit("%*initialization of imported modules");
	 extmod := extmods;
	 WHILE extmod # NIL DO
	    WITH extmod^ DO
	       IF (ident^.origname # mainmod^.origname) &
		  (ident^.origname # sysmodid) THEN
		  EmitKey(ident);
		  Emit1(JSR, "%_%n", ident^.origname);
	       END;
	    END;
	    extmod := extmod^.link;
	 END;
	 StrEmit("%*local initializations");
	 EmitBeginBlock2(mainmod, pos.line);
      END;
      ccat := NIL;
   END GenModuleEntry;

   PROCEDURE GenModuleExit;
   BEGIN
      IF ~errorflag THEN
	 EmitEndBlock1(mainmod, pos.line);
	 GenBlockExit(mainmod);
	 StrEmit1("%*END %n", mainmod^.name);
	 EmitHeader(mainmod);
	 GenTypes;
	 GenExportedTypes;
	 GenBlockList;
	 GenStrings;
      END;
   END GenModuleExit;

BEGIN
   firstproc := TRUE;
   returnLabel.ok := FALSE;
   cmds := NIL; tail := NIL;
   blocks := NIL; lastblock := NIL; nofblocks := 0;
END GenBlocks.
