(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: GenStmts.m2,v 0.4 1994/03/17 10:33:22 borchert Exp $
   ----------------------------------------------------------------------------
   $Log: GenStmts.m2,v $
   Revision 0.4  1994/03/17  10:33:22  borchert
   bug fix: attributes were not cleaned up after assignment of short
            string constants

   Revision 0.3  1993/10/03  14:58:36  borchert
   several bug fixes due to last revision

   Revision 0.2  1993/10/02  15:19:38  borchert
   GenAssign reorganized due to a bug fix (see CodeGen release 0.12 to 0.13)

   Revision 0.1  1992/07/30  10:48:29  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

IMPLEMENTATION MODULE GenStmts; (* AFB 5/89 *)

   FROM Attributes IMPORT Attribute, AtMode, Reg, GetLabel, Label, LabelList,
      Labels, NewAttribute, returnLabel;
   FROM EmitCode IMPORT EmitLabel, Emit, Emit1, Emit2, StrEmit, StrEmit2;
   FROM Exception IMPORT Assert;
   FROM GenBasicOps IMPORT ccat, Load, LoadAddr, MoveBytesAt, ReturnAt,
      LoadCond, InvertTest, GenTest, LoadAndExtend, LoadReg, Convert;
   FROM GenExpr IMPORT GenExpr, GenLogExpr;
   FROM GenTypes IMPORT AssignRecs, AssignPtrs, TypeGuard;
   FROM Lex IMPORT Symbol, GetStringChar;
   FROM Machine IMPORT oneword;
   FROM Memory IMPORT ALLOCATE, DEALLOCATE;
   FROM Mnemonics IMPORT Mnemonic;
   FROM Scan IMPORT errorflag;
   FROM Standard IMPORT charptr, realptr, longrealptr;
   FROM SymTab IMPORT Type, Form, FormSet, Numeric, Size;

   PROCEDURE GenAssign(desat, exprat: Attribute);
      (* desat := exprat; both attributes are to be cleaned up *)
      VAR
	 size: Size; (* # bytes to be moved *)
	 ch: CHAR;
   BEGIN
      IF errorflag THEN RETURN END;
      IF desat^.attype^.form IN FormSet{record, pointer} THEN
	 IF desat^.mode # varAt THEN
	    GenExpr(desat);
	 END;
	 IF exprat^.mode # varAt THEN
	    GenExpr(exprat);
	 END;
	 IF desat^.attype^.form = record THEN
	    AssignRecs(desat, exprat);
	 ELSE
	    AssignPtrs(desat, exprat);
	 END;
      ELSIF (desat^.attype^.form = array) & (exprat^.attype = charptr) THEN
	 GenExpr(desat);
	 (* assignment of a string constant of length 1 *)
	 Assert(exprat^.mode = constAt);
	 WITH exprat^.cval DO
	    IF sy = stringcon THEN
	       GetStringChar(string, ch);
	       Emit2(MOVE, "%W%C,%a", ORD(ch) * 100H, desat);
	       GetStringChar(string, ch); Assert(ch = 0C);
	    ELSE
	       Emit2(MOVE, "%W%C,%a", ORD(charval) * 100H, desat);
	    END;
	 END;
	 ReturnAt(exprat); ReturnAt(desat);
      ELSE
	 GenExpr(exprat);
	 (* don't call GenExpr(desat) too early here because this
	    could run into difficulties if we are short of registers
	 *)
	 IF desat^.attype^.size = 0 THEN
	    GenExpr(desat); (* because of possible side effects *)
	 ELSIF (desat^.attype = realptr) OR (desat^.attype = longrealptr) THEN
	    GenExpr(desat);
	    Convert(exprat, desat^.attype);
	    Load(exprat);
	    Emit2(FMOVE, "%A%a,%a", exprat, desat);
	 ELSE
	    (* sizes can here only be different in case of
	       (1) string assignments where we have to take size of expr, and
	       (2) integer types where we have to convert the expr
	    *)
	    IF desat^.attype^.form IN Numeric THEN
	       Convert(exprat, desat^.attype);
	    END;
	    size := exprat^.attype^.size;
	    IF (size <= oneword) & (size = desat^.attype^.size) THEN
	       IF exprat^.mode = condMode THEN
		  Load(exprat);
	       END;
	       GenExpr(desat);
	       IF (exprat^.mode = constAt) &
		  (exprat^.cval.sy = intcon) &
		  (exprat^.cval.intval = 0) THEN
		  Emit1(CLR, "%A%a", desat);
	       ELSE
		  Emit2(MOVE, "%A%a,%a", exprat, desat);
	       END;
	    ELSE
	       GenExpr(desat);
	       MoveBytesAt(exprat, desat, size);
	       exprat := NIL; desat := NIL;
	    END;
	 END;
	 IF exprat # NIL THEN
	    ReturnAt(exprat);
	 END;
	 IF desat # NIL THEN
	    ReturnAt(desat);
	 END;
      END;
   END GenAssign;

   TYPE
      StatementType = (ifSt, whileSt, repeatSt, caseSt, loopSt);
      StatementList = POINTER TO StatementRec;
      StatementRec =
	 RECORD
	    link: StatementList;
	    CASE : StatementType OF
	    | ifSt:     elseLab, endifLab: Label;
	    | whileSt:  doLab, condLab: Label; condat: Attribute;
	    | repeatSt: repeatLab: Label;
	    | loopSt:   loopLab, exitLab: Label; nextloop: StatementList;
	    | caseSt:   caseat: Attribute;
			ofLab, elsecaseLab, endcaseLab: Label;
	    END;
	 END;

   VAR
      statements: StatementList;
      loops: StatementList;

   PROCEDURE Push(VAR statement: StatementList);
   BEGIN
      NEW(statement);
      statement^.link := statements;
      statements := statement;
   END Push;

   PROCEDURE Pop;
      VAR old: StatementList;
   BEGIN
      Assert(statements # NIL);
      old := statements;
      statements := statements^.link;
      DISPOSE(old);
   END Pop;

   PROCEDURE GenIfThen(condat: Attribute);
      VAR
	 new: StatementList;
   BEGIN
      StrEmit("%* IF-statement");
      GenExpr(condat);
      LoadCond(condat);
      WITH condat^ DO
	 InvertTest(test);
	 IF ~flabel.ok THEN
	    GetLabel(flabel);
	 END;
	 GenTest(test, atype, flabel);
	 IF tlabel.ok THEN
	    EmitLabel(tlabel);
	 END;
	 Push(new);
	 WITH new^ DO
	    elseLab := flabel;
	    GetLabel(endifLab);
	 END;
      END;
      ReturnAt(condat);
   END GenIfThen;

   PROCEDURE GenElsifThen(condat: Attribute);
   BEGIN
      WITH statements^ DO
	 Emit1(BRA, "%l", endifLab);
	 EmitLabel(elseLab);
      END;
      GenExpr(condat);
      LoadCond(condat);
      WITH condat^ DO
	 InvertTest(test);
	 IF ~flabel.ok THEN
	    GetLabel(flabel);
	 END;
	 GenTest(test, atype, flabel);
	 IF tlabel.ok THEN
	    EmitLabel(tlabel);
	 END;
	 WITH statements^ DO
	    elseLab := flabel;
	 END;
      END;
      ReturnAt(condat);
   END GenElsifThen;

   PROCEDURE GenElse;
   BEGIN
      WITH statements^ DO
	 Emit1(BRA, "%l", endifLab);
	 EmitLabel(elseLab);
	 elseLab.ok := FALSE;
      END;
   END GenElse;

   PROCEDURE GenEndIf;
   BEGIN
      StrEmit("%* END of IF-statement");
      WITH statements^ DO
	 IF elseLab.ok THEN
	    EmitLabel(elseLab);
	 END;
	 EmitLabel(endifLab);
      END;
      Pop;
   END GenEndIf;

   PROCEDURE GenWhileDo(at: Attribute);
      VAR
	 new: StatementList;
   BEGIN
      StrEmit("%* WHILE-statement");
      Push(new);
      WITH new^ DO
	 GetLabel(doLab);
	 GetLabel(condLab);
	 Emit1(BRA, "%l", condLab);
	 EmitLabel(doLab);
	 condat := at;
      END;
   END GenWhileDo;

   PROCEDURE GenEndWhile;
      VAR
	 endLabel: Label;
   BEGIN
      WITH statements^ DO
	 EmitLabel(condLab);
	 endLabel.ok := FALSE;
	 GenLogExpr(condat, doLab, endLabel);
	 WITH condat^ DO
	    GenTest(test, atype, doLab);
	 END;
	 ReturnAt(condat);
	 IF endLabel.ok THEN
	    EmitLabel(endLabel);
	 END;
      END;
      Pop;
   END GenEndWhile;

   PROCEDURE GenRepeat;
      VAR new: StatementList;
   BEGIN
      Push(new);
      WITH new^ DO
	 GetLabel(repeatLab);
	 EmitLabel(repeatLab);
      END;
   END GenRepeat;

   PROCEDURE GenUntil(at: Attribute);
      VAR
	 endLabel: Label;
   BEGIN
      WITH statements^ DO
	 endLabel.ok := FALSE;
	 GenLogExpr(at, endLabel, repeatLab);
	 WITH at^ DO
	    InvertTest(test);
	    GenTest(test, atype, repeatLab);
	 END;
      END;
      ReturnAt(at);
      IF endLabel.ok THEN
	 EmitLabel(endLabel);
      END;
      Pop;
   END GenUntil;

   PROCEDURE GenLoop;
      VAR new: StatementList;
   BEGIN
      Push(new);
      WITH new^ DO
	 GetLabel(loopLab);
	 EmitLabel(loopLab);
	 GetLabel(exitLab);
	 nextloop := loops;
      END;
      loops := new;
   END GenLoop;

   PROCEDURE GenExitLoop;
   BEGIN
      Emit1(BRA, "%l", loops^.exitLab);
   END GenExitLoop;

   PROCEDURE GenEndLoop;
   BEGIN
      Assert(loops = statements);
      Emit1(BRA, "%l", loops^.loopLab);
      EmitLabel(loops^.exitLab);
      loops := loops^.nextloop;
      Pop;
   END GenEndLoop;

   PROCEDURE GenCaseOf(at: Attribute);
      VAR
	 new: StatementList;
   BEGIN
      Push(new);
      WITH new^ DO
	 caseat := at;
	 GetLabel(ofLab);
	 GetLabel(endcaseLab);
	 elsecaseLab.ok := FALSE;
	 Emit1(BRA, "%l", ofLab);
      END;
   END GenCaseOf;

   PROCEDURE GenCase(labels: Labels);
      VAR
	 caseLab: Label;
   BEGIN
      WITH statements^ DO
	 IF labels^.count > 0 THEN
	    Emit1(BRA, "%l", endcaseLab);
	 END;
	 caseLab := ofLab;
	 caseLab.head := 'C'; caseLab.n2 := labels^.count;
	 EmitLabel(caseLab);
      END;
   END GenCase;

   PROCEDURE GenCaseElse(labels: Labels);
   BEGIN
      WITH statements^ DO
	 IF labels^.count > 0 THEN
	    Emit1(BRA, "%l", endcaseLab);
	 END;
	 GetLabel(elsecaseLab);
	 EmitLabel(elsecaseLab);
      END;
   END GenCaseElse;

   PROCEDURE GenEndCase(labels: Labels);
      VAR
	 range: LabelList;
	 next: INTEGER;
	 caseReg: Reg;
	 caseLab: Label;
	 posLabel: Label;
	 neg: BOOLEAN;

      PROCEDURE TestCase(low, high: INTEGER; caseLab: Label);
      BEGIN
	 IF neg & posLabel.ok & (high > 0) THEN
	    IF low <= 0 THEN
	       Emit1(BRA, "%l", caseLab);
	    END;
	    EmitLabel(posLabel);
	    posLabel.ok := FALSE;
	    next := 0;
	 END;
	 StrEmit2("%* case %i..%i", low, high);
	 IF neg & posLabel.ok & (high = 0) THEN
	    Emit1(BRA, "%l", caseLab);
	 ELSIF low = high THEN
	    IF next # low THEN
	       Emit2(SUB, "%L%C,%r", 1, caseReg);
	    END;
	    Emit1(BEQ, "%l", caseLab);
	    next := high;
	 ELSE
	    Emit2(SUB, "%L%I,%r", high+1-next, caseReg);
	    Emit1(BLT, "%l", caseLab);
	    next := high+1;
	 END;
      END TestCase;

   BEGIN
      WITH statements^ DO
	 Emit1(BRA, "%l", endcaseLab);
	 IF ~elsecaseLab.ok THEN
	    GetLabel(elsecaseLab);
	    EmitLabel(elsecaseLab);
	    StrEmit("%* attempt to find case failed");
	    Emit(JSR, "%_RTErrors_CaseError");
	    StrEmit("%* NOT REACHED");
	 END;
	 EmitLabel(ofLab);
	 GenExpr(caseat); LoadAndExtend(caseat); caseReg := caseat^.reg;
	 (* if neg is true we must avoid overflows *)
	 neg := caseat^.attype^.form IN FormSet{integer, longint};
	 WITH labels^ DO
	    IF neg THEN
	       IF (min <= 0) & (max > 0) THEN
		  GetLabel(posLabel);
	       ELSE
		  posLabel.ok := FALSE;
	       END;
	       IF ccat # caseat THEN
		  Emit1(TST, "%L%r", caseReg);
	       END;
	       IF min <= 0 THEN
		  IF posLabel.ok THEN
		     Emit1(BGT, "%l", posLabel);
		  ELSE
		     Emit1(BGT, "%l", elsecaseLab);
		  END;
	       ELSE
		  Emit1(BLE, "%l", elsecaseLab);
	       END;
	    END;
	    IF count > 0 THEN
	       range := head; next := 0;
	       IF range # NIL THEN
		  IF range^.low # MIN(INTEGER) THEN
		     TestCase(MIN(INTEGER), range^.low-1, elsecaseLab);
		  END;
		  LOOP
		     WITH range^ DO
			caseLab := ofLab;
			caseLab.head := 'C'; caseLab.n2 := case;
			TestCase(low, high, caseLab);
			IF link = NIL THEN EXIT END;
			IF high+1 < link^.low THEN
			   TestCase(high+1, link^.low-1, elsecaseLab);
			END;
		     END;
		     range := range^.link;
		  END;
	       END;
	    END;
	    Emit1(BRA, "%l", elsecaseLab);
	 END;
	 ReturnAt(caseat);
	 EmitLabel(endcaseLab);
      END;
      Pop;
   END GenEndCase;

   PROCEDURE GenReturn;
   BEGIN
      Emit1(BRA, "%l", returnLabel);
   END GenReturn;

   PROCEDURE GenReturnExpr(restype: Type; at: Attribute);
   BEGIN
      GenExpr(at); Convert(at, restype);
      WITH at^ DO
	 IF (restype = realptr) OR (restype = longrealptr) THEN
	    Emit2(FMOVE, "%A%a,%r", at, fp0);
	    ReturnAt(at);
	 ELSE
	    LoadReg(at, d0);
	 END;
      END;
      Emit1(BRA, "%l", returnLabel);
   END GenReturnExpr;

   PROCEDURE GenWith(at: Attribute; guard: Type);
      VAR
	 helpat: Attribute;
   BEGIN
      NewAttribute(helpat); helpat^ := at^;
      TypeGuard(helpat, guard);
      ReturnAt(helpat);
   END GenWith;

BEGIN
   statements := NIL; loops := NIL;
END GenStmts.
