(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: GenTypes.d,v 0.4 1993/09/27 12:51:21 borchert Exp $
   ----------------------------------------------------------------------------
   $Log: GenTypes.d,v $
   Revision 0.4  1993/09/27  12:51:21  borchert
   GenTypeTagForBlocks generates now informations about temporary pointers

   Revision 0.3  1993/04/13  15:09:19  borchert
   SysAllocate added for SYS.NEW
   originally, this was in the responsibility of GenExpr
   but GenTypes should have control about the whole
   memory management

   Revision 0.2  1993/02/03  12:51:44  borchert
   TypeTest changed
   generation of type tags for global variables and procedures

   Revision 0.1  1992/07/30  10:46:38  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

DEFINITION MODULE GenTypes; (* AFB 5/89 *)

   (* generate code for
      1) type guards
      2) allocation
      3) type tags
   *)

   FROM Attributes IMPORT Attribute, Label;
   FROM StackMan IMPORT PointerList;
   FROM SymTab IMPORT Ident, Type, IdentList, Size;

   PROCEDURE GetRecSize(at: Attribute; VAR sizeat: Attribute);
      (* get allocated size; varAt permitted *)

   PROCEDURE AssignRecs(desat, exprat: Attribute);
      (* assign `exprat' to `desat'; varAt permitted *)

   PROCEDURE AssignPtrs(desat, exprat: Attribute);
      (* assign `exprat' to `desat'; varAt permitted *)

   PROCEDURE PushTag(VAR at: Attribute);
      (* push tag of `at' onto stack; `at' is not modified if mode # varAt;
	 `mode' one of DesignatorModes
      *)

   PROCEDURE TypeGuard(VAR at: Attribute; type: Type);
      (* generate code for type guard; `at' is not modified if mode # varAt *)

   PROCEDURE TypeTest(VAR at: Attribute; type: Type;
		      VAR trueLab, falseLab: Label);
      (* set condition codes according to `at' IS `type';
	 at^.mode = varAt permitted
	 the execution continues at `trueLab' in case of TRUE;
	 GetLabel is called for trueLab and/or falseLab if
	 trueLab/falseLab.ok is not TRUE
      *)

   PROCEDURE Allocate(VAR at: Attribute);
      (* PRE: at^.mode IN GenModes + AtModeSet{varAt}
	 NEW is executed for at^.attype (GenModes)
			     type tag   (varAt)
	 `at' is released
      *)

   PROCEDURE SysAllocate(VAR at, size: Attribute);
      (* PRE: at^.mode IN GenModes + AtModeSet{varAt}
	      at^.attype must be a pointer type
	      size^.mode IN GetModes
	 SYS.NEW is executed for at
	 `at' and `size' are released
      *)

   PROCEDURE InitLocalPointers(vars: IdentList);
      (* to be called at procedure begin for initialization of
	 all pointers (NIL)
      *)

   PROCEDURE GenTypes;
      (* generate code for type tags *)

   PROCEDURE GenTypeTagForGlobals(globalVarSize: Size);
      (* generate type tag for all global variables together;
	 the list of global variables must have been processed by
	 GenVariables which assigns the offsets to the variables;
	 globalVarSize specifies the space occupied by the globals
      *)

   PROCEDURE GenTypeTagForBlock(label: Label; procp: Ident;
				tmpptrs: PointerList);
      (* emit the label and generate pointer list for the given procedure *)

   PROCEDURE GenExportedTypes;

END GenTypes.
