(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: Machine.m2,v 0.2 1993/06/18 15:32:26 borchert Exp $
   ----------------------------------------------------------------------------
   $Log: Machine.m2,v $
   Revision 0.2  1993/06/18  15:32:26  borchert
   Size has been moved to Types

   Revision 0.1  1992/07/30  10:48:45  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

IMPLEMENTATION MODULE Machine; (* AFB 1/89 *)

   FROM Scan IMPORT Error;
   FROM Types IMPORT Size;

   PROCEDURE Align(VAR size: Size);
   BEGIN
      IF ABS(size) MOD align # 0 THEN
	 IF size >= 0 THEN
	    IF size > maxint-align THEN
	       Error("size or offset exceeds MAX(INTEGER)");
	    ELSE
	       INC(size, align - size MOD align);
	    END;
	 ELSE
	    IF size < minint+align THEN
	       Error("offset exceeds MIN(INTEGER)");
	    ELSE
	       DEC(size, align - ABS(size) MOD align);
	    END;
	 END;
      END;
   END Align;

END Machine.
