(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: Memory.d,v 0.1 1992/07/30 10:46:54 borchert Exp $
   ----------------------------------------------------------------------------
   $Log: Memory.d,v $
   Revision 0.1  1992/07/30  10:46:54  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

DEFINITION MODULE Memory;		(* Martin Hasch, Jan 1989 *)
(*
 *	dynamic core space management with error handling
 *)

   FROM SYSTEM IMPORT ADDRESS;

   PROCEDURE ALLOCATE(VAR adr: ADDRESS; siz: CARDINAL);
      (* always successful *)

   PROCEDURE DEALLOCATE(VAR adr: ADDRESS; siz: CARDINAL);

   PROCEDURE CheckPtr(p: ADDRESS): BOOLEAN;
      (* returns FALSE if p can obviously not be a result of ALLOCATE *)
      (* this test can be used to avoid memory fault while processing	 *)
      (* error messages containing possibly uninitialized pointers, e.g. *)

   PROCEDURE MaxSpace(): CARDINAL;
      (* returns maximum size of dynamically allocated core space area *)

END Memory.
