(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: Memory.m2,v 0.1 1992/07/30 10:48:48 borchert Exp $
   ----------------------------------------------------------------------------
   $Log: Memory.m2,v $
   Revision 0.1  1992/07/30  10:48:48  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

IMPLEMENTATION MODULE Memory;		(* Martin Hasch, Jan 1989 *)
(*
 *	dynamic core space management with error handling
 *)

   FROM SYSTEM IMPORT ADDRESS;
   FROM Exception IMPORT Fatal;
   FROM Machine IMPORT bitsperword;
   IMPORT Storage;
   FROM SysLocations IMPORT Break;

   VAR
      minadr,
      maxadr:	CARDINAL;
      modulus:	BITSET;
      minbrk,
      maxbrk:	CARDINAL;

   PROCEDURE ALLOCATE(VAR adr: ADDRESS; siz: CARDINAL);
   BEGIN
      Storage.Setmode(2);
      Storage.ALLOCATE(adr,siz);
      Storage.Setmode(1);
      IF adr = NIL THEN
	 Fatal("%R: core space overflow")
      END;
      IF CARDINAL(adr) < minadr THEN
	 minadr := adr;
      END;
      IF CARDINAL(adr) > maxadr THEN
	 maxadr := adr;
      END;
      INCL(modulus, CARDINAL(adr) MOD bitsperword);
      IF CARDINAL(Break) > maxbrk THEN
	 maxbrk := Break;
      END;
   END ALLOCATE;

   PROCEDURE DEALLOCATE(VAR adr: ADDRESS; siz: CARDINAL);
   BEGIN
      Storage.DEALLOCATE(adr, siz);
   END DEALLOCATE;

   PROCEDURE CheckPtr(p: ADDRESS): BOOLEAN;
      (* returns FALSE if p can obviously not be a result of ALLOCATE *)
      (* this test can be used to avoid memory fault while processing	 *)
      (* error messages containing possibly uninitialized pointers, e.g. *)
   BEGIN
      RETURN
	 (minadr <= CARDINAL(p)) & (CARDINAL(p) <= maxadr) &
	 (CARDINAL(p) MOD bitsperword IN modulus)
   END CheckPtr;

   PROCEDURE MaxSpace(): CARDINAL;
      (* returns maximum size of dynamically allocated core space area *)
   BEGIN
      RETURN maxbrk - minbrk
   END MaxSpace;

BEGIN
   Storage.Setmode(1);
   minadr := MAX(CARDINAL);
   maxadr := 0;
   modulus := {};
   minbrk := Break;
   maxbrk := minbrk;
END Memory.
