(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: Messages.d,v 0.1 1992/07/30 10:46:58 borchert Exp $
   ----------------------------------------------------------------------------
   $Log: Messages.d,v $
   Revision 0.1  1992/07/30  10:46:58  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

DEFINITION MODULE Messages;		(* Martin Hasch, Jan 1989 *)
(*
 *	formatting of error messages
 *)

   FROM SYSTEM IMPORT BYTE;

   VAR
      writeproc: PROCEDURE(CHAR);		(* must be initialized! *)

   PROCEDURE PushArgument( (*read*)VAR arg: ARRAY OF BYTE);
      (* to be called with last argument first *)

   PROCEDURE PrintFormat( (*read*)VAR fmt: ARRAY OF CHAR);
      (* within fmt, the following tokens are substituted *)
      (* by parameter values:				  *)
      (* %c CARDINAL *)
      (* %C CHAR *)
      (* %Q CHAR, print quotes around it *)
      (* %i INTEGER *)
      (* %I '"' Identifier '"' *)
      (* %s ARRAY OF CHAR *)
      (* %R "implementation restriction", no parameter required *)
      (* %r "Oberon revision", no parameter required *)
      (* %t Calendar.Time, print date and time *)
      (* %d Calendar.Time, print date only *)
      (* %E system error message, parameter = errno *)
      (* %S system error message, no parameter required *)
      (* %T (n-th occurence) fill in blanks up to n-th tabulator position *)
      (* %n newline *)
      (* %% % *)

   PROCEDURE ClearTabs;

   PROCEDURE SetTab(tabpos: CARDINAL);
      (* (n-th call) define n-th tabulator position, left border = 1 *)

END Messages.
