(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: Oberon.m2,v 0.1 1992/07/30 10:48:59 borchert Exp $
   ----------------------------------------------------------------------------
   $Log: Oberon.m2,v $
   Revision 0.1  1992/07/30  10:48:59  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

MODULE Oberon;				(* Martin Hasch, Jan 1989 *)
(*
 *	main module
 *)

   FROM CodeGen IMPORT InitCodeGen;
   FROM Lex IMPORT InitLex;
   FROM Parser IMPORT Parse;
   FROM Scan IMPORT InitScan, EndScan, errorflag;
   FROM ScanArgs IMPORT ScanArguments, writeref, reffile;
   FROM SymRef IMPORT OpenRef, CloseRef;
   FROM SysExit IMPORT Exit;

BEGIN
   ScanArguments;
   IF writeref THEN
      OpenRef(reffile);
   END;
   InitScan;
   InitLex;
   InitCodeGen;
   Parse;
   EndScan;
   IF writeref THEN
      CloseRef;
   END;
   IF errorflag THEN
      Exit(1)
   END;
END Oberon.
