(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: Scan.d,v 0.1 1992/07/30 10:47:19 borchert Exp $
   ----------------------------------------------------------------------------
   $Log: Scan.d,v $
   Revision 0.1  1992/07/30  10:47:19  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

DEFINITION MODULE Scan;			(* Martin Hasch, Jan/Feb 1989 *)

   (* input buffering, error messages and listing *)

   FROM SYSTEM IMPORT BYTE;

   TYPE
      Pos = (* position in source *)
	 RECORD
	    line, pos: CARDINAL;
	 END;
      ErrorType = (headerinfo, warning, error, fatal, bug);

   VAR
      pos: Pos;			(* position of last ch read by GetCh *)
      ch: CHAR;			(* character read by GetCh *)
				(* ch = 0C at end of file  *)
      errorflag: BOOLEAN;	(* FALSE as long as no error/fatal/bug *)
				(* occured, otherwise TRUE	       *)
      symbolcount: CARDINAL;	(* incremented by Lex, for statistics *)
      outputcount: CARDINAL;	(* incremented by CodeGen, for statistics *)

   PROCEDURE GetCh;

   PROCEDURE At(pos: Pos);
      (* override default error position for next Error-call *)

   PROCEDURE Error(msg: ARRAY OF CHAR);

   PROCEDURE Error1(msg: ARRAY OF CHAR; p1: ARRAY OF BYTE);
      (* msg: *)
      (* %s ARRAY OF CHAR *)
      (* %% % *)
      (* etc. etc. (see Messages) *)

   PROCEDURE Error2(msg: ARRAY OF CHAR; p1, p2: ARRAY OF BYTE);

   PROCEDURE Error3(msg: ARRAY OF CHAR; p1, p2, p3: ARRAY OF BYTE);

   PROCEDURE Error4(msg: ARRAY OF CHAR; p1, p2, p3, p4: ARRAY OF BYTE);

   PROCEDURE ErrorList(msg: ARRAY OF CHAR);
      (* produce long error messages, e.g. error message about *)
      (* exported but undefined procedures *)
      (* ErrorList { AddToList } EndOfList *)

   PROCEDURE AddToList(msg: ARRAY OF CHAR; p1: ARRAY OF BYTE);

   PROCEDURE EndOfList;

   PROCEDURE Message(et: ErrorType; msg: ARRAY OF CHAR);

   PROCEDURE Message1(et: ErrorType; msg: ARRAY OF CHAR; p1: ARRAY OF BYTE);

   PROCEDURE Message2(et: ErrorType; msg: ARRAY OF CHAR; p1,p2: ARRAY OF BYTE);

   PROCEDURE Message3(et: ErrorType;   msg: ARRAY OF CHAR;
				       p1,p2,p3: ARRAY OF BYTE);

   PROCEDURE Message4(et: ErrorType;   msg: ARRAY OF CHAR;
				       p1,p2,p3,p4: ARRAY OF BYTE);

   PROCEDURE InitScan;
      (* to be called after argument scanning *)

   PROCEDURE EndScan;
      (* to be called when compilation is finished *)

END Scan.
