(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: ScanArgs.d,v 0.3 1993/04/19 14:35:28 borchert Exp $
   ----------------------------------------------------------------------------
   $Log: ScanArgs.d,v $
   Revision 0.3  1993/04/19  14:35:28  borchert
   version string may be given as option

   Revision 0.2  1993/02/03  12:53:29  borchert
   ``output'' may be assembly output or symbol file (comment changed)

   Revision 0.1  1992/07/30  10:47:23  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

DEFINITION MODULE ScanArgs;		(* Martin Hasch, Dec 1988 *)

   (* scan arguments and some environment parameters *)

   FROM Calendar IMPORT Time;

   TYPE
      FileName = ARRAY [0..511] OF CHAR;
      Path = POINTER TO PathRec;
      PathRec =
	 RECORD
	    symfile: FileName;	(* symbol file or archive with symbolfiles *)
	    link: Path;
	 END;
      VersionString = ARRAY [0..31] OF CHAR;

   TYPE
      UpdateMode =
	 (noUpdate,		(* no authorization for updates *)
	 softUpdate,		(* update only if necessary *)
	 hardUpdate);		(* update if sizes are different *)

   VAR
      input: FileName;		(* source file *)
      output: FileName;		(* assembly output or symbol file *)
      dolist: BOOLEAN;		(* create a listing ? *)
      listing: FileName;	(* listing file *)
      updatesym: UpdateMode;	(* authorized to update symbol file? *)
      commands: BOOLEAN;	(* parameterless global procs = commands? *)
      sympath: Path;		(* search path for symbol files *)
      defunit: BOOLEAN;		(* source file with definition suffix? *)
      currenttime,
      lastrevision: Time;
      writeref: BOOLEAN;	(* writing a reference file? *)
      reffile: FileName;	(* name of reference file *)
      version: VersionString;   (* version to be printed for listings *)

   PROCEDURE ScanArguments;

END ScanArgs.
