(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: Standard.d,v 0.3 1993/09/27 13:04:49 borchert Exp $
   ----------------------------------------------------------------------------
   $Log: Standard.d,v $
   Revision 0.3  1993/09/27  13:04:49  borchert
   addrptr and untracedaddrptr added

   Revision 0.2  1993/06/16  09:43:48  borchert
   int16ptr added for SYSTEM.INT16

   Revision 0.1  1992/07/30  10:47:30  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

DEFINITION MODULE Standard; (* AFB 1/89 *)

   (* definition of standard names *)

   FROM IdentSys IMPORT Identifier;
   FROM SymTab IMPORT Ident, Type;

   VAR
      boolptr: Type;
      charptr: Type;
      shortptr: Type;
      int16ptr: Type;
      intptr: Type;
      longptr: Type;
      addrptr: Type;
      untracedaddrptr: Type;
      realptr: Type;
      longrealptr: Type;
      setptr: Type;
      byteptr: Type;
      niltype: Type;		(* type of NIL *)

      sysmodid: Identifier;	(* name of SYSTEM module *)
      sigprocptr: Type;		(* type of a signal catching procedure *)
      crptr: Type;		(* type of a coroutine *)

   PROCEDURE InitStd;

   PROCEDURE InitSysModule(VAR sysmod: Ident);

END Standard.
