(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: Standard.m2,v 0.4 1993/09/27 13:05:15 borchert Exp $
   ----------------------------------------------------------------------------
   $Log: Standard.m2,v $
   Revision 0.4  1993/09/27  13:05:15  borchert
   SYSTEM.ADDRESS and SYSTEM.UNTRACEDADDRESS added

   Revision 0.3  1993/06/18  15:28:46  borchert
   UNIXCALL, UNIXFORK and UNIXSIGNAL are now only exported by SYSTEM
   if our environment is UNIX

   Revision 0.2  1993/06/16  09:46:15  borchert
   SYSTEM.INT16 added

   Revision 0.1  1992/07/30  10:49:29  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

IMPLEMENTATION MODULE Standard; (* AFB 1/89 *)
                                (* REV AFB 12/89: Oberon revision *)

   FROM Lex IMPORT boolcon;
   FROM Exception IMPORT Assert;
   FROM IdentSys IMPORT Identifier, PutIdentChar, PutIdent;
   FROM Machine IMPORT onebyte, oneshort, oneint16, oneword, onelong,
      onereal, onelreal, environment, unix;
   FROM SymTab IMPORT Type, Ident, Form, IdentClass, Size, StdProc, Enter,
      OpenScope, Level, IdentList, VarKind, address;
   FROM Memory IMPORT ALLOCATE;

   CONST
      sysmodName = "SYSTEM";

   PROCEDURE InitName(s: ARRAY OF CHAR; VAR id: Identifier);
      VAR
	 i: CARDINAL;
   BEGIN
      i := 0;
      WHILE (i <= HIGH(s)) & (s[i] # 0C) DO
	 PutIdentChar(s[i]);
	 INC(i);
      END;
      PutIdent(id);
   END InitName;

   PROCEDURE InitBoolConst(s: ARRAY OF CHAR; val: BOOLEAN; ctype: Type);
      VAR
	 id: Identifier;
	 ip: Ident;
   BEGIN
      InitName(s, id);
      Assert(Enter(id, constC, ip));
      WITH ip^ DO
	 mod := NIL;
	 type := ctype;
	 WITH constval DO
	    sy := boolcon;
	    boolval := val;
	 END;
      END;
   END InitBoolConst;

   PROCEDURE InitTypeIdent(s: ARRAY OF CHAR;
		           tform: Form; tsize: Size; VAR basetype: Type;
			   enter: BOOLEAN);
      VAR
	 id: Identifier;
	 ip: Ident;
   BEGIN
      InitName(s, id);
      IF enter THEN
	 Assert(Enter(id, typeC, ip));
      ELSE
	 NEW(ip);
      END;
      WITH ip^ DO
	 IF ~enter THEN
	    name := id;
	    identno := 0;
	    error := FALSE;
	    class := typeC;
	 END;
	 mod := NIL;
	 NEW(type);
	 basetype := type;
	 WITH type^ DO
	    link := NIL;
	    typeno := 0;
	    ident := ip;
	    size := tsize;
	    form := tform;
	    privateparts := FALSE;
	    sizemodified := FALSE;
	    containsptr := FALSE;
	    IF form = address THEN
	       treatAsAddress := FALSE;
	    END;
	 END;
      END;
   END InitTypeIdent;

   PROCEDURE InitType(s: ARRAY OF CHAR;
		      tform: Form; tsize: Size; VAR basetype: Type);
   BEGIN
      InitTypeIdent(s, tform, tsize, basetype, (* enter = *) TRUE);
   END InitType;

   PROCEDURE InitExportedType(s: ARRAY OF CHAR;
			      tform: Form; tsize: Size; VAR basetype: Type;
			      VAR export: IdentList);
      VAR
	 new: IdentList;
   BEGIN
      InitTypeIdent(s, tform, tsize, basetype, (* enter = *) FALSE);
      NEW(new);
      WITH new^ DO
	 ident := basetype^.ident;
	 link := export;
      END;
      export := new;
   END InitExportedType;

   PROCEDURE InitStdProcIdent(s: ARRAY OF CHAR; stdp: StdProc; func: BOOLEAN;
			      VAR ip: Ident; enter: BOOLEAN);
      VAR
	 id: Identifier;
   BEGIN
      InitName(s, id);
      IF enter THEN
	 Assert(Enter(id, procedureC, ip));
      ELSE
	 NEW(ip);
      END;
      WITH ip^ DO
	 IF ~enter THEN
	    name := id;
	    identno := 0;
	    error := FALSE;
	    class := procedureC;
	    plevel := Level();
	 END;
	 mod := NIL;
	 local := NIL;
	 params := NIL;
	 parmoffset := 0;
	 varoffset := 0;
	 procno := 0;
	 forward := FALSE;
	 NEW(type);
	 WITH type^ DO
	    ident := NIL;
	    size := oneword;
	    form := proceduretype;
	    function := func;
	    IF function THEN
	       restype := NIL;
	    END;
	    std := TRUE;
	    stdproc := stdp;
	 END;
      END;
   END InitStdProcIdent;

   PROCEDURE InitStdProc(s: ARRAY OF CHAR; stdp: StdProc; func: BOOLEAN);
      VAR
	 ip: Ident;
   BEGIN
      InitStdProcIdent(s, stdp, func, ip, (* enter = *) TRUE);
   END InitStdProc;

   PROCEDURE InitExportedStdProc(s: ARRAY OF CHAR; stdp: StdProc;
				 func: BOOLEAN;
				 VAR export: IdentList);
      VAR
	 ip: Ident;
	 new: IdentList;
   BEGIN
      InitStdProcIdent(s, stdp, func, ip, (* enter = *) FALSE);
      NEW(new);
      WITH new^ DO
	 ident := ip;
	 link := export;
      END;
      export := new;
   END InitExportedStdProc;

   PROCEDURE InitStd;
   BEGIN
      InitType("BOOLEAN",  boolean,  onebyte,  boolptr);
      InitType("CHAR",     char,     onebyte,  charptr);
      InitType("SHORTINT", shortint, oneshort, shortptr);
      InitType("INTEGER",  integer,  oneword,  intptr);
      InitType("LONGINT",  longint,  onelong,  longptr);
      InitType("REAL",     real,     onereal,  realptr);
      InitType("LONGREAL", longreal, onelreal, longrealptr);
      InitType("SET",      set,      oneword,  setptr);
      InitType("BYTE",     byte,     onebyte,  byteptr);

      InitType("NIL-TYPE", pointer,  oneword,  niltype);
      niltype^.reftype := NIL;

      InitBoolConst("FALSE", FALSE, boolptr);
      InitBoolConst("TRUE",  TRUE,  boolptr);

      InitStdProc("ABS",    absF,    TRUE);
      InitStdProc("ODD",    oddF,    TRUE);
      InitStdProc("CAP",    capF,    TRUE);
      InitStdProc("ASH",    ashF,    TRUE);
      InitStdProc("LEN",    lenF,    TRUE);
      InitStdProc("MAX",    maxF,    TRUE);
      InitStdProc("MIN",    minF,    TRUE);
      InitStdProc("ORD",    ordF,    TRUE);
      InitStdProc("CHR",    chrF,    TRUE);
      InitStdProc("SHORT",  shortF,  TRUE);
      InitStdProc("LONG",   longF,   TRUE);
      InitStdProc("ENTIER", entierF, TRUE);

      InitStdProc("INC",    incP,    FALSE);
      InitStdProc("DEC",    decP,    FALSE);
      InitStdProc("INCL",   inclP,   FALSE);
      InitStdProc("EXCL",   exclP,   FALSE);
      InitStdProc("COPY",   copyP,   FALSE);
      InitStdProc("NEW",    newP,    FALSE);
      InitStdProc("HALT",   haltP,   FALSE);

      OpenScope;

      InitName(sysmodName, sysmodid);
   END InitStd;

   PROCEDURE InitSysModule(VAR sysmod: Ident);

      VAR
	 il: IdentList;

      PROCEDURE InitType(VAR t: Type);
      BEGIN
	 NEW(t);
	 WITH t^ DO
	    ident := NIL;
	    refcnt := 0;
	    typeno := 0;
	    tagno := 0;
	    size := oneword;
	    link := NIL;
	    privateparts := FALSE;
	    sizemodified := FALSE;
	    containsptr := FALSE;
	 END;
      END InitType;

   BEGIN
      (* NEW(sysmod); --- is done by ReadSymFile *)
      WITH sysmod^ DO
	 name := sysmodid;
	 identno := 0;
	 error := FALSE;
	 class := moduleC;
	 key.time := 0; key.pid := 0;
	 export := NIL;
	 origname := name;
	 modid := 0;

	 InitExportedStdProc("ADR",          adrF,          TRUE,  export);
	 InitExportedStdProc("BIT",          bitF,          TRUE,  export);
	 InitExportedStdProc("LSH",          lshF,          TRUE,  export);
	 InitExportedStdProc("ROT",          rotF,          TRUE,  export);
	 InitExportedStdProc("SIZE",         sizeF,         TRUE,  export);
	 InitExportedStdProc("VAL",          valF,          TRUE,  export);

	 InitExportedStdProc("GET",          getP,          FALSE, export);
	 InitExportedStdProc("PUT",          putP,          FALSE, export);
	 InitExportedStdProc("MOVE",         moveP,         FALSE, export);
	 InitExportedStdProc("NEW",          sysnewP,       FALSE, export);

	 (* additions for Ulm's version *)
	 IF environment IN unix THEN
	    InitExportedStdProc("UNIXCALL",     unixcallF,     TRUE,  export);
	    InitExportedStdProc("UNIXFORK",     unixforkF,     TRUE,  export);
	    InitExportedStdProc("UNIXSIGNAL",   unixsignalF,   TRUE,  export);
	 END;
	 InitExportedStdProc("TAS",          tasF,          TRUE,  export);

	 InitExportedStdProc("CRSPAWN",      crspawnP,      FALSE, export);
	 InitExportedStdProc("CRSWITCH",     crswitchP,     FALSE, export);
	 InitExportedStdProc("HALT",         syshaltP,      FALSE, export);
	 InitExportedStdProc("WMOVE",        wmoveP,        FALSE, export);
	 InitExportedStdProc("WCLEAR",       wclearP,       FALSE, export);

	 InitExportedType("INT16",   int16,   oneint16, int16ptr, export);
	 InitExportedType("ADDRESS", address, onelong,  addrptr,  export);
	 addrptr^.treatAsAddress := TRUE;
	 addrptr^.containsptr := TRUE;
	 InitExportedType("UNTRACEDADDRESS", address, onelong,
	    untracedaddrptr, export);
	 untracedaddrptr^.treatAsAddress := TRUE;
	 untracedaddrptr^.containsptr := FALSE;

	 (* coroutine type *)
	 InitExportedType("COROUTINE", pointer, oneword, crptr, export);
	 crptr^.containsptr := TRUE;
	 crptr^.taggedptr := FALSE; (* this causes NEW(cr) to be rejected *)
	 InitType(crptr^.reftype);
	 WITH crptr^.reftype^ DO
	    (* see GenExpr.m2, CrSpawn *)
	    size := 4 * oneword; (* size is not of importance *)
	    form := record;
	    basetype := NIL;
	    fields := NIL; (* fields are not accessable *)
	    projection := FALSE;
	 END;
      END;
      il := sysmod^.export;
      WHILE il # NIL DO
	 il^.ident^.mod := sysmod;
	 il := il^.link;
      END;

      (* this code is very "clumsy" but we cannot use SymDef if
	 we want to avoid reference cycles

	 type of signal catching procedure:

	 PROCEDURE CatchSignal(signal: INTEGER; sysinfo: ARRAY OF BYTE);
	    (* the type of `signal' should be imported from
	       SystemTypes or the like;
	       `sysinfo' is system-dependant information
	       (e.g. type of FP-exception)
	    *)

	 this type is used for the second parameter of the
	 SYS.UNIXSIGNAL standard function
      *)
      InitType(sigprocptr);
      WITH sigprocptr^ DO
	 form := proceduretype;
	 function := FALSE;
	 std := FALSE;
	 NEW(param);
	 WITH param^ DO
	    InitName("signal", id);
	    type := intptr;
	    varkind := paramV;
	    offset := 0;
	    NEW(link);
	    WITH link^ DO
	       InitName("sysinfo", id);
	       InitType(type);
	       WITH type^ DO
		  form := array;
		  dyn := TRUE;
		  element := byteptr;
	       END;
	       varkind := copyparamV;
	       offset := 0;
	       link := NIL;
	    END;
	 END;
      END;
   END InitSysModule;

END Standard.
